/*
 * Decompiled with CFR 0.152.
 */
package cn.skcks.docking.gb28181.core.sip.utils;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.util.IdUtil;
import cn.skcks.docking.gb28181.common.config.ProjectConfig;
import cn.skcks.docking.gb28181.core.sip.dto.RemoteInfo;
import gov.nist.javax.sip.address.AddressImpl;
import gov.nist.javax.sip.address.SipUri;
import gov.nist.javax.sip.header.Subject;
import gov.nist.javax.sip.message.SIPRequest;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import javax.sip.PeerUnavailableException;
import javax.sip.SipFactory;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.UserAgentHeader;
import javax.sip.message.Request;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class SipUtil
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(SipUtil.class);
    private static ProjectConfig projectConfig;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        projectConfig = (ProjectConfig)applicationContext.getBean(ProjectConfig.class);
    }

    public static String getUserIdFromFromHeader(FromHeader fromHeader) {
        AddressImpl address = (AddressImpl)fromHeader.getAddress();
        SipUri uri = (SipUri)address.getURI();
        return uri.getUser();
    }

    public static String getUserIdFromFromHeader(Request request) {
        FromHeader fromHeader = (FromHeader)request.getHeader("From");
        return SipUtil.getUserIdFromFromHeader(fromHeader);
    }

    public static String getChannelIdFromRequest(Request request) {
        Header subject = request.getHeader("subject");
        if (subject == null) {
            return null;
        }
        return ((Subject)subject).getSubject().split(":")[0];
    }

    public static String generateViaTag() {
        return "z9hG4bK" + RandomStringUtils.randomNumeric((int)10);
    }

    public static UserAgentHeader createUserAgentHeader() throws PeerUnavailableException, ParseException {
        ArrayList<String> agentParam = new ArrayList<String>();
        agentParam.add("GB28181-Docking-Platform");
        agentParam.add(" ");
        agentParam.add(StringUtils.replace((String)projectConfig.getVersion(), (String)"-SNAPSHOT", (String)""));
        return SipFactory.getInstance().createHeaderFactory().createUserAgentHeader(agentParam);
    }

    public static String generateFromTag() {
        return IdUtil.fastSimpleUUID();
    }

    public static String generateTag() {
        return String.valueOf(System.currentTimeMillis());
    }

    public static RemoteInfo getRemoteInfoFromRequest(SIPRequest request, boolean sipUseSourceIpAsRemoteAddress) {
        int remotePort;
        String remoteAddress;
        if (sipUseSourceIpAsRemoteAddress) {
            remoteAddress = request.getPeerPacketSourceAddress().getHostAddress();
            remotePort = request.getPeerPacketSourcePort();
        } else {
            remoteAddress = request.getTopmostViaHeader().getReceived();
            remotePort = request.getTopmostViaHeader().getRPort();
            if (ObjectUtils.isEmpty((Object)remoteAddress) || remotePort == -1) {
                remoteAddress = request.getPeerPacketSourceAddress().getHostAddress();
                remotePort = request.getPeerPacketSourcePort();
            }
        }
        return new RemoteInfo(remoteAddress, remotePort);
    }

    public static String cmdString(int leftRight, int upDown, int inOut, int moveSpeed, int zoomSpeed) {
        int cmdCode = 0;
        if (leftRight == 2) {
            cmdCode |= 1;
        } else if (leftRight == 1) {
            cmdCode |= 2;
        }
        if (upDown == 2) {
            cmdCode |= 4;
        } else if (upDown == 1) {
            cmdCode |= 8;
        }
        if (inOut == 2) {
            cmdCode |= 0x10;
        } else if (inOut == 1) {
            cmdCode |= 0x20;
        }
        StringBuilder builder = new StringBuilder("A50F01");
        String strTmp = String.format("%02X", cmdCode);
        builder.append(strTmp, 0, 2);
        strTmp = String.format("%02X", moveSpeed);
        builder.append(strTmp, 0, 2);
        builder.append(strTmp, 0, 2);
        if (zoomSpeed > 0 && zoomSpeed < 16) {
            zoomSpeed = 16;
        }
        strTmp = String.format("%X", zoomSpeed);
        builder.append(strTmp, 0, 1).append("0");
        int checkCode = (181 + cmdCode + moveSpeed + moveSpeed + (zoomSpeed & 0xF0)) % 256;
        strTmp = String.format("%02X", checkCode);
        builder.append(strTmp, 0, 2);
        return builder.toString();
    }

    public static String getSsrcFromSdp(String sdpStr) {
        String[] lines;
        int ssrcIndex = sdpStr.indexOf("y=");
        if (ssrcIndex == 0) {
            return null;
        }
        for (String line : lines = sdpStr.split("\\r?\\n")) {
            if (!line.trim().startsWith("y=")) continue;
            return line.substring(2);
        }
        return null;
    }

    public static String parseTime(String timeStr) {
        LocalDateTime localDateTime;
        if (ObjectUtils.isEmpty((Object)timeStr)) {
            return null;
        }
        try {
            localDateTime = LocalDateTime.parse(timeStr);
        }
        catch (DateTimeParseException e) {
            try {
                localDateTime = LocalDateTimeUtil.parse((CharSequence)timeStr, (String)"yyyy-MM-dd'T'HH:mm:ss");
            }
            catch (DateTimeParseException e2) {
                log.error("[\u683c\u5f0f\u5316\u65f6\u95f4] \u65e0\u6cd5\u683c\u5f0f\u5316\u65f6\u95f4\uff1a {}", (Object)timeStr);
                return null;
            }
        }
        return localDateTime.format(DatePattern.NORM_DATETIME_FORMATTER.withZone(ZoneId.of("Asia/Shanghai")));
    }
}

