/*
 * Decompiled with CFR 0.152.
 */
package cn.skcks.docking.gb28181.service.catalog;

import cn.skcks.docking.gb28181.common.json.JsonException;
import cn.skcks.docking.gb28181.config.sip.SipConfig;
import cn.skcks.docking.gb28181.core.sip.message.request.SipRequestBuilder;
import cn.skcks.docking.gb28181.core.sip.message.subscribe.GenericSubscribe;
import cn.skcks.docking.gb28181.core.sip.message.subscribe.SipSubscribe;
import cn.skcks.docking.gb28181.core.sip.service.SipService;
import cn.skcks.docking.gb28181.orm.mybatis.dynamic.model.DockingDevice;
import cn.skcks.docking.gb28181.service.catalog.CatalogSubscriber;
import cn.skcks.docking.gb28181.service.device.DeviceChannelService;
import cn.skcks.docking.gb28181.service.docking.device.cache.DockingDeviceCacheService;
import cn.skcks.docking.gb28181.sip.manscdp.catalog.query.CatalogQueryDTO;
import cn.skcks.docking.gb28181.sip.manscdp.catalog.response.CatalogItemDTO;
import cn.skcks.docking.gb28181.sip.method.message.request.MessageRequestBuilder;
import cn.skcks.docking.gb28181.sip.utils.MANSCDPUtils;
import cn.skcks.docking.gb28181.sip.utils.SipUtil;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.sip.SipProvider;
import javax.sip.message.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CatalogService {
    private static final Logger log = LoggerFactory.getLogger(CatalogService.class);
    private final SipService sipService;
    private final DockingDeviceCacheService deviceCacheService;
    private final SipConfig sipConfig;
    private final SipSubscribe subscribe;
    private final DeviceChannelService deviceChannelService;

    public CompletableFuture<List<CatalogItemDTO>> catalog(String gbDeviceId) {
        CompletableFuture<List<CatalogItemDTO>> result = new CompletableFuture<List<CatalogItemDTO>>();
        result.completeOnTimeout(Collections.emptyList(), 60L, TimeUnit.SECONDS);
        DockingDevice device = this.deviceCacheService.getDevice(gbDeviceId);
        if (device == null) {
            log.info("\u672a\u80fd\u627e\u5230 \u7f16\u7801\u4e3a => {} \u7684\u8bbe\u5907", (Object)gbDeviceId);
            result.completeExceptionally((Throwable)new JsonException("\u672a\u627e\u5230\u8bbe\u5907 " + gbDeviceId));
            return result;
        }
        SipProvider provider = this.sipService.getProvider(device.getTransport(), device.getLocalIp());
        MessageRequestBuilder requestBuilder = ((MessageRequestBuilder.MessageRequestBuilderBuilder)((MessageRequestBuilder.MessageRequestBuilderBuilder)((MessageRequestBuilder.MessageRequestBuilderBuilder)((MessageRequestBuilder.MessageRequestBuilderBuilder)((MessageRequestBuilder.MessageRequestBuilderBuilder)((MessageRequestBuilder.MessageRequestBuilderBuilder)((MessageRequestBuilder.MessageRequestBuilderBuilder)MessageRequestBuilder.builder().localIp(device.getLocalIp())).localId(this.sipConfig.getId())).localPort(this.sipConfig.getPort().intValue())).transport(device.getTransport())).targetId(device.getDeviceId())).targetIp(device.getIp())).targetPort(device.getPort().intValue())).build();
        String callId = provider.getNewCallId().getCallId();
        long cSeq = SipRequestBuilder.getCSeq();
        String sn = SipUtil.generateSn();
        CatalogQueryDTO catalogQueryDTO = CatalogQueryDTO.builder().deviceId(gbDeviceId).sn(sn).build();
        Request request = requestBuilder.createMessageRequest(callId, cSeq, MANSCDPUtils.toByteXml((Object)catalogQueryDTO, (String)device.getCharset()));
        String key = GenericSubscribe.Helper.getKey("Catalog", gbDeviceId, sn);
        this.subscribe.getSipRequestSubscribe().addPublisher(key, 60L, TimeUnit.SECONDS);
        this.subscribe.getSipRequestSubscribe().addSubscribe(key, new CatalogSubscriber(this.subscribe, key, result, device.getDeviceId(), this.deviceChannelService::add));
        provider.sendRequest(request);
        return result;
    }

    public CatalogService(SipService sipService, DockingDeviceCacheService deviceCacheService, SipConfig sipConfig, SipSubscribe subscribe, DeviceChannelService deviceChannelService) {
        this.sipService = sipService;
        this.deviceCacheService = deviceCacheService;
        this.sipConfig = sipConfig;
        this.subscribe = subscribe;
        this.deviceChannelService = deviceChannelService;
    }
}

