/*
 * Decompiled with CFR 0.152.
 */
package cn.skcks.docking.gb28181.service.catalog;

import cn.skcks.docking.gb28181.core.sip.message.subscribe.SipSubscribe;
import cn.skcks.docking.gb28181.orm.mybatis.dynamic.model.DockingDeviceChannel;
import cn.skcks.docking.gb28181.sip.manscdp.catalog.response.CatalogItemDTO;
import cn.skcks.docking.gb28181.sip.manscdp.catalog.response.CatalogResponseDTO;
import cn.skcks.docking.gb28181.sip.utils.MANSCDPUtils;
import gov.nist.javax.sip.message.SIPRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogSubscriber
implements Flow.Subscriber<SIPRequest> {
    private static final Logger log = LoggerFactory.getLogger(CatalogSubscriber.class);
    private final SipSubscribe subscribe;
    private final String key;
    private final CompletableFuture<List<CatalogItemDTO>> result;
    private final String deviceId;
    private final Consumer<? super DockingDeviceChannel> addDeviceChannelFunc;
    private Flow.Subscription subscription;
    private final AtomicLong num = new AtomicLong(0L);
    private long sumNum = 0L;
    private final List<CatalogItemDTO> data = new ArrayList<CatalogItemDTO>();

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        this.subscription = subscription;
        subscription.request(1L);
    }

    @Override
    public void onNext(SIPRequest item) {
        CatalogResponseDTO catalogResponseDTO = (CatalogResponseDTO)MANSCDPUtils.parse((byte[])item.getRawContent(), CatalogResponseDTO.class);
        this.sumNum = Math.max(this.sumNum, catalogResponseDTO.getSumNum());
        long curNum = this.num.addAndGet(catalogResponseDTO.getDeviceList().getNum().intValue());
        log.debug("\u5f53\u524d\u83b7\u53d6\u6570\u91cf: {}/{}", (Object)curNum, (Object)this.sumNum);
        this.data.addAll(catalogResponseDTO.getDeviceList().getDeviceList());
        if (curNum >= this.sumNum) {
            log.info("\u83b7\u53d6\u5b8c\u6210 {}", (Object)this.key);
            this.subscribe.getSipRequestSubscribe().complete(this.key);
        } else {
            this.subscription.request(1L);
        }
    }

    @Override
    public void onError(Throwable throwable) {
        throwable.printStackTrace();
        this.onComplete();
    }

    @Override
    public void onComplete() {
        log.info("{} \u8fd4\u56de\u7ed3\u679c {}", (Object)this.key, (Object)this.result.complete(this.data));
        this.data.stream().map(item -> {
            DockingDeviceChannel model = new DockingDeviceChannel();
            model.setGbDeviceId(this.deviceId);
            model.setGbDeviceChannelId(item.getDeviceId());
            model.setName(item.getName());
            model.setAddress(item.getAddress());
            return model;
        }).forEach(this.addDeviceChannelFunc);
        this.subscribe.getSipRequestSubscribe().delPublisher(this.key);
    }

    public CatalogSubscriber(SipSubscribe subscribe, String key, CompletableFuture<List<CatalogItemDTO>> result, String deviceId, Consumer<? super DockingDeviceChannel> addDeviceChannelFunc) {
        this.subscribe = subscribe;
        this.key = key;
        this.result = result;
        this.deviceId = deviceId;
        this.addDeviceChannelFunc = addDeviceChannelFunc;
    }
}

