/*
 * Decompiled with CFR 0.152.
 */
package cn.skcks.docking.gb28181.service.device;

import cn.skcks.docking.gb28181.common.json.JsonException;
import cn.skcks.docking.gb28181.common.json.JsonUtils;
import cn.skcks.docking.gb28181.orm.mybatis.dynamic.mapper.DockingDeviceChannelDynamicSqlSupport;
import cn.skcks.docking.gb28181.orm.mybatis.dynamic.mapper.DockingDeviceChannelMapper;
import cn.skcks.docking.gb28181.orm.mybatis.dynamic.model.DockingDeviceChannel;
import com.github.pagehelper.ISelect;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.mybatis.dynamic.sql.AndOrCriteriaGroup;
import org.mybatis.dynamic.sql.BindableColumn;
import org.mybatis.dynamic.sql.SortSpecification;
import org.mybatis.dynamic.sql.SqlBuilder;
import org.mybatis.dynamic.sql.VisitableCondition;
import org.mybatis.dynamic.sql.select.QueryExpressionDSL;
import org.mybatis.dynamic.sql.util.Buildable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DeviceChannelService {
    private static final Logger log = LoggerFactory.getLogger(DeviceChannelService.class);
    private final DockingDeviceChannelMapper deviceChannelMapper;

    public Optional<DockingDeviceChannel> getDeviceChannelById(Long id) {
        return this.deviceChannelMapper.selectOne(s -> (Buildable)s.where((BindableColumn)DockingDeviceChannelDynamicSqlSupport.id, (VisitableCondition)SqlBuilder.isEqualTo((Object)id), new AndOrCriteriaGroup[0]));
    }

    public List<DockingDeviceChannel> getDeviceByGbDeviceId(String gbDeviceId) {
        return this.deviceChannelMapper.select(s -> (Buildable)s.where((BindableColumn)DockingDeviceChannelDynamicSqlSupport.gbDeviceId, (VisitableCondition)SqlBuilder.isEqualTo((Object)gbDeviceId), new AndOrCriteriaGroup[0]));
    }

    public Optional<DockingDeviceChannel> getDeviceChannel(String gbDeviceId, String gbDeviceChannelId) {
        return this.deviceChannelMapper.selectOne(s -> ((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)s.where().and((BindableColumn)DockingDeviceChannelDynamicSqlSupport.gbDeviceId, (VisitableCondition)SqlBuilder.isEqualTo((Object)gbDeviceId), new AndOrCriteriaGroup[0])).and((BindableColumn)DockingDeviceChannelDynamicSqlSupport.gbDeviceChannelId, (VisitableCondition)SqlBuilder.isEqualTo((Object)gbDeviceChannelId), new AndOrCriteriaGroup[0])).limit(1L));
    }

    public PageInfo<DockingDeviceChannel> getWithPage(int page, int size, ISelect select) {
        PageInfo pageInfo;
        try (Page startPage = PageHelper.startPage((int)page, (int)size);){
            pageInfo = startPage.doSelectPageInfo(select);
        }
        return pageInfo;
    }

    public PageInfo<DockingDeviceChannel> getWithPage(int page, int size) {
        ISelect select = () -> this.deviceChannelMapper.select(u -> u.orderBy(new SortSpecification[]{DockingDeviceChannelDynamicSqlSupport.id.descending()}));
        return this.getWithPage(page, size, select);
    }

    @Transactional
    public boolean add(DockingDeviceChannel model) {
        if (model == null) {
            return false;
        }
        String gbDeviceId = model.getGbDeviceId();
        String gbDeviceChannelId = model.getGbDeviceChannelId();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{gbDeviceChannelId, gbDeviceId})) {
            throw new JsonException("\u56fd\u6807id \u6216 \u901a\u9053id \u4e0d\u80fd\u4e3a\u7a7a");
        }
        Optional<DockingDeviceChannel> deviceChannel = this.getDeviceChannel(gbDeviceId, gbDeviceChannelId);
        log.info("{}", (Object)JsonUtils.toJson(deviceChannel.orElse(null)));
        return this.deviceChannelMapper.insert(model) > 0;
    }

    @Transactional
    public boolean del(DockingDeviceChannel model) {
        if (model == null) {
            return false;
        }
        Long id = model.getId();
        String gbDeviceId = model.getGbDeviceId();
        String gbDeviceChannelId = model.getGbDeviceChannelId();
        if (id != null) {
            return this.deviceChannelMapper.deleteByPrimaryKey(id) > 0;
        }
        if (StringUtils.isBlank((CharSequence)gbDeviceId)) {
            throw new JsonException("\u56fd\u6807id \u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)gbDeviceChannelId)) {
            return this.deviceChannelMapper.delete(d -> (Buildable)d.where((BindableColumn)DockingDeviceChannelDynamicSqlSupport.gbDeviceId, (VisitableCondition)SqlBuilder.isEqualTo((Object)gbDeviceId), new AndOrCriteriaGroup[0])) > 0;
        }
        return this.deviceChannelMapper.delete(d -> (Buildable)d.where((BindableColumn)DockingDeviceChannelDynamicSqlSupport.gbDeviceId, (VisitableCondition)SqlBuilder.isEqualTo((Object)gbDeviceId), new AndOrCriteriaGroup[0])) > 0;
    }

    public DeviceChannelService(DockingDeviceChannelMapper deviceChannelMapper) {
        this.deviceChannelMapper = deviceChannelMapper;
    }
}

