/*
 * Decompiled with CFR 0.152.
 */
package cn.skcks.docking.gb28181.service.docking.device;

import cn.hutool.core.date.DateUtil;
import cn.skcks.docking.gb28181.core.sip.dto.SipTransactionInfo;
import cn.skcks.docking.gb28181.core.sip.gb28181.constant.DeviceConstant;
import cn.skcks.docking.gb28181.orm.mybatis.dynamic.mapper.DockingDeviceDynamicSqlSupport;
import cn.skcks.docking.gb28181.orm.mybatis.dynamic.mapper.DockingDeviceMapper;
import cn.skcks.docking.gb28181.orm.mybatis.dynamic.model.DockingDevice;
import cn.skcks.docking.gb28181.service.docking.device.cache.DeviceOnlineCacheService;
import cn.skcks.docking.gb28181.service.docking.device.cache.DeviceOnlineTransactionCacheService;
import cn.skcks.docking.gb28181.service.docking.device.cache.DockingDeviceCacheService;
import gov.nist.javax.sip.message.SIPResponse;
import javax.sip.message.Response;
import org.mybatis.dynamic.sql.AndOrCriteriaGroup;
import org.mybatis.dynamic.sql.BindableColumn;
import org.mybatis.dynamic.sql.SqlBuilder;
import org.mybatis.dynamic.sql.VisitableCondition;
import org.mybatis.dynamic.sql.util.Buildable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DockingDeviceService {
    private static final Logger log = LoggerFactory.getLogger(DockingDeviceService.class);
    private final DockingDeviceMapper dockingDeviceMapper;
    private final DockingDeviceCacheService deviceCacheService;
    private final DeviceOnlineCacheService onlineCacheService;
    private final DeviceOnlineTransactionCacheService transactionCacheService;

    public DockingDevice getDevice(String deviceId) {
        DockingDevice device = this.deviceCacheService.getDevice(deviceId);
        if (device == null && (device = (DockingDevice)this.dockingDeviceMapper.selectOne(s -> (Buildable)s.where((BindableColumn)DockingDeviceDynamicSqlSupport.deviceId, (VisitableCondition)SqlBuilder.isEqualTo((Object)deviceId), new AndOrCriteriaGroup[0])).orElse(null)) != null) {
            this.deviceCacheService.cacheDevice(deviceId, device);
        }
        return device;
    }

    public boolean isOnline(String deviceId) {
        return this.onlineCacheService.isOnline(deviceId);
    }

    @Transactional
    public void online(DockingDevice device, Response response) {
        String deviceId = device.getDeviceId();
        log.info("[\u8bbe\u5907\u4e0a\u7ebf] deviceId => {}, {}://{}:{}", new Object[]{deviceId, device.getTransport(), device.getIp(), device.getPort()});
        device.setUpdateTime(DateUtil.now());
        if (device.getKeepaliveIntervalTime() == null || device.getKeepaliveIntervalTime() == 0) {
            device.setKeepaliveIntervalTime(Integer.valueOf(60));
        }
        this.dockingDeviceMapper.selectOne(s -> (Buildable)s.where((BindableColumn)DockingDeviceDynamicSqlSupport.deviceId, (VisitableCondition)SqlBuilder.isEqualTo((Object)deviceId), new AndOrCriteriaGroup[0])).ifPresentOrElse(ignore -> this.dockingDeviceMapper.updateByPrimaryKey(device), () -> this.dockingDeviceMapper.insert(device));
        this.deviceCacheService.removeDevice(deviceId);
        this.deviceCacheService.cacheDevice(deviceId, device);
        this.onlineCacheService.setOnline(deviceId, 180L, DeviceConstant.UNIT);
        this.setTransaction(deviceId, response);
    }

    public void offline(DockingDevice device) {
        String deviceId = device.getDeviceId();
        this.dockingDeviceMapper.updateByPrimaryKey(device);
        log.info("[\u8bbe\u5907\u79bb\u7ebf] deviceId => {}", (Object)deviceId);
        this.deviceCacheService.removeDevice(deviceId);
        this.delTransaction(deviceId);
        this.onlineCacheService.setOffline(deviceId);
    }

    public boolean hasTransaction(String deviceId) {
        return this.transactionCacheService.hasTransaction(deviceId);
    }

    public void setTransaction(String deviceId, Response response) {
        SipTransactionInfo sipTransactionInfo = new SipTransactionInfo((SIPResponse)response);
        this.transactionCacheService.setTransaction(deviceId, sipTransactionInfo, 180L, DeviceConstant.UNIT);
    }

    public SipTransactionInfo getTransaction(String deviceId) {
        return this.transactionCacheService.getTransaction(deviceId);
    }

    public void delTransaction(String deviceId) {
        this.transactionCacheService.delTransaction(deviceId);
    }

    public DockingDeviceService(DockingDeviceMapper dockingDeviceMapper, DockingDeviceCacheService deviceCacheService, DeviceOnlineCacheService onlineCacheService, DeviceOnlineTransactionCacheService transactionCacheService) {
        this.dockingDeviceMapper = dockingDeviceMapper;
        this.deviceCacheService = deviceCacheService;
        this.onlineCacheService = onlineCacheService;
        this.transactionCacheService = transactionCacheService;
    }
}

