/*
 * Decompiled with CFR 0.152.
 */
package cn.skcks.docking.gb28181.service.docking.device.cache;

import cn.hutool.core.date.DateUtil;
import cn.skcks.docking.gb28181.common.redis.RedisUtil;
import cn.skcks.docking.gb28181.core.sip.gb28181.cache.CacheUtil;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DeviceOnlineCacheService {
    private static final Logger log = LoggerFactory.getLogger(DeviceOnlineCacheService.class);

    private String getKey(String deviceId) {
        return CacheUtil.getKey("ONLINE", deviceId);
    }

    public boolean isOnline(String deviceId) {
        return RedisUtil.KeyOps.hasKey((String)this.getKey(deviceId));
    }

    public void setOnline(String deviceId, long time, TimeUnit unit) {
        String key = this.getKey(deviceId);
        RedisUtil.StringOps.set((String)key, (String)DateUtil.now());
        RedisUtil.KeyOps.expire((String)key, (long)time, (TimeUnit)unit);
    }

    public void setOffline(String deviceId) {
        String key = this.getKey(deviceId);
        RedisUtil.KeyOps.delete((String)key);
    }
}

