/*
 * Decompiled with CFR 0.152.
 */
package cn.skcks.docking.gb28181.service.docking.device.cache;

import cn.skcks.docking.gb28181.common.json.JsonUtils;
import cn.skcks.docking.gb28181.common.redis.RedisUtil;
import cn.skcks.docking.gb28181.core.sip.dto.SipTransactionInfo;
import cn.skcks.docking.gb28181.core.sip.gb28181.cache.CacheUtil;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DeviceOnlineTransactionCacheService {
    private static final Logger log = LoggerFactory.getLogger(DeviceOnlineTransactionCacheService.class);

    private String getKey(String deviceId) {
        return CacheUtil.getKey("TRANSACTION", deviceId);
    }

    public boolean hasTransaction(String deviceId) {
        return RedisUtil.KeyOps.hasKey((String)this.getKey(deviceId));
    }

    public void setTransaction(String deviceId, SipTransactionInfo transaction, long time, TimeUnit unit) {
        String key = this.getKey(deviceId);
        RedisUtil.StringOps.set((String)key, (String)JsonUtils.toCompressJson((Object)transaction));
        RedisUtil.KeyOps.expire((String)key, (long)time, (TimeUnit)unit);
    }

    public SipTransactionInfo getTransaction(String deviceId) {
        String key = this.getKey(deviceId);
        String json = RedisUtil.StringOps.get((String)key);
        if (json == null) {
            return null;
        }
        return (SipTransactionInfo)JsonUtils.parse((String)json, SipTransactionInfo.class);
    }

    public void delTransaction(String deviceId) {
        String key = this.getKey(deviceId);
        RedisUtil.KeyOps.delete((String)key);
    }
}

