/*
 * Decompiled with CFR 0.152.
 */
package cn.skcks.docking.gb28181.service.docking.device.cache;

import cn.skcks.docking.gb28181.common.json.JsonUtils;
import cn.skcks.docking.gb28181.common.redis.RedisUtil;
import cn.skcks.docking.gb28181.core.sip.gb28181.cache.CacheUtil;
import cn.skcks.docking.gb28181.orm.mybatis.dynamic.model.DockingDevice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DockingDeviceCacheService {
    private static final Logger log = LoggerFactory.getLogger(DockingDeviceCacheService.class);

    private String getKey(String deviceId) {
        return CacheUtil.getKey("DEVICE", deviceId);
    }

    public DockingDevice getDevice(String deviceId) {
        String key = this.getKey(deviceId);
        String json = RedisUtil.StringOps.get((String)key);
        if (json == null) {
            return null;
        }
        return (DockingDevice)JsonUtils.parse((String)json, DockingDevice.class);
    }

    public void removeDevice(String deviceId) {
        String key = this.getKey(deviceId);
        RedisUtil.KeyOps.delete((String)key);
    }

    public void cacheDevice(String deviceId, DockingDevice device) {
        String key = this.getKey(deviceId);
        RedisUtil.StringOps.set((String)key, (String)JsonUtils.toCompressJson((Object)device));
    }
}

