/*
 * Decompiled with CFR 0.152.
 */
package cn.skcks.docking.gb28181.service.notify;

import cn.hutool.core.collection.CollectionUtil;
import cn.skcks.docking.gb28181.common.json.JsonUtils;
import cn.skcks.docking.gb28181.common.redis.RedisUtil;
import cn.skcks.docking.gb28181.config.sip.SipConfig;
import cn.skcks.docking.gb28181.core.sip.dto.SipTransactionInfo;
import cn.skcks.docking.gb28181.core.sip.gb28181.cache.CacheUtil;
import cn.skcks.docking.gb28181.core.sip.message.sender.SipMessageSender;
import cn.skcks.docking.gb28181.core.sip.message.subscribe.GenericSubscribe;
import cn.skcks.docking.gb28181.core.sip.message.subscribe.SipSubscribe;
import cn.skcks.docking.gb28181.sdp.GB28181SDPBuilder;
import cn.skcks.docking.gb28181.sip.manscdp.mediastatus.notify.MediaStatusRequestDTO;
import cn.skcks.docking.gb28181.sip.method.invite.request.InviteRequestBuilder;
import gov.nist.javax.sip.message.SIPRequest;
import java.util.Collection;
import java.util.Set;
import javax.sip.address.SipURI;
import javax.sip.message.Message;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MediaStatusService {
    private static final Logger log = LoggerFactory.getLogger(MediaStatusService.class);
    private final SipConfig sipConfig;
    private final SipMessageSender sender;
    private final SipSubscribe subscribe;

    public void process(SIPRequest request, MediaStatusRequestDTO dto) {
        String senderIp = request.getLocalAddress().getHostAddress();
        String deviceId = ((SipURI)request.getFromHeader().getAddress().getURI()).getUser();
        if (StringUtils.equalsIgnoreCase((CharSequence)dto.getNotifyType(), (CharSequence)"121")) {
            InviteRequestBuilder inviteRequestBuilder = ((InviteRequestBuilder.InviteRequestBuilderBuilder)((InviteRequestBuilder.InviteRequestBuilderBuilder)((InviteRequestBuilder.InviteRequestBuilderBuilder)((InviteRequestBuilder.InviteRequestBuilderBuilder)((InviteRequestBuilder.InviteRequestBuilderBuilder)((InviteRequestBuilder.InviteRequestBuilderBuilder)((InviteRequestBuilder.InviteRequestBuilderBuilder)InviteRequestBuilder.builder().localIp(request.getLocalAddress().getHostAddress())).localPort(this.sipConfig.getPort().intValue())).localId(((SipURI)request.getToHeader().getAddress().getURI()).getUser())).targetIp(request.getRemoteAddress().getHostAddress())).targetPort(request.getRemotePort())).targetId(((SipURI)request.getFromHeader().getAddress().getURI()).getUser())).transport(request.getTopmostViaHeader().getTransport())).build();
            String keyPattern = CacheUtil.getKey(GB28181SDPBuilder.Action.PLAY_BACK.getAction(), deviceId, "*");
            Set keys = RedisUtil.KeyOps.keys((String)keyPattern);
            if (CollectionUtil.isEmpty((Collection)keys)) {
                this.sender.send(senderIp, (Message)inviteRequestBuilder.createByeRequest(request.getCallId().getCallId(), request.getCSeq().getSeqNumber() + 1L));
            } else {
                keys.forEach(key -> {
                    String json = RedisUtil.StringOps.get((String)key);
                    if (StringUtils.isNotBlank((CharSequence)json)) {
                        log.debug("{} {}", key, (Object)json);
                        SipTransactionInfo transactionInfo = (SipTransactionInfo)JsonUtils.parse((String)json, SipTransactionInfo.class);
                        String callId = transactionInfo.getCallId();
                        String subscribeKey = GenericSubscribe.Helper.getKey("BYE", callId);
                        log.debug("{} {}", (Object)callId, (Object)subscribeKey);
                        this.subscribe.getSipRequestSubscribe().getPublisher(subscribeKey).submit(request);
                    }
                });
            }
        }
    }

    public MediaStatusService(SipConfig sipConfig, SipMessageSender sender, SipSubscribe subscribe) {
        this.sipConfig = sipConfig;
        this.sender = sender;
        this.subscribe = subscribe;
    }
}

