/*
 * Decompiled with CFR 0.152.
 */
package cn.skcks.docking.gb28181.service.play;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.skcks.docking.gb28181.common.json.JsonResponse;
import cn.skcks.docking.gb28181.common.json.JsonUtils;
import cn.skcks.docking.gb28181.common.redis.RedisUtil;
import cn.skcks.docking.gb28181.config.sip.SipConfig;
import cn.skcks.docking.gb28181.core.sip.dto.SipTransactionInfo;
import cn.skcks.docking.gb28181.core.sip.gb28181.cache.CacheUtil;
import cn.skcks.docking.gb28181.core.sip.message.request.SipRequestBuilder;
import cn.skcks.docking.gb28181.core.sip.message.sender.SipMessageSender;
import cn.skcks.docking.gb28181.core.sip.message.subscribe.GenericSubscribe;
import cn.skcks.docking.gb28181.core.sip.message.subscribe.GenericTimeoutSubscribe;
import cn.skcks.docking.gb28181.core.sip.message.subscribe.SipSubscribe;
import cn.skcks.docking.gb28181.core.sip.service.SipService;
import cn.skcks.docking.gb28181.media.config.ZlmMediaConfig;
import cn.skcks.docking.gb28181.media.dto.rtp.CloseRtpServer;
import cn.skcks.docking.gb28181.media.dto.rtp.GetRtpInfoResp;
import cn.skcks.docking.gb28181.media.dto.rtp.OpenRtpServer;
import cn.skcks.docking.gb28181.media.dto.rtp.OpenRtpServerResp;
import cn.skcks.docking.gb28181.media.dto.status.ResponseStatus;
import cn.skcks.docking.gb28181.media.proxy.ZlmMediaService;
import cn.skcks.docking.gb28181.orm.mybatis.dynamic.model.DockingDevice;
import cn.skcks.docking.gb28181.sdp.GB28181SDPBuilder;
import cn.skcks.docking.gb28181.sdp.media.MediaStreamMode;
import cn.skcks.docking.gb28181.service.docking.device.DockingDeviceService;
import cn.skcks.docking.gb28181.service.ssrc.SsrcService;
import cn.skcks.docking.gb28181.sip.method.invite.request.InviteRequestBuilder;
import cn.skcks.docking.gb28181.sip.method.invite.response.InviteResponseBuilder;
import cn.skcks.docking.gb28181.sip.utils.SipUtil;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.concurrent.TimeUnit;
import javax.sip.SipProvider;
import javax.sip.header.CallIdHeader;
import javax.sip.message.Message;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.async.DeferredResult;

@Service
public class PlayService {
    private static final Logger log = LoggerFactory.getLogger(PlayService.class);
    private final ZlmMediaConfig zlmMediaConfig;
    private final DockingDeviceService deviceService;
    private final ZlmMediaService zlmMediaService;
    private final SsrcService ssrcService;
    private final SipService sipService;
    private final SipMessageSender sender;
    private final SipSubscribe subscribe;
    private final SipConfig sipConfig;

    private String videoUrl(String streamId) {
        return StringUtils.joinWith((String)"/", (Object[])new Object[]{this.zlmMediaConfig.getUrl(), "rtp", streamId + ".live.flv"});
    }

    private DeferredResult<JsonResponse<String>> makeResult(String deviceId, String channelId, long timeout, DockingDevice device) {
        DeferredResult result = new DeferredResult(Long.valueOf(TimeUnit.SECONDS.toMillis(timeout)));
        if (device == null) {
            log.info("\u672a\u80fd\u627e\u5230 \u7f16\u7801\u4e3a => {} \u7684\u8bbe\u5907", (Object)deviceId);
            result.setResult((Object)JsonResponse.error(null, (String)"\u672a\u627e\u5230\u8bbe\u5907"));
            return result;
        }
        return result;
    }

    private int openRtpServer(DeferredResult<JsonResponse<String>> result, String streamId, int streamMode) {
        GetRtpInfoResp rtpInfo = this.zlmMediaService.getRtpInfo(streamId);
        if (rtpInfo.getExist().booleanValue()) {
            result.setResult((Object)JsonResponse.error((String)MessageFormat.format("\u6d41 {0} \u5df2\u5b58\u5728", streamId)));
            return -1;
        }
        OpenRtpServer openRtpServer = new OpenRtpServer();
        openRtpServer.setPort(0);
        openRtpServer.setStreamId(streamId);
        openRtpServer.setTcpMode(streamMode);
        OpenRtpServerResp openRtpServerResp = this.zlmMediaService.openRtpServer(openRtpServer);
        log.info("openRtpServerResp => {}", (Object)openRtpServerResp);
        if (!openRtpServerResp.getCode().equals((Object)ResponseStatus.Success)) {
            result.setResult((Object)JsonResponse.error((String)openRtpServerResp.getCode().getMsg()));
            return -1;
        }
        return openRtpServerResp.getPort();
    }

    private JsonResponse<Void> closeStream(String streamId, GB28181SDPBuilder.Action action, DockingDevice device, String channelId) {
        this.zlmMediaService.closeRtpServer(new CloseRtpServer(streamId));
        String key = CacheUtil.getKey(action.getAction(), device.getDeviceId(), channelId);
        SipTransactionInfo transactionInfo = (SipTransactionInfo)JsonUtils.parse((String)RedisUtil.StringOps.get((String)key), SipTransactionInfo.class);
        if (transactionInfo == null) {
            return JsonResponse.error((String)"\u672a\u627e\u5230\u8fde\u63a5\u4fe1\u606f");
        }
        Request request = SipRequestBuilder.createByeRequest(device, channelId, transactionInfo);
        String senderIp = device.getLocalIp();
        this.sender.send(senderIp, (Message)request);
        String ssrc = transactionInfo.getSsrc();
        this.ssrcService.releaseSsrc(this.zlmMediaConfig.getId(), ssrc);
        RedisUtil.KeyOps.delete((String)key);
        return JsonResponse.success(null);
    }

    public DeferredResult<JsonResponse<String>> realTimePlay(String deviceId, String channelId, long timeout) {
        DockingDevice device = this.deviceService.getDevice(deviceId);
        final DeferredResult<JsonResponse<String>> result = this.makeResult(deviceId, channelId, timeout, device);
        if (result.hasResult()) {
            return result;
        }
        final String streamId = GB28181SDPBuilder.getStreamId((String)deviceId, (String[])new String[]{channelId});
        final String key = CacheUtil.getKey(GB28181SDPBuilder.Action.PLAY.getAction(), deviceId, channelId);
        if (RedisUtil.KeyOps.hasKey((String)key)) {
            result.setResult((Object)JsonResponse.success((Object)this.videoUrl(streamId)));
            return result;
        }
        int streamMode = device.getStreamMode() == null || device.getStreamMode().equalsIgnoreCase("UDP") ? 0 : 1;
        String ip = this.zlmMediaConfig.getIp();
        int port = this.openRtpServer(result, streamId, streamMode);
        if (result.hasResult()) {
            return result;
        }
        final String ssrc = this.ssrcService.getPlaySsrc();
        String transport = device.getTransport();
        String senderIp = device.getLocalIp();
        SipProvider provider = this.sipService.getProvider(transport, senderIp);
        CallIdHeader callIdHeader = provider.getNewCallId();
        String callId = callIdHeader.getCallId();
        InviteRequestBuilder inviteRequestBuilder = ((InviteRequestBuilder.InviteRequestBuilderBuilder)((InviteRequestBuilder.InviteRequestBuilderBuilder)((InviteRequestBuilder.InviteRequestBuilderBuilder)((InviteRequestBuilder.InviteRequestBuilderBuilder)((InviteRequestBuilder.InviteRequestBuilderBuilder)((InviteRequestBuilder.InviteRequestBuilderBuilder)((InviteRequestBuilder.InviteRequestBuilderBuilder)InviteRequestBuilder.builder().localId(this.sipConfig.getId())).localPort(this.sipConfig.getPort().intValue())).localIp(device.getLocalIp())).targetId(deviceId)).targetIp(device.getIp())).targetPort(device.getPort().intValue())).transport(device.getTransport())).build();
        Request request = inviteRequestBuilder.createPlayInviteRequest(callId, SipRequestBuilder.getCSeq(), channelId, ip, port, ssrc, MediaStreamMode.of((String)device.getStreamMode()));
        final String subscribeKey = GenericSubscribe.Helper.getKey("INVITE", callIdHeader.getCallId());
        this.subscribe.getSipResponseSubscribe().addPublisher(subscribeKey);
        Flow.Subscriber<SIPResponse> subscriber = new Flow.Subscriber<SIPResponse>(){
            private Flow.Subscription subscription;

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                this.subscription = subscription;
                log.info("\u8ba2\u9605 {} {}", (Object)"INVITE", (Object)subscribeKey);
                subscription.request(1L);
            }

            @Override
            public void onNext(SIPResponse item) {
                int statusCode = item.getStatusCode();
                log.debug("{} \u6536\u5230\u8ba2\u9605\u6d88\u606f {}", (Object)subscribeKey, (Object)item);
                if (statusCode == 100) {
                    log.info("\u8ba2\u9605 {} {} \u5c1d\u8bd5\u8fde\u63a5\u6d41\u5a92\u4f53\u670d\u52a1", (Object)"INVITE", (Object)subscribeKey);
                    this.subscription.request(1L);
                } else if (statusCode >= 200 && statusCode < 300) {
                    log.info("\u8ba2\u9605 {} {} \u6d41\u5a92\u4f53\u670d\u52a1\u8fde\u63a5\u6210\u529f, \u5f00\u59cb\u63a8\u9001\u89c6\u9891\u6d41", (Object)"INVITE", (Object)subscribeKey);
                    RedisUtil.StringOps.set((String)key, (String)JsonUtils.toCompressJson((Object)new SipTransactionInfo(item, ssrc)));
                    result.setResult((Object)JsonResponse.success((Object)PlayService.this.videoUrl(streamId)));
                    this.onComplete();
                } else {
                    log.info("\u8ba2\u9605 {} {} \u8fde\u63a5\u6d41\u5a92\u4f53\u670d\u52a1\u65f6\u51fa\u73b0\u5f02\u5e38, \u7ec8\u6b62\u8ba2\u9605", (Object)"INVITE", (Object)subscribeKey);
                    RedisUtil.KeyOps.delete((String)key);
                    result.setResult((Object)JsonResponse.error((String)"\u8fde\u63a5\u6d41\u5a92\u4f53\u670d\u52a1\u5931\u8d25"));
                    PlayService.this.ssrcService.releaseSsrc(PlayService.this.zlmMediaConfig.getId(), ssrc);
                    this.onComplete();
                }
            }

            @Override
            public void onError(Throwable throwable) {
            }

            @Override
            public void onComplete() {
                PlayService.this.subscribe.getSipResponseSubscribe().delPublisher(subscribeKey);
            }
        };
        this.byeSubscribe(inviteRequestBuilder, provider, callId, 3600L, () -> RedisUtil.KeyOps.delete((String)key));
        this.subscribe.getSipResponseSubscribe().addSubscribe(subscribeKey, subscriber);
        this.sender.send(senderIp, (Message)request);
        result.onTimeout(() -> {
            this.subscribe.getSipResponseSubscribe().delPublisher(subscribeKey);
            result.setResult((Object)JsonResponse.error((String)"\u70b9\u64ad\u8d85\u65f6"));
        });
        return result;
    }

    public JsonResponse<Void> realTimeStop(String deviceId, String channelId) {
        DockingDevice device = this.deviceService.getDevice(deviceId);
        if (device == null) {
            log.info("\u672a\u80fd\u627e\u5230 \u7f16\u7801\u4e3a => {} \u7684\u8bbe\u5907", (Object)deviceId);
            return JsonResponse.error(null, (String)"\u672a\u627e\u5230\u8bbe\u5907");
        }
        String streamId = GB28181SDPBuilder.getStreamId((String)deviceId, (String[])new String[]{channelId});
        return this.closeStream(streamId, GB28181SDPBuilder.Action.PLAY, device, channelId);
    }

    public DeferredResult<JsonResponse<String>> recordPlay(String deviceId, String channelId, final Date startTime, final Date endTime, long timeout) {
        DockingDevice device = this.deviceService.getDevice(deviceId);
        long start = startTime.toInstant().getEpochSecond();
        long end = endTime.toInstant().getEpochSecond();
        final String streamId = GB28181SDPBuilder.getStreamId((String)deviceId, (String[])new String[]{channelId, String.valueOf(start), String.valueOf(end)});
        final DeferredResult<JsonResponse<String>> result = this.makeResult(deviceId, channelId, timeout, device);
        if (result.hasResult()) {
            return result;
        }
        final String key = CacheUtil.getKey(GB28181SDPBuilder.Action.PLAY_BACK.getAction(), deviceId, channelId);
        if (RedisUtil.KeyOps.hasKey((String)key)) {
            result.setResult((Object)JsonResponse.success((Object)this.videoUrl(streamId)));
            return result;
        }
        int streamMode = device.getStreamMode() == null || device.getStreamMode().equalsIgnoreCase("UDP") ? 0 : 1;
        String ip = this.zlmMediaConfig.getIp();
        int port = this.openRtpServer(result, streamId, streamMode);
        if (result.hasResult()) {
            return result;
        }
        final String ssrc = this.ssrcService.getPlayBackSsrc();
        String transport = device.getTransport();
        String senderIp = device.getLocalIp();
        SipProvider provider = this.sipService.getProvider(transport, senderIp);
        CallIdHeader callIdHeader = provider.getNewCallId();
        String callId = callIdHeader.getCallId();
        InviteRequestBuilder inviteRequestBuilder = ((InviteRequestBuilder.InviteRequestBuilderBuilder)((InviteRequestBuilder.InviteRequestBuilderBuilder)((InviteRequestBuilder.InviteRequestBuilderBuilder)((InviteRequestBuilder.InviteRequestBuilderBuilder)((InviteRequestBuilder.InviteRequestBuilderBuilder)((InviteRequestBuilder.InviteRequestBuilderBuilder)((InviteRequestBuilder.InviteRequestBuilderBuilder)InviteRequestBuilder.builder().localId(this.sipConfig.getId())).localPort(this.sipConfig.getPort().intValue())).localIp(device.getLocalIp())).targetId(deviceId)).targetIp(device.getIp())).targetPort(device.getPort().intValue())).transport(device.getTransport())).build();
        Request request = inviteRequestBuilder.createPlaybackInviteRequest(callId, SipRequestBuilder.getCSeq(), channelId, ip, port, ssrc, MediaStreamMode.of((String)device.getStreamMode()), startTime, endTime);
        final String subscribeKey = GenericSubscribe.Helper.getKey("INVITE", callIdHeader.getCallId());
        this.subscribe.getSipResponseSubscribe().addPublisher(subscribeKey);
        Flow.Subscriber<SIPResponse> subscriber = new Flow.Subscriber<SIPResponse>(){
            private Flow.Subscription subscription;

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                this.subscription = subscription;
                log.info("\u8ba2\u9605 {} {}", (Object)"INVITE", (Object)subscribeKey);
                subscription.request(1L);
            }

            @Override
            public void onNext(SIPResponse item) {
                int statusCode = item.getStatusCode();
                log.debug("{} \u6536\u5230\u8ba2\u9605\u6d88\u606f {}", (Object)subscribeKey, (Object)item);
                if (statusCode == 100) {
                    log.info("\u8ba2\u9605 {} {} \u5c1d\u8bd5\u8fde\u63a5\u6d41\u5a92\u4f53\u670d\u52a1", (Object)"INVITE", (Object)subscribeKey);
                    this.subscription.request(1L);
                } else if (statusCode >= 200 && statusCode < 300) {
                    log.info("\u8ba2\u9605 {} {} \u6d41\u5a92\u4f53\u670d\u52a1\u8fde\u63a5\u6210\u529f, \u5f00\u59cb\u63a8\u9001\u89c6\u9891\u6d41", (Object)"INVITE", (Object)subscribeKey);
                    RedisUtil.StringOps.set((String)key, (String)JsonUtils.toCompressJson((Object)new SipTransactionInfo(item, ssrc)));
                    RedisUtil.KeyOps.expire((String)key, (long)(DateUtil.between((Date)startTime, (Date)endTime, (DateUnit)DateUnit.SECOND) + 30L), (TimeUnit)TimeUnit.SECONDS);
                    result.setResult((Object)JsonResponse.success((Object)PlayService.this.videoUrl(streamId)));
                    this.onComplete();
                } else {
                    log.info("\u8ba2\u9605 {} {} \u8fde\u63a5\u6d41\u5a92\u4f53\u670d\u52a1\u65f6\u51fa\u73b0\u5f02\u5e38, \u7ec8\u6b62\u8ba2\u9605", (Object)"INVITE", (Object)subscribeKey);
                    RedisUtil.KeyOps.delete((String)key);
                    result.setResult((Object)JsonResponse.error((String)"\u8fde\u63a5\u6d41\u5a92\u4f53\u670d\u52a1\u5931\u8d25"));
                    PlayService.this.ssrcService.releaseSsrc(PlayService.this.zlmMediaConfig.getId(), ssrc);
                    this.onComplete();
                }
            }

            @Override
            public void onError(Throwable throwable) {
            }

            @Override
            public void onComplete() {
                PlayService.this.subscribe.getSipResponseSubscribe().delPublisher(subscribeKey);
            }
        };
        this.byeSubscribe(inviteRequestBuilder, provider, callId, DateUtil.between((Date)startTime, (Date)endTime, (DateUnit)DateUnit.SECOND), () -> RedisUtil.KeyOps.delete((String)key));
        this.subscribe.getSipResponseSubscribe().addSubscribe(subscribeKey, subscriber);
        this.sender.send(senderIp, (Message)request);
        result.onTimeout(() -> {
            this.subscribe.getSipResponseSubscribe().delPublisher(subscribeKey);
            result.setResult((Object)JsonResponse.error((String)"\u70b9\u64ad\u8d85\u65f6"));
        });
        return result;
    }

    public void byeSubscribe(final InviteRequestBuilder inviteRequestBuilder, final SipProvider provider, final String callId, long seconds, final Runnable cb) {
        final GenericTimeoutSubscribe<SIPRequest> sipRequestSubscribe = this.subscribe.getSipRequestSubscribe();
        final String subscribeKey = GenericSubscribe.Helper.getKey("BYE", callId);
        sipRequestSubscribe.addPublisher(subscribeKey, seconds + 30L, TimeUnit.SECONDS);
        Flow.Subscriber<SIPRequest> subscriber = new Flow.Subscriber<SIPRequest>(){
            SIPRequest request;

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                subscription.request(1L);
            }

            @Override
            public void onNext(SIPRequest item) {
                sipRequestSubscribe.delPublisher(GenericSubscribe.Helper.getKey("INVITE", callId));
                this.request = item;
                sipRequestSubscribe.complete(subscribeKey);
            }

            @Override
            public void onError(Throwable throwable) {
            }

            @Override
            public void onComplete() {
                if (this.request != null && Objects.equals(this.request.getMethod(), "BYE")) {
                    Response byeResponse = InviteResponseBuilder.builder().build().createByeResponse((Request)this.request, SipUtil.nanoId());
                    provider.sendResponse(byeResponse);
                } else {
                    Request byeRequest = inviteRequestBuilder.createByeRequest(callId, SipRequestBuilder.getCSeq());
                    provider.sendRequest(byeRequest);
                }
                cb.run();
                sipRequestSubscribe.delPublisher(subscribeKey);
            }
        };
        sipRequestSubscribe.addSubscribe(subscribeKey, subscriber);
    }

    public JsonResponse<Void> recordStop(String deviceId, String channelId, Date startTime, Date endTime) {
        DockingDevice device = this.deviceService.getDevice(deviceId);
        if (device == null) {
            log.info("\u672a\u80fd\u627e\u5230 \u7f16\u7801\u4e3a => {} \u7684\u8bbe\u5907", (Object)deviceId);
            return JsonResponse.error(null, (String)"\u672a\u627e\u5230\u8bbe\u5907");
        }
        long start = startTime.toInstant().getEpochSecond();
        long end = endTime.toInstant().getEpochSecond();
        String streamId = GB28181SDPBuilder.getStreamId((String)deviceId, (String[])new String[]{channelId, String.valueOf(start), String.valueOf(end)});
        return this.closeStream(streamId, GB28181SDPBuilder.Action.PLAY_BACK, device, channelId);
    }

    public PlayService(ZlmMediaConfig zlmMediaConfig, DockingDeviceService deviceService, ZlmMediaService zlmMediaService, SsrcService ssrcService, SipService sipService, SipMessageSender sender, SipSubscribe subscribe, SipConfig sipConfig) {
        this.zlmMediaConfig = zlmMediaConfig;
        this.deviceService = deviceService;
        this.zlmMediaService = zlmMediaService;
        this.ssrcService = ssrcService;
        this.sipService = sipService;
        this.sender = sender;
        this.subscribe = subscribe;
        this.sipConfig = sipConfig;
    }
}

