/*
 * Decompiled with CFR 0.152.
 */
package cn.skcks.docking.gb28181.service.record;

import cn.hutool.core.date.DateUtil;
import cn.skcks.docking.gb28181.common.json.JsonResponse;
import cn.skcks.docking.gb28181.common.json.ResponseStatus;
import cn.skcks.docking.gb28181.config.sip.SipConfig;
import cn.skcks.docking.gb28181.core.sip.message.request.SipRequestBuilder;
import cn.skcks.docking.gb28181.core.sip.message.subscribe.GenericSubscribe;
import cn.skcks.docking.gb28181.core.sip.message.subscribe.SipSubscribe;
import cn.skcks.docking.gb28181.core.sip.service.SipService;
import cn.skcks.docking.gb28181.orm.mybatis.dynamic.model.DockingDevice;
import cn.skcks.docking.gb28181.orm.mybatis.dynamic.model.DockingDeviceChannel;
import cn.skcks.docking.gb28181.service.device.DeviceChannelService;
import cn.skcks.docking.gb28181.service.docking.device.DockingDeviceService;
import cn.skcks.docking.gb28181.service.record.RecordSubscriber;
import cn.skcks.docking.gb28181.service.record.convertor.RecordConvertor;
import cn.skcks.docking.gb28181.service.record.vo.RecordInfoItemVO;
import cn.skcks.docking.gb28181.sip.manscdp.recordinfo.request.RecordInfoRequestDTO;
import cn.skcks.docking.gb28181.sip.manscdp.recordinfo.response.RecordInfoItemDTO;
import cn.skcks.docking.gb28181.sip.method.message.request.MessageRequestBuilder;
import cn.skcks.docking.gb28181.sip.utils.MANSCDPUtils;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.sip.SipProvider;
import javax.sip.message.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.async.DeferredResult;

@Service
public class RecordService {
    private static final Logger log = LoggerFactory.getLogger(RecordService.class);
    private final SipConfig sipConfig;
    private final DockingDeviceService deviceService;
    private final DeviceChannelService deviceChannelService;
    private final SipService sipService;
    private final SipSubscribe subscribe;

    public DeferredResult<JsonResponse<List<RecordInfoItemVO>>> requestRecordInfo(String deviceId, String channelId, long timeout, Date date) {
        log.info("\u67e5\u8be2 \u8bbe\u5907 => {} {} \u7684\u5386\u53f2\u5a92\u4f53\u8bb0\u5f55, \u8d85\u65f6\u65f6\u95f4 {} \u79d2", new Object[]{deviceId, DateUtil.formatDate((Date)date), timeout});
        DeferredResult result = new DeferredResult(Long.valueOf(TimeUnit.SECONDS.toMillis(timeout)));
        DockingDevice device = this.deviceService.getDevice(deviceId);
        if (device == null) {
            log.info("\u672a\u80fd\u627e\u5230 \u7f16\u7801\u4e3a => {} \u7684\u8bbe\u5907", (Object)deviceId);
            result.setResult((Object)JsonResponse.error((String)"\u672a\u627e\u5230\u8bbe\u5907"));
            return result;
        }
        Optional<DockingDeviceChannel> deviceChannel = this.deviceChannelService.getDeviceChannel(deviceId, channelId);
        if (deviceChannel.isEmpty()) {
            log.info("\u672a\u80fd\u627e\u5230 \u8bbe\u5907\u7f16\u7801\u4e3a => {}, \u901a\u9053 => {} \u7684\u4fe1\u606f", (Object)deviceId, (Object)channelId);
            result.setResult((Object)JsonResponse.error((String)"\u672a\u627e\u5230\u901a\u9053\u4fe1\u606f"));
            return result;
        }
        String transport = device.getTransport();
        String localIp = device.getLocalIp();
        SipProvider provider = this.sipService.getProvider(transport, localIp);
        String callId = provider.getNewCallId().getCallId();
        String sn = String.valueOf((int)(Math.random() * 9.0 + 1.0) * 100000);
        MessageRequestBuilder requestBuilder = ((MessageRequestBuilder.MessageRequestBuilderBuilder)((MessageRequestBuilder.MessageRequestBuilderBuilder)((MessageRequestBuilder.MessageRequestBuilderBuilder)((MessageRequestBuilder.MessageRequestBuilderBuilder)((MessageRequestBuilder.MessageRequestBuilderBuilder)((MessageRequestBuilder.MessageRequestBuilderBuilder)((MessageRequestBuilder.MessageRequestBuilderBuilder)MessageRequestBuilder.builder().targetIp(device.getIp())).targetPort(device.getPort().intValue())).targetId(deviceId)).localId(this.sipConfig.getId())).localIp(localIp)).localPort(this.sipConfig.getPort().intValue())).transport(transport)).build();
        RecordInfoRequestDTO dto = RecordInfoRequestDTO.builder().deviceId(channelId).startTime((Date)DateUtil.beginOfDay((Date)date)).endTime((Date)DateUtil.endOfDay((Date)date)).sn(sn).build();
        Request request = requestBuilder.createMessageRequest(callId, SipRequestBuilder.getCSeq(), MANSCDPUtils.toByteXml((Object)dto, (String)device.getCharset()));
        String key = GenericSubscribe.Helper.getKey("RecordInfo", channelId, sn);
        this.subscribe.getSipRequestSubscribe().addPublisher(key);
        this.subscribe.getSipRequestSubscribe().addSubscribe(key, new RecordSubscriber(this.subscribe, key, (DeferredResult<JsonResponse<List<RecordInfoItemVO>>>)result, deviceId));
        result.onTimeout(() -> {
            result.setResult((Object)JsonResponse.build((ResponseStatus)ResponseStatus.PARTIAL_CONTENT, RecordConvertor.INSTANCE.dto2Vo(Collections.emptyList()), (String)"\u67e5\u8be2\u8d85\u65f6, \u7ed3\u679c\u53ef\u80fd\u4e0d\u5b8c\u6574"));
            this.subscribe.getSipRequestSubscribe().delPublisher(key);
        });
        provider.sendRequest(request);
        return result;
    }

    private List<RecordInfoItemDTO> sortedRecordList(List<RecordInfoItemDTO> list) {
        return list.stream().sorted((a, b) -> DateUtil.compare((Date)a.getStartTime(), (Date)b.getStartTime())).collect(Collectors.toList());
    }

    public RecordService(SipConfig sipConfig, DockingDeviceService deviceService, DeviceChannelService deviceChannelService, SipService sipService, SipSubscribe subscribe) {
        this.sipConfig = sipConfig;
        this.deviceService = deviceService;
        this.deviceChannelService = deviceChannelService;
        this.sipService = sipService;
        this.subscribe = subscribe;
    }
}

