/*
 * Decompiled with CFR 0.152.
 */
package cn.skcks.docking.gb28181.service.record;

import cn.hutool.core.date.DateUtil;
import cn.skcks.docking.gb28181.common.json.JsonResponse;
import cn.skcks.docking.gb28181.core.sip.message.subscribe.SipSubscribe;
import cn.skcks.docking.gb28181.service.record.convertor.RecordConvertor;
import cn.skcks.docking.gb28181.service.record.vo.RecordInfoItemVO;
import cn.skcks.docking.gb28181.sip.manscdp.recordinfo.response.RecordInfoItemDTO;
import cn.skcks.docking.gb28181.sip.manscdp.recordinfo.response.RecordInfoResponseDTO;
import cn.skcks.docking.gb28181.sip.utils.MANSCDPUtils;
import gov.nist.javax.sip.message.SIPRequest;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Flow;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.async.DeferredResult;

public class RecordSubscriber
implements Flow.Subscriber<SIPRequest> {
    private static final Logger log = LoggerFactory.getLogger(RecordSubscriber.class);
    private final SipSubscribe subscribe;
    private final String key;
    private final DeferredResult<JsonResponse<List<RecordInfoItemVO>>> result;
    private final String deviceId;
    private final List<RecordInfoItemDTO> list = new ArrayList<RecordInfoItemDTO>();
    private final AtomicLong atomicSum = new AtomicLong(0L);
    private final AtomicLong atomicNum = new AtomicLong(0L);
    private Flow.Subscription subscription;

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        this.subscription = subscription;
        log.debug("\u5efa\u7acb\u8ba2\u9605 => {}", (Object)this.key);
        subscription.request(1L);
    }

    @Override
    public void onNext(SIPRequest item) {
        RecordInfoResponseDTO data = (RecordInfoResponseDTO)MANSCDPUtils.parse((byte[])item.getRawContent(), RecordInfoResponseDTO.class);
        this.atomicSum.set(Math.max(data.getSumNum(), this.atomicNum.get()));
        this.atomicNum.addAndGet(data.getRecordList().getNum().intValue());
        this.list.addAll(data.getRecordList().getRecordList());
        long num = this.atomicNum.get();
        long sum = this.atomicSum.get();
        if (num > sum) {
            log.warn("\u68c0\u6d4b\u5230 \u8bbe\u5907 => {}, \u672a\u6309\u89c4\u8303\u5b9e\u73b0, \u8ba2\u9605 => {}, \u671f\u671b\u603b\u6570\u4e3a => {}, \u5df2\u63a5\u6536\u6570\u91cf => {}", new Object[]{this.deviceId, this.key, this.atomicSum.get(), this.atomicNum.get()});
        } else {
            log.info("\u83b7\u53d6\u8ba2\u9605 => {}, {}/{}", new Object[]{this.key, this.atomicNum.get(), this.atomicSum.get()});
        }
        if (num >= sum) {
            this.subscribe.getSipRequestSubscribe().refreshPublisher(this.key, 500L, TimeUnit.MILLISECONDS);
        }
        this.subscription.request(1L);
    }

    @Override
    public void onError(Throwable throwable) {
    }

    @Override
    public void onComplete() {
        this.result.setResult((Object)JsonResponse.success(RecordConvertor.INSTANCE.dto2Vo(this.sortedRecordList(this.list))));
        log.debug("\u8ba2\u9605\u7ed3\u675f => {}", (Object)this.key);
        this.subscribe.getSipRequestSubscribe().delPublisher(this.key);
    }

    private List<RecordInfoItemDTO> sortedRecordList(List<RecordInfoItemDTO> list) {
        return list.stream().sorted((a, b) -> DateUtil.compare((Date)a.getStartTime(), (Date)b.getStartTime())).collect(Collectors.toList());
    }

    public RecordSubscriber(SipSubscribe subscribe, String key, DeferredResult<JsonResponse<List<RecordInfoItemVO>>> result, String deviceId) {
        this.subscribe = subscribe;
        this.key = key;
        this.result = result;
        this.deviceId = deviceId;
    }
}

