/*
 * Decompiled with CFR 0.152.
 */
package cn.skcks.docking.gb28181.service.ssrc;

import cn.skcks.docking.gb28181.common.redis.RedisUtil;
import cn.skcks.docking.gb28181.config.sip.SipConfig;
import cn.skcks.docking.gb28181.core.sip.gb28181.cache.CacheUtil;
import cn.skcks.docking.gb28181.media.config.ZlmMediaConfig;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;

@DependsOn(value={"redisUtil"})
@Service
public class SsrcService {
    private static final Logger log = LoggerFactory.getLogger(SsrcService.class);
    private static final String PREFIX = "SSRC";
    private static final int MAX_STREAM_COUNT = 10000;
    private final SipConfig sipConfig;
    private final ZlmMediaConfig mediaConfig;
    private String ssrcKey;

    @PostConstruct
    private void init() {
        String ssrcPrefix = this.sipConfig.getDomain().substring(3, 8);
        this.ssrcKey = CacheUtil.getKey(PREFIX, this.sipConfig.getId(), this.mediaConfig.getId());
        ArrayList<String> ssrcList = new ArrayList<String>(10000);
        for (int i = 1; i < 10000; ++i) {
            String ssrc = String.format("%s%04d", ssrcPrefix, i);
            ssrcList.add(ssrc);
        }
        RedisUtil.KeyOps.delete((String)this.ssrcKey);
        RedisUtil.SetOps.sAdd((String)this.ssrcKey, (String[])((String[])ssrcList.toArray(String[]::new)));
    }

    @PreDestroy
    private void destroy() {
        if (this.ssrcKey != null) {
            RedisUtil.KeyOps.delete((String)this.ssrcKey);
        }
    }

    private String getSN() {
        long size = RedisUtil.SetOps.sSize((String)this.ssrcKey);
        if (size == 0L) {
            throw new RuntimeException("ssrc\u5df2\u7ecf\u7528\u5b8c");
        }
        String sn = RedisUtil.SetOps.sPop((String)this.ssrcKey);
        RedisUtil.SetOps.sRemove((String)this.ssrcKey, (Object[])new Object[]{sn});
        return sn;
    }

    public void reset(String mediaServerId) {
        this.init();
    }

    public String getPlaySsrc() {
        return "0" + this.getSN();
    }

    public String getPlayBackSsrc() {
        return "1" + this.getSN();
    }

    public void releaseSsrc(String mediaServerId, String ssrc) {
        if (ssrc == null) {
            return;
        }
        String sn = ssrc.substring(1);
        RedisUtil.SetOps.sAdd((String)this.ssrcKey, (String[])new String[]{sn});
    }

    public SsrcService(SipConfig sipConfig, ZlmMediaConfig mediaConfig) {
        this.sipConfig = sipConfig;
        this.mediaConfig = mediaConfig;
    }
}

