/*
 * Decompiled with CFR 0.152.
 */
package cn.skcks.docking.gb28181.starter;

import cn.skcks.docking.gb28181.common.json.JsonUtils;
import cn.skcks.docking.gb28181.config.sip.SipConfig;
import cn.skcks.docking.gb28181.core.sip.service.SipService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Order(value=0)
@Component
@DependsOn(value={"dockingOrmInitService"})
public class SipStarter
implements SmartLifecycle {
    private static final Logger log = LoggerFactory.getLogger(SipStarter.class);
    private final SipConfig sipConfig;
    private final SipService sipService;
    private boolean isRunning;

    public void start() {
        if (this.checkConfig()) {
            this.isRunning = true;
            log.debug("sip \u670d\u52a1 \u542f\u52a8");
            this.sipService.run();
        }
    }

    public void stop() {
        log.debug("sip \u670d\u52a1 \u5173\u95ed");
        this.sipService.stop();
        this.isRunning = false;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public boolean checkConfig() {
        log.debug("sip \u914d\u7f6e\u4fe1\u606f => \n{}", (Object)JsonUtils.toJson((Object)this.sipConfig));
        if (CollectionUtils.isEmpty(this.sipConfig.getIp())) {
            log.error("sip ip \u914d\u7f6e\u9519\u8bef, \u8bf7\u68c0\u67e5\u914d\u7f6e\u662f\u5426\u6b63\u786e");
            return false;
        }
        return true;
    }

    public SipStarter(SipConfig sipConfig, SipService sipService) {
        this.sipConfig = sipConfig;
        this.sipService = sipService;
    }
}

