/*
 * Decompiled with CFR 0.152.
 */
package cn.skcks.docking.gb28181.utils;

import cn.skcks.docking.gb28181.common.json.JsonResponse;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.springframework.web.context.request.async.DeferredResult;

public class FutureDeferredResult {
    public static <T> DeferredResult<JsonResponse<T>> toDeferredResultWithJson(CompletableFuture<T> future) {
        DeferredResult result = new DeferredResult();
        future.whenComplete((data, throwable) -> {
            if (throwable != null) {
                result.setResult((Object)JsonResponse.error((String)throwable.getMessage()));
                return;
            }
            result.setResult((Object)JsonResponse.success((Object)data));
        });
        return result;
    }

    public static <T> DeferredResult<JsonResponse<T>> toDeferredResultWithJsonAndTimeout(CompletableFuture<T> future, long time, TimeUnit timeUnit) {
        DeferredResult result = new DeferredResult(Long.valueOf(timeUnit.toMillis(time)));
        result.onTimeout(() -> result.setResult((Object)JsonResponse.error((String)"\u8bf7\u6c42\u8d85\u65f6")));
        future.whenComplete((data, throwable) -> {
            if (throwable != null) {
                result.setResult((Object)JsonResponse.error((String)throwable.getMessage()));
                return;
            }
            result.setResult((Object)JsonResponse.success((Object)data));
        });
        return result;
    }

    public static <T> DeferredResult<T> toDeferredResult(CompletableFuture<T> future) {
        DeferredResult result = new DeferredResult();
        future.whenComplete((data, throwable) -> result.setResult(data));
        return result;
    }

    public static <T> DeferredResult<T> toDeferredResultWithTimeout(CompletableFuture<T> future, T timeoutResult, long time, TimeUnit timeUnit) {
        DeferredResult result = new DeferredResult(Long.valueOf(timeUnit.toMillis(time)), timeoutResult);
        future.completeOnTimeout(timeoutResult, time, timeUnit);
        future.whenComplete((data, throwable) -> result.setResult(data));
        return result;
    }
}

