/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cn.sliew.carp.example.ageiport.controller;

import cn.sliew.carp.processor.core.TestHelper;
import cn.sliew.carp.processor.core.exporter.DynamicColumnExportProcessor;
import cn.sliew.carp.processor.core.exporter.MultiSheetExportProcessor;
import cn.sliew.carp.processor.core.exporter.StandaloneExportProcessor;
import cn.sliew.carp.processor.core.model.UserQuery;
import cn.sliew.milky.common.util.JacksonUtil;
import com.alibaba.ageiport.common.utils.JsonUtil;
import com.alibaba.ageiport.processor.core.AgeiPort;
import com.alibaba.ageiport.processor.core.spi.service.TaskExecuteParam;
import com.alibaba.ageiport.processor.core.spi.service.TaskExecuteResult;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.junit.jupiter.api.Assertions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/api/carp/example/ageiport/export")
@Tag(name = "测试模块-导出功能")
public class ExportController {

    @Autowired
    private AgeiPort ageiPort;

    @GetMapping
    @Operation(summary = "测试 Standalone", description = "测试 Standalone")
    public void testStandalone() throws Exception {
        //2.构造查询参数TaskExecuteParam
        UserQuery query = new UserQuery();
        query.setTotalCount(1);

        //3.调用本地方法executeTask，开始执行任务，并获取任务实例ID。
        TaskExecuteParam request = new TaskExecuteParam();
        request.setTaskSpecificationCode(DynamicColumnExportProcessor.class.getSimpleName());
        request.setBizUserId("userId");
        request.setBizQuery(JsonUtil.toJsonString(query));
        TaskExecuteResult response = ageiPort.getTaskService().executeTask(request);
        System.out.println(JacksonUtil.toJsonString(response));
        Assertions.assertTrue(response.getSuccess());

        //4.使用内部封装的TaskHelp方法判断任务是否执行成功
        TestHelper testHelper = new TestHelper(ageiPort);
        testHelper.assertWithFile(response.getMainTaskId(), query.getTotalCount());
        Thread.sleep(5000);
    }

}
