/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.example.ageiport.controller;

import cn.sliew.carp.processor.core.TestHelper;
import cn.sliew.carp.processor.core.exporter.StandaloneExportProcessor;
import cn.sliew.carp.processor.core.model.UserQuery;
import cn.sliew.milky.common.util.JacksonUtil;
import com.alibaba.ageiport.common.utils.JsonUtil;
import com.alibaba.ageiport.processor.core.AgeiPort;
import com.alibaba.ageiport.processor.core.api.http.HttpApiServerOptions;
import com.alibaba.ageiport.processor.core.spi.api.model.ExecuteMainTaskRequest;
import com.alibaba.ageiport.processor.core.spi.api.model.ExecuteMainTaskResponse;
import com.alibaba.ageiport.processor.core.spi.api.model.GetMainTaskProgressRequest;
import com.alibaba.ageiport.processor.core.spi.api.model.GetMainTaskProgressResponse;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/carp/example/ageiport/http"})
@Tag(name="\u6d4b\u8bd5\u6a21\u5757-Http\u529f\u80fd")
public class HttpController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpController.class);
    @Autowired
    private AgeiPort ageiPort;

    @GetMapping
    @Operation(summary="\u6d4b\u8bd5", description="\u6d4b\u8bd5")
    public void reqeust() throws Exception {
        UserQuery query = new UserQuery();
        query.setTotalCount(100);
        ExecuteMainTaskRequest executeMainTaskRequest = new ExecuteMainTaskRequest();
        executeMainTaskRequest.setTaskSpecificationCode(StandaloneExportProcessor.class.getSimpleName());
        executeMainTaskRequest.setBizUserId("userId");
        executeMainTaskRequest.setBizQuery(JsonUtil.toJsonString((Object)query));
        RequestOptions requestOptions = this.buildRequestOptions();
        CompletableFuture executeFuture = new CompletableFuture();
        Vertx.vertx().createHttpClient().request(requestOptions, event -> {
            HttpClientRequest clientRequest = (HttpClientRequest)event.result();
            String json = JsonUtil.toJsonString((Object)executeMainTaskRequest);
            clientRequest.send(json, event1 -> {
                HttpClientResponse result = (HttpClientResponse)event1.result();
                result.body(event2 -> {
                    String jsonString = ((Buffer)event2.result()).toString();
                    ExecuteMainTaskResponse response = (ExecuteMainTaskResponse)JsonUtil.toObject((String)jsonString, ExecuteMainTaskResponse.class);
                    executeFuture.complete(response);
                });
            });
        });
        ExecuteMainTaskResponse executeMainTaskResponse = (ExecuteMainTaskResponse)executeFuture.get(3L, TimeUnit.SECONDS);
        log.info("future, executeMainTaskRequest: {}, executeMainTaskResponse:{}", (Object)JacksonUtil.toJsonString((Object)executeMainTaskRequest), (Object)JacksonUtil.toJsonString((Object)executeMainTaskResponse));
        RequestOptions requestOptions2 = this.buildRequestOptions();
        GetMainTaskProgressRequest getMainTaskProgressRequest = new GetMainTaskProgressRequest();
        getMainTaskProgressRequest.setMainTaskId(executeMainTaskResponse.getMainTaskId());
        CompletableFuture progressFuture = new CompletableFuture();
        Vertx.vertx().createHttpClient().request(requestOptions2, event -> {
            HttpClientRequest clientRequest = (HttpClientRequest)event.result();
            String json = JsonUtil.toJsonString((Object)getMainTaskProgressRequest);
            clientRequest.send(json, event1 -> {
                HttpClientResponse result = (HttpClientResponse)event1.result();
                result.body(event22 -> {
                    String jsonString = ((Buffer)event22.result()).toString();
                    GetMainTaskProgressResponse response = (GetMainTaskProgressResponse)JsonUtil.toObject((String)jsonString, GetMainTaskProgressResponse.class);
                    progressFuture.complete(response);
                });
            });
        });
        GetMainTaskProgressResponse getMainTaskInstanceResponse = (GetMainTaskProgressResponse)progressFuture.get(3L, TimeUnit.SECONDS);
        log.info("future, getMainTaskProgressRequest: {}, getMainTaskInstanceResponse: {}", (Object)JacksonUtil.toJsonString((Object)getMainTaskProgressRequest), (Object)JacksonUtil.toJsonString((Object)getMainTaskInstanceResponse));
        TestHelper testHelper = new TestHelper(this.ageiPort);
        testHelper.assertWithFile(executeMainTaskResponse.getMainTaskId(), query.getTotalCount());
    }

    private RequestOptions buildRequestOptions() {
        HttpApiServerOptions serverOptions = (HttpApiServerOptions)this.ageiPort.getOptions().getApiServerOptions();
        return new RequestOptions().setHost("localhost").setURI("/TaskExecute").setPort(serverOptions.getPort()).setMethod(HttpMethod.POST);
    }
}

