/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.processor.core;

import com.alibaba.ageiport.common.feature.FeatureKey;
import com.alibaba.ageiport.common.feature.FeatureUtils;
import com.alibaba.ageiport.common.utils.JsonUtil;
import com.alibaba.ageiport.ext.arch.ExtensionLoader;
import com.alibaba.ageiport.processor.core.AgeiPort;
import com.alibaba.ageiport.processor.core.TaskSpec;
import com.alibaba.ageiport.processor.core.constants.MainTaskFeatureKeys;
import com.alibaba.ageiport.processor.core.model.core.ColumnHeaders;
import com.alibaba.ageiport.processor.core.model.core.impl.ColumnHeaderImpl;
import com.alibaba.ageiport.processor.core.model.core.impl.ColumnHeadersImpl;
import com.alibaba.ageiport.processor.core.model.core.impl.MainTask;
import com.alibaba.ageiport.processor.core.spi.file.DataGroup;
import com.alibaba.ageiport.processor.core.spi.file.FileContext;
import com.alibaba.ageiport.processor.core.spi.file.FileReader;
import com.alibaba.ageiport.processor.core.spi.file.FileReaderFactory;
import com.alibaba.ageiport.processor.core.spi.service.TaskProgressParam;
import com.alibaba.ageiport.processor.core.spi.service.TaskProgressResult;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TestHelper.class);
    private AgeiPort ageiPort;

    public TestHelper(AgeiPort ageiPort) {
        this.ageiPort = ageiPort;
    }

    public String file(String fileName) {
        return "." + File.separator + "import-xlsx" + File.separator + fileName;
    }

    public void assertError(String mainTaskId) throws InterruptedException {
        TaskProgressParam progressRequest = new TaskProgressParam();
        progressRequest.setMainTaskId(mainTaskId);
        TaskProgressResult taskProgress = this.ageiPort.getTaskService().getTaskProgress(progressRequest);
        int sleepTime = 0;
        log.info("getTaskProgress, taskProgress:{}", (Object)taskProgress);
        while (taskProgress == null || !taskProgress.getIsFinished().booleanValue() && !taskProgress.getIsError().booleanValue()) {
            Thread.sleep(1000L);
            if (sleepTime++ > 100) {
                Assertions.assertTrue((taskProgress.getIsFinished() != false || taskProgress.getIsError() != false ? 1 : 0) != 0);
            }
            if ((taskProgress = this.ageiPort.getTaskService().getTaskProgress(progressRequest)) != null) {
                log.info("getTaskProgress, percent:{}, stageName:{}", (Object)taskProgress.getPercent(), (Object)taskProgress.getStageName());
                continue;
            }
            log.info("no progress...");
        }
        Assertions.assertTrue((boolean)taskProgress.getIsError());
        Assertions.assertEquals((double)1.0, (Double)taskProgress.getPercent());
    }

    public void assertWithoutFile(String mainTaskId) throws InterruptedException {
        TaskProgressParam progressRequest = new TaskProgressParam();
        progressRequest.setMainTaskId(mainTaskId);
        TaskProgressResult taskProgress = this.ageiPort.getTaskService().getTaskProgress(progressRequest);
        int sleepTime = 0;
        log.info("getTaskProgress, taskProgress:{}", (Object)taskProgress);
        while (taskProgress == null || !taskProgress.getIsFinished().booleanValue() && !taskProgress.getIsError().booleanValue()) {
            Thread.sleep(1000L);
            if (sleepTime++ > 100) {
                Assertions.assertTrue((taskProgress.getIsFinished() != false || taskProgress.getIsError() != false ? 1 : 0) != 0);
            }
            if ((taskProgress = this.ageiPort.getTaskService().getTaskProgress(progressRequest)) != null) {
                log.info("getTaskProgress, percent:{}, stageName:{}", (Object)taskProgress.getPercent(), (Object)taskProgress.getStageName());
                continue;
            }
            log.info("no progress...");
        }
        Assertions.assertTrue((boolean)taskProgress.getIsFinished());
        Assertions.assertEquals((double)1.0, (Double)taskProgress.getPercent());
    }

    public void assertWithFile(String mainTaskId, Integer outputCount) throws InterruptedException {
        TaskProgressParam progressRequest = new TaskProgressParam();
        progressRequest.setMainTaskId(mainTaskId);
        TaskProgressResult taskProgress = this.ageiPort.getTaskService().getTaskProgress(progressRequest);
        int sleepTime = 0;
        log.info("getTaskProgress, taskProgress:{}", (Object)taskProgress);
        while (taskProgress == null || !taskProgress.getIsFinished().booleanValue() && !taskProgress.getIsError().booleanValue()) {
            Thread.sleep(1000L);
            if (sleepTime++ > 100) {
                Assertions.assertTrue((taskProgress.getIsFinished() != false || taskProgress.getIsError() != false ? 1 : 0) != 0);
            }
            if ((taskProgress = this.ageiPort.getTaskService().getTaskProgress(progressRequest)) != null) {
                log.info("getTaskProgress, percent:{}, stageName:{}", (Object)taskProgress.getPercent(), (Object)taskProgress.getStageName());
                continue;
            }
            log.info("no progress...");
        }
        Assertions.assertTrue((boolean)taskProgress.getIsFinished());
        Assertions.assertEquals((double)1.0, (Double)taskProgress.getPercent());
        MainTask mainTask = this.ageiPort.getTaskServerClient().getMainTask(taskProgress.getMainTaskId());
        String fileKey = (String)FeatureUtils.getFeature((String)mainTask.getFeature(), (FeatureKey)MainTaskFeatureKeys.OUTPUT_FILE_KEY);
        Assertions.assertNotNull((Object)fileKey);
        boolean exists = this.ageiPort.getFileStore().exists(fileKey, new HashMap());
        Assertions.assertTrue((boolean)exists);
        String runtimeParam = mainTask.getRuntimeParam();
        String fileType = (String)FeatureUtils.getFeature((String)runtimeParam, (FeatureKey)MainTaskFeatureKeys.RT_FILE_TYPE_KEY);
        String headersString = (String)FeatureUtils.getFeature((String)runtimeParam, (FeatureKey)MainTaskFeatureKeys.RT_COLUMN_HEADERS_KEY);
        List columnHeaderList = JsonUtil.toArrayObject((String)headersString, ColumnHeaderImpl.class);
        ArrayList columnHeaderList1 = new ArrayList(columnHeaderList);
        ColumnHeadersImpl headers = new ColumnHeadersImpl(columnHeaderList1);
        InputStream inputStream = this.ageiPort.getFileStore().get(fileKey, new HashMap());
        String outputFileReaderFactory = (String)this.ageiPort.getOptions().getFileTypeReaderSpiMappings().get(fileType);
        FileReaderFactory factory = (FileReaderFactory)ExtensionLoader.getExtensionLoader(FileReaderFactory.class).getExtension(outputFileReaderFactory);
        FileContext fileContext = new FileContext();
        fileContext.setBizQuery(JsonUtil.toJsonString((Object)mainTask.getBizQuery()));
        TaskSpec taskSpec = this.ageiPort.getSpecificationRegistry().get(mainTask.getCode());
        fileContext.setTaskSpec(taskSpec);
        fileContext.setMainTask(mainTask);
        FileReader fileReader = factory.create(this.ageiPort, (ColumnHeaders)headers, fileContext);
        fileReader.read(inputStream);
        DataGroup dataGroup = fileReader.finish();
        int count = 0;
        List data = dataGroup.getData();
        for (DataGroup.Data datum : data) {
            if (datum.getItems() == null) continue;
            count += datum.getItems().size();
        }
    }
}

