/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.processor.core.excel;

import com.alibaba.excel.write.handler.RowWriteHandler;
import com.alibaba.excel.write.handler.context.RowWriteHandlerContext;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelStyleWriteHandler
implements RowWriteHandler {
    public void afterRowDispose(RowWriteHandlerContext context) {
        CellStyle newCellStyle;
        Boolean head = context.getHead();
        Workbook workbook = context.getWriteWorkbookHolder().getWorkbook();
        if (head.booleanValue()) {
            newCellStyle = workbook.createCellStyle();
            newCellStyle.setWrapText(true);
            newCellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            newCellStyle.setAlignment(HorizontalAlignment.CENTER);
            newCellStyle.setLocked(true);
            newCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            newCellStyle.setFillForegroundColor(IndexedColors.LIGHT_TURQUOISE.getIndex());
            newCellStyle.setBorderTop(BorderStyle.THIN);
            newCellStyle.setBorderBottom(BorderStyle.THIN);
            newCellStyle.setBorderLeft(BorderStyle.THIN);
            newCellStyle.setBorderRight(BorderStyle.THIN);
        } else {
            newCellStyle = workbook.createCellStyle();
            newCellStyle.setWrapText(true);
            newCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            newCellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        }
        Row row = context.getRow();
        for (Cell cell : row) {
            cell.setCellStyle(newCellStyle);
        }
    }
}

