/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.processor.core.exporter;

import cn.sliew.carp.processor.core.model.DynamicColumnUserView;
import cn.sliew.carp.processor.core.model.UserData;
import cn.sliew.carp.processor.core.model.UserQuery;
import com.alibaba.ageiport.common.collections.Lists;
import com.alibaba.ageiport.common.utils.BeanUtils;
import com.alibaba.ageiport.common.utils.DateUtils;
import com.alibaba.ageiport.processor.core.annotation.ExportSpecification;
import com.alibaba.ageiport.processor.core.exception.BizException;
import com.alibaba.ageiport.processor.core.model.api.BizDynamicColumnHeader;
import com.alibaba.ageiport.processor.core.model.api.BizDynamicColumnHeaders;
import com.alibaba.ageiport.processor.core.model.api.BizExportPage;
import com.alibaba.ageiport.processor.core.model.api.BizUser;
import com.alibaba.ageiport.processor.core.model.api.impl.BizColumnHeaderImpl;
import com.alibaba.ageiport.processor.core.model.api.impl.BizDynamicColumnHeaderImpl;
import com.alibaba.ageiport.processor.core.model.api.impl.BizDynamicColumnHeadersImpl;
import com.alibaba.ageiport.processor.core.task.exporter.ExportProcessor;
import com.alibaba.ageiport.processor.core.task.exporter.api.BizExportTaskRuntimeConfig;
import com.alibaba.ageiport.processor.core.task.exporter.api.BizExportTaskRuntimeConfigImpl;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

@ExportSpecification(code="DynamicColumnExportProcessor", name="DynamicColumnExportProcessor")
public class DynamicColumnExportProcessor
implements ExportProcessor<UserQuery, UserData, DynamicColumnUserView> {
    public Integer totalCount(BizUser bizUser, UserQuery query) throws BizException {
        return query.getTotalCount();
    }

    public BizDynamicColumnHeaders getDynamicHeaders(BizUser user, UserQuery query) throws BizException {
        Integer dynamicHeaderCount = query.getDynamicHeaderCount();
        ArrayList<BizColumnHeaderImpl> flatColumnHeadersForQuery = new ArrayList<BizColumnHeaderImpl>();
        for (int i = 1; i <= dynamicHeaderCount; ++i) {
            BizColumnHeaderImpl columnHeader = new BizColumnHeaderImpl();
            columnHeader.setHeaderName("\u67e5\u8be2\u53c2\u6570\u52a8\u6001\u5217" + i);
            String dynamicColumnKey = "key" + i;
            columnHeader.setDynamicColumnKey(dynamicColumnKey);
            flatColumnHeadersForQuery.add(columnHeader);
        }
        BizDynamicColumnHeaderImpl bizDynamicColumnHeaderForQuery = new BizDynamicColumnHeaderImpl();
        bizDynamicColumnHeaderForQuery.setFieldName("dynamicColumnByQueryParams");
        bizDynamicColumnHeaderForQuery.setFlatColumnHeaders(flatColumnHeadersForQuery);
        ArrayList<BizColumnHeaderImpl> flatColumnHeadersForDate = new ArrayList<BizColumnHeaderImpl>();
        Date date = new Date(System.currentTimeMillis());
        String format = DateUtils.format((Date)date, (DateFormat)DateUtils.PURE_DATE_FORMAT);
        int bizdate = Integer.parseInt(format);
        for (int i = 0; i < 5; ++i) {
            String headerKey = "" + (bizdate + i);
            BizColumnHeaderImpl columnHeader = new BizColumnHeaderImpl();
            columnHeader.setHeaderName("\u65e5\u671f\u52a8\u6001\u5217:" + headerKey);
            String dynamicColumnKey = "key" + headerKey;
            columnHeader.setDynamicColumnKey(dynamicColumnKey);
            flatColumnHeadersForDate.add(columnHeader);
        }
        BizDynamicColumnHeaderImpl bizDynamicColumnHeaderForDate = new BizDynamicColumnHeaderImpl();
        bizDynamicColumnHeaderForDate.setFieldName("dynamicColumnByDate");
        bizDynamicColumnHeaderForDate.setFlatColumnHeaders(flatColumnHeadersForDate);
        BizDynamicColumnHeadersImpl bizDynamicColumnHeaders = new BizDynamicColumnHeadersImpl();
        ArrayList bizDynamicColumnHeaderList = Lists.newArrayList((Object[])new BizDynamicColumnHeader[]{bizDynamicColumnHeaderForQuery, bizDynamicColumnHeaderForDate});
        bizDynamicColumnHeaders.setBizDynamicColumnHeaders((List)bizDynamicColumnHeaderList);
        return bizDynamicColumnHeaders;
    }

    public List<UserData> queryData(BizUser user, UserQuery query, BizExportPage bizExportPage) throws BizException {
        ArrayList<UserData> dataList = new ArrayList<UserData>();
        Integer offset = bizExportPage.getOffset();
        Integer size = bizExportPage.getSize();
        for (int i = 1; i <= size; ++i) {
            int index = offset + i;
            UserData data = new UserData();
            data.setId(index);
            data.setName("name" + index);
            if (index % 3 == 0) {
                data.setGender("\u7537");
            }
            if (index % 3 == 1) {
                data.setGender("\u5973");
            }
            if (index % 3 == 2) {
                data.setGender("\u5176\u4ed6");
            }
            dataList.add(data);
        }
        return dataList;
    }

    public List<DynamicColumnUserView> convert(BizUser user, UserQuery query, List<UserData> data) throws BizException {
        ArrayList<DynamicColumnUserView> dataList = new ArrayList<DynamicColumnUserView>();
        int row = 1;
        for (UserData datum : data) {
            DynamicColumnUserView view = (DynamicColumnUserView)BeanUtils.cloneProp((Object)datum, DynamicColumnUserView.class);
            dataList.add(view);
            Integer dynamicHeaderCount = query.getDynamicHeaderCount();
            HashMap<String, Object> dynamicColumnByQueryParams = new HashMap<String, Object>();
            for (int i = 1; i <= dynamicHeaderCount; ++i) {
                String dynamicColumnKey = "key" + i;
                dynamicColumnByQueryParams.put(dynamicColumnKey, "row:" + row + ",col:" + i);
            }
            view.setDynamicColumnByQueryParams(dynamicColumnByQueryParams);
            Date date = new Date(System.currentTimeMillis());
            String format = DateUtils.format((Date)date, (DateFormat)DateUtils.PURE_DATE_FORMAT);
            int bizdate = Integer.parseInt(format);
            HashMap<String, Object> dynamicColumnByDate = new HashMap<String, Object>();
            for (int i = 0; i < 5; ++i) {
                String headerKey = "" + (bizdate + i);
                String dynamicColumnKey = "key" + headerKey;
                dynamicColumnByDate.put(dynamicColumnKey, "row:" + row + ",col:" + i);
            }
            view.setDynamicColumnByDate(dynamicColumnByDate);
            ++row;
        }
        return dataList;
    }

    public BizExportTaskRuntimeConfig taskRuntimeConfig(BizUser user, UserQuery query) throws BizException {
        BizExportTaskRuntimeConfigImpl runtimeConfig = new BizExportTaskRuntimeConfigImpl();
        runtimeConfig.setExecuteType("STANDALONE");
        return runtimeConfig;
    }
}

