/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.processor.core.exporter;

import cn.sliew.carp.processor.core.model.MultiSheetUserView;
import cn.sliew.carp.processor.core.model.UserData;
import cn.sliew.carp.processor.core.model.UserQuery;
import com.alibaba.ageiport.common.utils.BeanUtils;
import com.alibaba.ageiport.common.utils.JsonUtil;
import com.alibaba.ageiport.processor.core.annotation.ExportSpecification;
import com.alibaba.ageiport.processor.core.exception.BizException;
import com.alibaba.ageiport.processor.core.model.api.BizDataGroup;
import com.alibaba.ageiport.processor.core.model.api.BizExportPage;
import com.alibaba.ageiport.processor.core.model.api.BizUser;
import com.alibaba.ageiport.processor.core.model.api.impl.BizDataGroupImpl;
import com.alibaba.ageiport.processor.core.task.exporter.ExportProcessor;
import com.alibaba.ageiport.processor.core.task.exporter.api.BizExportTaskRuntimeConfig;
import com.alibaba.ageiport.processor.core.task.exporter.api.BizExportTaskRuntimeConfigImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@ExportSpecification(code="MultiSheetExportProcessor", name="MultiSheetExportProcessor")
public class MultiSheetExportProcessor
implements ExportProcessor<UserQuery, UserData, MultiSheetUserView> {
    public Integer totalCount(BizUser bizUser, UserQuery query) throws BizException {
        return query.getTotalCount();
    }

    public List<UserData> queryData(BizUser user, UserQuery query, BizExportPage bizExportPage) throws BizException {
        ArrayList<UserData> dataList = new ArrayList<UserData>();
        Integer offset = bizExportPage.getOffset();
        Integer size = bizExportPage.getSize();
        for (int i = 1; i <= size; ++i) {
            int index = offset + i;
            UserData data = new UserData();
            data.setId(index);
            data.setName("name" + index);
            if (index % 3 == 0) {
                data.setGender("\u7537");
            }
            if (index % 3 == 1) {
                data.setGender("\u5973");
            }
            if (index % 3 == 2) {
                data.setGender("\u5176\u4ed6");
            }
            data.setAge(new BigDecimal(i % 100));
            data.setManQuestion1("\u7537\u6027\u95ee\u9898\u56de\u7b541");
            data.setManQuestion2("\u7537\u6027\u95ee\u9898\u56de\u7b542");
            data.setWomenQuestion1("\u5973\u6027\u95ee\u9898\u56de\u7b541");
            data.setWomenQuestion2("\u5973\u6027\u95ee\u9898\u56de\u7b542");
            data.setOtherQuestion1("\u5176\u4ed6\u6027\u522b\u95ee\u9898\u56de\u7b541");
            data.setOtherQuestion2("\u5176\u4ed6\u6027\u522b\u95ee\u9898\u56de\u7b542");
            dataList.add(data);
        }
        return dataList;
    }

    public List<MultiSheetUserView> convert(BizUser user, UserQuery query, List<UserData> data) throws BizException {
        ArrayList<MultiSheetUserView> dataList = new ArrayList<MultiSheetUserView>();
        for (UserData datum : data) {
            MultiSheetUserView view = (MultiSheetUserView)BeanUtils.cloneProp((Object)datum, MultiSheetUserView.class);
            dataList.add(view);
        }
        return dataList;
    }

    public BizDataGroup<MultiSheetUserView> group(BizUser user, UserQuery query, List<MultiSheetUserView> views) {
        BizDataGroupImpl group = new BizDataGroupImpl();
        BizDataGroupImpl.Data dataMan = new BizDataGroupImpl.Data();
        ArrayList<BizDataGroupImpl.Item> itemsMan = new ArrayList<BizDataGroupImpl.Item>();
        dataMan.setItems(itemsMan);
        HashMap<String, String> metaMan = new HashMap<String, String>();
        metaMan.put("_sheetName", "\u7537");
        metaMan.put("_sheetNo", "0");
        dataMan.setMeta(metaMan);
        dataMan.setCode(JsonUtil.toJsonString(metaMan));
        BizDataGroupImpl.Data dataWomen = new BizDataGroupImpl.Data();
        ArrayList<BizDataGroupImpl.Item> itemsWomen = new ArrayList<BizDataGroupImpl.Item>();
        dataWomen.setItems(itemsWomen);
        HashMap<String, String> metaWomen = new HashMap<String, String>();
        metaWomen.put("_sheetName", "\u5973");
        metaWomen.put("_sheetNo", "1");
        dataWomen.setMeta(metaWomen);
        dataWomen.setCode(JsonUtil.toJsonString(metaWomen));
        BizDataGroupImpl.Data dataOther = new BizDataGroupImpl.Data();
        ArrayList<BizDataGroupImpl.Item> itemsOther = new ArrayList<BizDataGroupImpl.Item>();
        dataOther.setItems(itemsOther);
        HashMap<String, String> metaOther = new HashMap<String, String>();
        metaOther.put("_sheetName", "\u5176\u4ed6");
        metaOther.put("_sheetNo", "2");
        dataOther.setMeta(metaOther);
        dataWomen.setCode(JsonUtil.toJsonString(metaOther));
        ArrayList<BizDataGroupImpl.Data> dataList = new ArrayList<BizDataGroupImpl.Data>();
        dataList.add(dataMan);
        dataList.add(dataWomen);
        dataList.add(dataOther);
        group.setData(dataList);
        for (MultiSheetUserView view : views) {
            BizDataGroupImpl.Item item = new BizDataGroupImpl.Item();
            item.setData((Object)view);
            if (view.getGender().equals("\u7537")) {
                itemsMan.add(item);
                continue;
            }
            if (view.getGender().equals("\u5973")) {
                itemsWomen.add(item);
                continue;
            }
            itemsOther.add(item);
        }
        return group;
    }

    public BizExportTaskRuntimeConfig taskRuntimeConfig(BizUser user, UserQuery query) throws BizException {
        BizExportTaskRuntimeConfigImpl runtimeConfig = new BizExportTaskRuntimeConfigImpl();
        runtimeConfig.setExecuteType("STANDALONE");
        return runtimeConfig;
    }
}

