/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.processor.core.exporter;

import cn.sliew.carp.processor.core.model.UserData;
import cn.sliew.carp.processor.core.model.UserQuery;
import cn.sliew.carp.processor.core.model.UserView;
import com.alibaba.ageiport.common.utils.BeanUtils;
import com.alibaba.ageiport.processor.core.annotation.ExportSpecification;
import com.alibaba.ageiport.processor.core.exception.BizException;
import com.alibaba.ageiport.processor.core.model.api.BizExportPage;
import com.alibaba.ageiport.processor.core.model.api.BizUser;
import com.alibaba.ageiport.processor.core.task.exporter.ExportProcessor;
import com.alibaba.ageiport.processor.core.task.exporter.api.BizExportTaskRuntimeConfig;
import com.alibaba.ageiport.processor.core.task.exporter.api.BizExportTaskRuntimeConfigImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@ExportSpecification(code="StandaloneExportProcessor", name="StandaloneExportProcessor")
public class StandaloneExportProcessor
implements ExportProcessor<UserQuery, UserData, UserView> {
    public Integer totalCount(BizUser bizUser, UserQuery query) throws BizException {
        return query.getTotalCount();
    }

    public List<UserData> queryData(BizUser user, UserQuery query, BizExportPage bizExportPage) throws BizException {
        if (query.isErrorWhenQueryData()) {
            throw new BizException("BIZ_EXC_001", "Error when query");
        }
        ArrayList<UserData> dataList = new ArrayList<UserData>();
        Integer offset = bizExportPage.getOffset();
        Integer size = bizExportPage.getSize();
        for (int i = 1; i <= size; ++i) {
            int index = offset + i;
            UserData data = new UserData();
            data.setId(index);
            data.setName("name" + index);
            if (index % 3 == 0) {
                data.setGender("\u7537");
            }
            if (index % 3 == 1) {
                data.setGender("\u5973");
            }
            if (index % 3 == 2) {
                data.setGender("\u5176\u4ed6");
            }
            data.setAge(new BigDecimal(10));
            dataList.add(data);
        }
        return dataList;
    }

    public List<UserView> convert(BizUser user, UserQuery query, List<UserData> data) throws BizException {
        ArrayList<UserView> dataList = new ArrayList<UserView>();
        for (UserData datum : data) {
            UserView view = (UserView)BeanUtils.cloneProp((Object)datum, UserView.class);
            dataList.add(view);
        }
        return dataList;
    }

    public BizExportTaskRuntimeConfig taskRuntimeConfig(BizUser user, UserQuery query) throws BizException {
        BizExportTaskRuntimeConfigImpl runtimeConfig = new BizExportTaskRuntimeConfigImpl();
        runtimeConfig.setExecuteType("STANDALONE");
        return runtimeConfig;
    }
}

