/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.processor.core.importer;

import cn.sliew.carp.processor.core.model.DynamicColumnUserView;
import cn.sliew.carp.processor.core.model.UserData;
import cn.sliew.carp.processor.core.model.UserQuery;
import com.alibaba.ageiport.common.collections.Lists;
import com.alibaba.ageiport.common.logger.Logger;
import com.alibaba.ageiport.common.logger.LoggerFactory;
import com.alibaba.ageiport.common.utils.DateUtils;
import com.alibaba.ageiport.common.utils.JsonUtil;
import com.alibaba.ageiport.processor.core.annotation.ImportSpecification;
import com.alibaba.ageiport.processor.core.exception.BizException;
import com.alibaba.ageiport.processor.core.model.api.BizDynamicColumnHeader;
import com.alibaba.ageiport.processor.core.model.api.BizDynamicColumnHeaders;
import com.alibaba.ageiport.processor.core.model.api.BizUser;
import com.alibaba.ageiport.processor.core.model.api.impl.BizColumnHeaderImpl;
import com.alibaba.ageiport.processor.core.model.api.impl.BizDynamicColumnHeaderImpl;
import com.alibaba.ageiport.processor.core.model.api.impl.BizDynamicColumnHeadersImpl;
import com.alibaba.ageiport.processor.core.task.importer.ImportProcessor;
import com.alibaba.ageiport.processor.core.task.importer.api.BizImportTaskRuntimeConfig;
import com.alibaba.ageiport.processor.core.task.importer.api.BizImportTaskRuntimeConfigImpl;
import com.alibaba.ageiport.processor.core.task.importer.model.BizImportResult;
import com.alibaba.ageiport.processor.core.task.importer.model.BizImportResultImpl;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

@ImportSpecification(code="DynamicColumnImportProcessor", name="DynamicColumnImportProcessor")
public class DynamicColumnImportProcessor
implements ImportProcessor<UserQuery, UserData, DynamicColumnUserView> {
    Logger logger = LoggerFactory.getLogger(DynamicColumnImportProcessor.class);

    public BizDynamicColumnHeaders getDynamicHeaders(BizUser user, UserQuery query) throws BizException {
        Integer dynamicHeaderCount = query.getDynamicHeaderCount();
        ArrayList<BizColumnHeaderImpl> flatColumnHeadersForQuery = new ArrayList<BizColumnHeaderImpl>();
        for (int i = 1; i <= dynamicHeaderCount; ++i) {
            BizColumnHeaderImpl columnHeader = new BizColumnHeaderImpl();
            columnHeader.setHeaderName("\u67e5\u8be2\u53c2\u6570\u52a8\u6001\u5217" + i);
            String dynamicColumnKey = "key" + i;
            columnHeader.setDynamicColumnKey(dynamicColumnKey);
            flatColumnHeadersForQuery.add(columnHeader);
        }
        BizDynamicColumnHeaderImpl bizDynamicColumnHeaderForQuery = new BizDynamicColumnHeaderImpl();
        bizDynamicColumnHeaderForQuery.setFieldName("dynamicColumnByQueryParams");
        bizDynamicColumnHeaderForQuery.setFlatColumnHeaders(flatColumnHeadersForQuery);
        ArrayList<BizColumnHeaderImpl> flatColumnHeadersForDate = new ArrayList<BizColumnHeaderImpl>();
        Date date = new Date(System.currentTimeMillis());
        String format = DateUtils.format((Date)date, (DateFormat)DateUtils.PURE_DATE_FORMAT);
        int bizdate = Integer.parseInt(format);
        for (int i = 0; i < 5; ++i) {
            String headerKey = "" + (bizdate + i);
            BizColumnHeaderImpl columnHeader = new BizColumnHeaderImpl();
            columnHeader.setHeaderName("\u65e5\u671f\u52a8\u6001\u5217:" + headerKey);
            String dynamicColumnKey = "key" + headerKey;
            columnHeader.setDynamicColumnKey(dynamicColumnKey);
            flatColumnHeadersForDate.add(columnHeader);
        }
        BizDynamicColumnHeaderImpl bizDynamicColumnHeaderForDate = new BizDynamicColumnHeaderImpl();
        bizDynamicColumnHeaderForDate.setFieldName("dynamicColumnByDate");
        bizDynamicColumnHeaderForDate.setFlatColumnHeaders(flatColumnHeadersForDate);
        BizDynamicColumnHeadersImpl bizDynamicColumnHeaders = new BizDynamicColumnHeadersImpl();
        ArrayList bizDynamicColumnHeaderList = Lists.newArrayList((Object[])new BizDynamicColumnHeader[]{bizDynamicColumnHeaderForQuery, bizDynamicColumnHeaderForDate});
        bizDynamicColumnHeaders.setBizDynamicColumnHeaders((List)bizDynamicColumnHeaderList);
        return bizDynamicColumnHeaders;
    }

    public BizImportResult<DynamicColumnUserView, UserData> convertAndCheck(BizUser user, UserQuery query, List<DynamicColumnUserView> views) {
        BizImportResultImpl result = new BizImportResultImpl();
        ArrayList<UserData> data = new ArrayList<UserData>();
        for (DynamicColumnUserView view : views) {
            UserData datum = new UserData();
            datum.setId(view.getId());
            datum.setName(view.getName());
            HashMap<String, Object> dynamicColumns = new HashMap<String, Object>();
            dynamicColumns.putAll(view.getDynamicColumnByDate());
            dynamicColumns.putAll(view.getDynamicColumnByQueryParams());
            datum.setDynamicColumns(dynamicColumns);
            data.add(datum);
        }
        result.setData(data);
        return result;
    }

    public BizImportResult<DynamicColumnUserView, UserData> write(BizUser user, UserQuery query, List<UserData> data) {
        BizImportResultImpl result = new BizImportResultImpl();
        for (UserData datum : data) {
            this.logger.info(JsonUtil.toJsonString((Object)datum));
        }
        if (query.isErrorWhenWriteData()) {
            throw new IllegalStateException("Error when write");
        }
        return result;
    }

    public BizImportTaskRuntimeConfig taskRuntimeConfig(BizUser user, UserQuery query) throws BizException {
        BizImportTaskRuntimeConfigImpl runtimeConfig = new BizImportTaskRuntimeConfigImpl();
        runtimeConfig.setExecuteType("STANDALONE");
        return runtimeConfig;
    }
}

