/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.processor.core.client.http;

import com.alibaba.ageiport.common.logger.Logger;
import com.alibaba.ageiport.common.logger.LoggerFactory;
import com.alibaba.ageiport.common.utils.BeanUtils;
import com.alibaba.ageiport.common.utils.JsonUtil;
import com.alibaba.ageiport.processor.core.AgeiPort;
import com.alibaba.ageiport.processor.core.AgeiPortOptions;
import com.alibaba.ageiport.processor.core.client.http.HttpTaskServerClientOptions;
import com.alibaba.ageiport.processor.core.model.core.impl.MainTask;
import com.alibaba.ageiport.processor.core.model.core.impl.SubTask;
import com.alibaba.ageiport.processor.core.model.core.impl.TaskSpecification;
import com.alibaba.ageiport.processor.core.spi.client.CreateMainTaskRequest;
import com.alibaba.ageiport.processor.core.spi.client.CreateSpecificationRequest;
import com.alibaba.ageiport.processor.core.spi.client.CreateSubTasksRequest;
import com.alibaba.ageiport.processor.core.spi.client.TaskServerClient;
import com.alibaba.ageiport.sdk.core.Response;
import com.alibaba.ageiport.task.server.model.CreateMainTaskInstanceRequest;
import com.alibaba.ageiport.task.server.model.CreateMainTaskInstanceResponse;
import com.alibaba.ageiport.task.server.model.CreateSubTaskInstancesRequest;
import com.alibaba.ageiport.task.server.model.CreateSubTaskInstancesResponse;
import com.alibaba.ageiport.task.server.model.CreateTaskSpecificationRequest;
import com.alibaba.ageiport.task.server.model.CreateTaskSpecificationResponse;
import com.alibaba.ageiport.task.server.model.GetMainTaskInstanceRequest;
import com.alibaba.ageiport.task.server.model.GetMainTaskInstanceResponse;
import com.alibaba.ageiport.task.server.model.GetSubTaskInstanceRequest;
import com.alibaba.ageiport.task.server.model.GetSubTaskInstanceResponse;
import com.alibaba.ageiport.task.server.model.GetTaskSpecificationRequest;
import com.alibaba.ageiport.task.server.model.GetTaskSpecificationResponse;
import com.alibaba.ageiport.task.server.model.UpdateMainTaskInstanceRequest;
import com.alibaba.ageiport.task.server.model.UpdateMainTaskInstanceResponse;
import com.alibaba.ageiport.task.server.model.UpdateSubTaskInstanceRequest;
import com.alibaba.ageiport.task.server.model.UpdateSubTaskInstanceResponse;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;

public class HttpTaskServerClient
implements TaskServerClient {
    public static Logger LOGGER = LoggerFactory.getLogger(HttpTaskServerClient.class);
    public static final MediaType JSON = MediaType.get((String)"application/json; charset=utf-8");
    private AgeiPort ageiPort;
    private String domain;
    private Integer timeoutMs;
    private OkHttpClient client;
    HttpTaskServerClientOptions httpTaskServerClientOptions;

    public HttpTaskServerClient(AgeiPort ageiPort, HttpTaskServerClientOptions options) {
        this.ageiPort = ageiPort;
        this.domain = options.getSchema() + "://" + options.getEndpoint() + ":" + options.getPort();
        this.timeoutMs = options.getTimeoutMs();
        this.client = new OkHttpClient().newBuilder().callTimeout((long)this.timeoutMs.intValue(), TimeUnit.MILLISECONDS).connectTimeout((long)this.timeoutMs.intValue(), TimeUnit.MILLISECONDS).readTimeout((long)this.timeoutMs.intValue(), TimeUnit.MILLISECONDS).writeTimeout((long)this.timeoutMs.intValue(), TimeUnit.MILLISECONDS).retryOnConnectionFailure(true).build();
        this.httpTaskServerClientOptions = options;
    }

    public String createMainTask(CreateMainTaskRequest createMainTaskRequest) {
        CreateMainTaskInstanceRequest request = (CreateMainTaskInstanceRequest)BeanUtils.cloneProp((Object)createMainTaskRequest, CreateMainTaskInstanceRequest.class);
        request.setDomain(this.domain);
        CreateMainTaskInstanceResponse response = (CreateMainTaskInstanceResponse)this.getResponse((com.alibaba.ageiport.sdk.core.Request)request);
        if (response.getSuccess().booleanValue() && response.getData() != null) {
            return response.getData().getMainTaskId();
        }
        throw new IllegalArgumentException("CreateMainTaskInstanceRequest failed:" + response);
    }

    public void updateMainTask(MainTask mainTask) {
        UpdateMainTaskInstanceRequest request = (UpdateMainTaskInstanceRequest)BeanUtils.cloneProp((Object)mainTask, UpdateMainTaskInstanceRequest.class);
        request.setDomain(this.domain);
        UpdateMainTaskInstanceResponse response = (UpdateMainTaskInstanceResponse)this.getResponse((com.alibaba.ageiport.sdk.core.Request)request);
        if (!response.getSuccess().booleanValue()) {
            throw new IllegalArgumentException("UpdateMainTaskInstanceRequest failed:" + response);
        }
    }

    public MainTask getMainTask(String mainTaskId) {
        GetMainTaskInstanceRequest request = new GetMainTaskInstanceRequest();
        request.setMainTaskId(mainTaskId);
        GetMainTaskInstanceResponse response = (GetMainTaskInstanceResponse)this.getResponse((com.alibaba.ageiport.sdk.core.Request)request);
        if (!response.getSuccess().booleanValue()) {
            throw new IllegalArgumentException("GetMainTaskInstanceRequest failed:" + response);
        }
        GetMainTaskInstanceResponse.Data responseData = response.getData();
        MainTask mainTask = (MainTask)BeanUtils.cloneProp((Object)responseData, MainTask.class);
        return mainTask;
    }

    public List<String> createSubTask(CreateSubTasksRequest createSubTasksRequest) {
        CreateSubTaskInstancesRequest request = (CreateSubTaskInstancesRequest)BeanUtils.cloneProp((Object)createSubTasksRequest, CreateSubTaskInstancesRequest.class);
        CreateSubTaskInstancesResponse response = (CreateSubTaskInstancesResponse)this.getResponse((com.alibaba.ageiport.sdk.core.Request)request);
        if (!response.getSuccess().booleanValue()) {
            throw new IllegalArgumentException("CreateSubTaskInstancesRequest failed:" + response);
        }
        return response.getData().getSubTaskIds();
    }

    public void updateSubTask(SubTask subTask) {
        UpdateSubTaskInstanceRequest request = (UpdateSubTaskInstanceRequest)BeanUtils.cloneProp((Object)subTask, UpdateSubTaskInstanceRequest.class);
        UpdateSubTaskInstanceResponse response = (UpdateSubTaskInstanceResponse)this.getResponse((com.alibaba.ageiport.sdk.core.Request)request);
        if (!response.getSuccess().booleanValue()) {
            throw new IllegalArgumentException("UpdateSubTaskInstanceRequest failed:" + response);
        }
    }

    public SubTask getSubTask(String subTaskId) {
        GetSubTaskInstanceRequest request = new GetSubTaskInstanceRequest();
        request.setSubTaskId(subTaskId);
        GetSubTaskInstanceResponse response = (GetSubTaskInstanceResponse)this.getResponse((com.alibaba.ageiport.sdk.core.Request)request);
        if (!response.getSuccess().booleanValue()) {
            throw new IllegalArgumentException("GetSubTaskInstanceRequest failed:" + response);
        }
        GetSubTaskInstanceResponse.Data responseData = response.getData();
        SubTask subTask = (SubTask)BeanUtils.cloneProp((Object)responseData, SubTask.class);
        return subTask;
    }

    public TaskSpecification getTaskSpecification(String taskCode) {
        GetTaskSpecificationRequest request = new GetTaskSpecificationRequest();
        request.setTaskCode(taskCode);
        GetTaskSpecificationResponse response = (GetTaskSpecificationResponse)this.getResponse((com.alibaba.ageiport.sdk.core.Request)request);
        if (!response.getSuccess().booleanValue()) {
            throw new IllegalArgumentException("GetSubTaskInstanceRequest failed:" + response);
        }
        GetTaskSpecificationResponse.Data responseData = response.getData();
        TaskSpecification taskSpecification = (TaskSpecification)BeanUtils.cloneProp((Object)responseData, TaskSpecification.class);
        return taskSpecification;
    }

    public String createTaskSpecification(CreateSpecificationRequest createSpecificationRequest) {
        CreateTaskSpecificationRequest request = (CreateTaskSpecificationRequest)BeanUtils.cloneProp((Object)createSpecificationRequest, CreateTaskSpecificationRequest.class);
        CreateTaskSpecificationResponse response = (CreateTaskSpecificationResponse)this.getResponse((com.alibaba.ageiport.sdk.core.Request)request);
        if (!response.getSuccess().booleanValue()) {
            throw new IllegalArgumentException("CreateTaskSpecificationRequest failed:" + response);
        }
        return response.getData().getId().toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T extends Response> T getResponse(com.alibaba.ageiport.sdk.core.Request<T> request) {
        AgeiPortOptions options = this.ageiPort.getOptions();
        request.setAccessKeyId(options.getAccessKeyId());
        request.setApp(options.getApp());
        request.setNamespace(options.getNamespace());
        request.setDomain(this.domain);
        String json = JsonUtil.toJsonString(request);
        RequestBody body = RequestBody.create((MediaType)JSON, (String)json);
        String requestDomain = request.getDomain();
        String requestVersion = request.getVersion();
        String requestAction = request.getAction();
        String url = requestDomain + "/" + requestVersion + "/" + requestAction;
        Request httpRequest = new Request.Builder().url(url).post(body).build();
        try (okhttp3.Response httpResponse = this.client.newCall(httpRequest).execute();){
            ResponseBody responseBody = httpResponse.body();
            String bodyAsString = responseBody.string();
            Response response = (Response)JsonUtil.toObject((String)bodyAsString, (Class)request.getResponseClass());
            return (T)response;
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
    }

    public String retryRequest(Request httpRequest) throws IOException {
        String string;
        block8: {
            okhttp3.Response httpResponse = this.client.newCall(httpRequest).execute();
            try {
                String bodyAsString;
                ResponseBody responseBody = httpResponse.body();
                string = bodyAsString = responseBody.string();
                if (httpResponse == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (httpResponse != null) {
                        try {
                            httpResponse.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    LOGGER.error("http request failed, ", e);
                    throw new IllegalStateException(e);
                }
            }
            httpResponse.close();
        }
        return string;
    }
}

