/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.typed.internal;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.pekko.actor.typed.ActorSystem;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.persistence.Persistence$;
import org.apache.pekko.persistence.typed.internal.EventSourcedSettings;
import org.apache.pekko.persistence.typed.internal.StashOverflowStrategy;
import org.apache.pekko.persistence.typed.internal.StashOverflowStrategy$Drop$;
import org.apache.pekko.persistence.typed.internal.StashOverflowStrategy$Fail$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple7;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxesRunTime;

@InternalApi
public final class EventSourcedSettings$
implements scala.Serializable {
    public static EventSourcedSettings$ MODULE$;

    static {
        new EventSourcedSettings$();
    }

    public EventSourcedSettings apply(ActorSystem<?> system, String journalPluginId, String snapshotPluginId) {
        return this.apply(system.settings().config(), journalPluginId, snapshotPluginId);
    }

    public EventSourcedSettings apply(Config config, String journalPluginId, String snapshotPluginId) {
        Product product;
        Config typedConfig = config.getConfig("pekko.persistence.typed");
        String string = typedConfig.getString("stash-overflow-strategy").toLowerCase();
        if ("drop".equals(string)) {
            product = StashOverflowStrategy$Drop$.MODULE$;
        } else if ("fail".equals(string)) {
            product = StashOverflowStrategy$Fail$.MODULE$;
        } else {
            throw new IllegalArgumentException(new StringBuilder(45).append("Unknown value for stash-overflow-strategy: [").append(string).append("]").toString());
        }
        StashOverflowStrategy$Drop$ stashOverflowStrategy = product;
        int stashCapacity = typedConfig.getInt("stash-capacity");
        Predef$.MODULE$.require(stashCapacity > 0, (Function0 & Serializable & scala.Serializable)() -> "stash-capacity MUST be > 0, unbounded buffering is not supported.");
        boolean logOnStashing = typedConfig.getBoolean("log-stashing");
        Config journalConfig = this.journalConfigFor(config, journalPluginId);
        FiniteDuration recoveryEventTimeout = new package.DurationLong(package$.MODULE$.DurationLong(journalConfig.getDuration("recovery-event-timeout", TimeUnit.MILLISECONDS))).millis();
        boolean useContextLoggerForInternalLogging = typedConfig.getBoolean("use-context-logger-for-internal-logging");
        Persistence$.MODULE$.verifyPluginConfigExists(config, snapshotPluginId, "Snapshot store");
        return new EventSourcedSettings(stashCapacity, stashOverflowStrategy, logOnStashing, recoveryEventTimeout, journalPluginId, snapshotPluginId, useContextLoggerForInternalLogging);
    }

    private Config journalConfigFor(Config config, String journalPluginId) {
        String string = journalPluginId;
        String string2 = "";
        String configPath = string != null && string.equals(string2) ? EventSourcedSettings$.defaultJournalPluginId$1(config) : journalPluginId;
        Persistence$.MODULE$.verifyPluginConfigExists(config, configPath, "Journal");
        return config.getConfig(configPath).withFallback((ConfigMergeable)config.getConfig(Persistence$.MODULE$.JournalFallbackConfigPath()));
    }

    public EventSourcedSettings apply(int stashCapacity, StashOverflowStrategy stashOverflowStrategy, boolean logOnStashing, FiniteDuration recoveryEventTimeout, String journalPluginId, String snapshotPluginId, boolean useContextLoggerForInternalLogging) {
        return new EventSourcedSettings(stashCapacity, stashOverflowStrategy, logOnStashing, recoveryEventTimeout, journalPluginId, snapshotPluginId, useContextLoggerForInternalLogging);
    }

    public Option<Tuple7<Object, StashOverflowStrategy, Object, FiniteDuration, String, String, Object>> unapply(EventSourcedSettings x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple7((Object)BoxesRunTime.boxToInteger((int)x$0.stashCapacity()), (Object)x$0.stashOverflowStrategy(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.logOnStashing()), (Object)x$0.recoveryEventTimeout(), (Object)x$0.journalPluginId(), (Object)x$0.snapshotPluginId(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.useContextLoggerForInternalLogging())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final String defaultJournalPluginId$1(Config config$1) {
        String configPath = config$1.getString("pekko.persistence.journal.plugin");
        Persistence$.MODULE$.verifyPluginConfigIsDefined(configPath, "Default journal");
        return configPath;
    }

    private EventSourcedSettings$() {
        MODULE$ = this;
    }
}

