/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.typed.state.internal;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigMergeable;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.pekko.actor.typed.ActorSystem;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.persistence.Persistence$;
import org.apache.pekko.persistence.typed.state.internal.DurableStateSettings;
import org.apache.pekko.persistence.typed.state.internal.StashOverflowStrategy;
import org.apache.pekko.persistence.typed.state.internal.StashOverflowStrategy$Drop$;
import org.apache.pekko.persistence.typed.state.internal.StashOverflowStrategy$Fail$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple6;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxesRunTime;

@InternalApi
public final class DurableStateSettings$
implements scala.Serializable {
    public static DurableStateSettings$ MODULE$;

    static {
        new DurableStateSettings$();
    }

    public DurableStateSettings apply(ActorSystem<?> system, String durableStateStorePluginId) {
        return this.apply(system.settings().config(), durableStateStorePluginId);
    }

    public DurableStateSettings apply(Config config, String durableStateStorePluginId) {
        StashOverflowStrategy stashOverflowStrategy;
        Config typedConfig = config.getConfig("pekko.persistence.typed");
        String string = typedConfig.getString("stash-overflow-strategy").toLowerCase();
        if ("drop".equals(string)) {
            stashOverflowStrategy = StashOverflowStrategy$Drop$.MODULE$;
        } else if ("fail".equals(string)) {
            stashOverflowStrategy = StashOverflowStrategy$Fail$.MODULE$;
        } else {
            throw new IllegalArgumentException(new StringBuilder(45).append("Unknown value for stash-overflow-strategy: [").append(string).append("]").toString());
        }
        StashOverflowStrategy$Drop$ stashOverflowStrategy2 = stashOverflowStrategy;
        int stashCapacity = typedConfig.getInt("stash-capacity");
        Predef$.MODULE$.require(stashCapacity > 0, (Function0 & Serializable & scala.Serializable)() -> "stash-capacity MUST be > 0, unbounded buffering is not supported.");
        boolean logOnStashing = typedConfig.getBoolean("log-stashing");
        Config durableStateStoreConfig = this.durableStateStoreConfigFor(config, durableStateStorePluginId);
        FiniteDuration recoveryTimeout = new package.DurationLong(package$.MODULE$.DurationLong(durableStateStoreConfig.getDuration("recovery-timeout", TimeUnit.MILLISECONDS))).millis();
        boolean useContextLoggerForInternalLogging = typedConfig.getBoolean("use-context-logger-for-internal-logging");
        return new DurableStateSettings(stashCapacity, stashOverflowStrategy2, logOnStashing, recoveryTimeout, durableStateStorePluginId, useContextLoggerForInternalLogging);
    }

    private Config durableStateStoreConfigFor(Config config, String pluginId) {
        String string = pluginId;
        String string2 = "";
        String configPath = string != null && string.equals(string2) ? DurableStateSettings$.defaultPluginId$1(config) : pluginId;
        Persistence$.MODULE$.verifyPluginConfigExists(config, configPath, "DurableStateStore");
        return config.getConfig(configPath).withFallback((ConfigMergeable)config.getConfig("pekko.persistence.state-plugin-fallback"));
    }

    public DurableStateSettings apply(int stashCapacity, StashOverflowStrategy stashOverflowStrategy, boolean logOnStashing, FiniteDuration recoveryTimeout, String durableStateStorePluginId, boolean useContextLoggerForInternalLogging) {
        return new DurableStateSettings(stashCapacity, stashOverflowStrategy, logOnStashing, recoveryTimeout, durableStateStorePluginId, useContextLoggerForInternalLogging);
    }

    public Option<Tuple6<Object, StashOverflowStrategy, Object, FiniteDuration, String, Object>> unapply(DurableStateSettings x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple6((Object)BoxesRunTime.boxToInteger((int)x$0.stashCapacity()), (Object)x$0.stashOverflowStrategy(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.logOnStashing()), (Object)x$0.recoveryTimeout(), (Object)x$0.durableStateStorePluginId(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.useContextLoggerForInternalLogging())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final String defaultPluginId$1(Config config$1) {
        String configPath = config$1.getString("pekko.persistence.state.plugin");
        Persistence$.MODULE$.verifyPluginConfigIsDefined(configPath, "Default DurableStateStore");
        return configPath;
    }

    private DurableStateSettings$() {
        MODULE$ = this;
    }
}

