/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.kubernetes.watch.source.event.source.informer;

import cn.sliew.carp.module.kubernetes.watch.source.event.Event;
import cn.sliew.carp.module.kubernetes.watch.source.event.ResourceID;
import cn.sliew.carp.module.kubernetes.watch.source.event.source.AbstractResourceEventSource;
import cn.sliew.carp.module.kubernetes.watch.source.event.source.informer.InformerManager;
import io.fabric8.kubernetes.api.model.GroupVersionKind;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;

public class InfomerEventSource<R extends HasMetadata, P extends HasMetadata>
extends AbstractResourceEventSource<R, P>
implements ResourceEventHandler<R> {
    private InformerManager<R> manager;
    private MixedOperation client;

    public InfomerEventSource(Class<R> resourceClass, GroupVersionKind gvk, KubernetesClient client) {
        super(resourceClass);
        this.client = this.getMixedOperation(client, gvk, resourceClass);
    }

    private MixedOperation getMixedOperation(KubernetesClient client, GroupVersionKind gvk, Class<R> resourceClass) {
        if (gvk != null) {
            return client.genericKubernetesResources(gvk.getGroup() + "/" + gvk.getVersion(), gvk.getKind());
        }
        return client.resources(resourceClass);
    }

    protected void doInitialize() {
    }

    protected void doStart() {
        this.manager = new InformerManager(this.client, this);
        this.manager.start();
    }

    protected void doStop() {
        this.manager.stop();
    }

    public void onAdd(R resource) {
        this.getHandler().handleEvent(new Event(ResourceID.fromResource(resource)));
    }

    public void onUpdate(R olsResource, R newResource) {
        this.getHandler().handleEvent(new Event(ResourceID.fromResource(newResource)));
    }

    public void onDelete(R resource, boolean deletedFinalStateUnknown) {
        this.getHandler().handleEvent(new Event(ResourceID.fromResource(resource)));
    }
}

