/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.kubernetes.watch.source.event.source.informer;

import cn.sliew.carp.module.kubernetes.watch.source.event.source.informer.InformerWrapper;
import cn.sliew.milky.common.lifecycle.AbstractLifeCycle;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import io.fabric8.kubernetes.client.informers.SharedIndexInformer;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InformerManager<T extends HasMetadata>
extends AbstractLifeCycle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InformerManager.class);
    private final Map<String, InformerWrapper<T>> cache = new ConcurrentHashMap<String, InformerWrapper<T>>();
    private final MixedOperation<T, KubernetesResourceList<T>, Resource<T>> client;
    private final ResourceEventHandler<T> eventHandler;

    InformerManager(MixedOperation<T, KubernetesResourceList<T>, Resource<T>> client, ResourceEventHandler<T> eventHandler) {
        this.client = client;
        this.eventHandler = eventHandler;
    }

    protected void doInitialize() {
    }

    protected void doStart() {
    }

    protected void doStop() {
        this.cache.forEach((ns, source) -> {
            try {
                log.debug("Stopping informer for namespace: {} -> {}", ns, (Object)source);
                source.stop();
            }
            catch (Exception e) {
                log.warn("Error stopping informer for namespace: {} -> {}", new Object[]{ns, source, e});
            }
        });
        this.cache.clear();
    }

    public InformerWrapper<T> getOrCreateEventSource(String namespace) {
        InformerWrapper<T> source = this.cache.get(namespace);
        if (source == null) {
            source = this.createEventSourceForNamespace(namespace);
        }
        return source;
    }

    private InformerWrapper<T> createEventSourceForNamespace(String namespace) {
        LabelSelectorBuilder builder = new LabelSelectorBuilder();
        builder.addToMatchLabels(Collections.emptyMap());
        FilterWatchListDeletable selector = (FilterWatchListDeletable)((NonNamespaceOperation)this.client.inNamespace(namespace)).withLabelSelector(builder.build());
        return this.createEventSource(selector, namespace);
    }

    private InformerWrapper<T> createEventSource(FilterWatchListDeletable<T, KubernetesResourceList<T>, Resource<T>> selectorClient, String namespace) {
        SharedIndexInformer informer = selectorClient.runnableInformer(0L);
        InformerWrapper source = new InformerWrapper(informer, namespace);
        source.addEventHandler(this.eventHandler);
        source.initialize();
        source.start();
        this.cache.put(namespace, source);
        return source;
    }
}

