/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.kubernetes.watch.source.event.source.poll;

import cn.sliew.carp.module.kubernetes.watch.source.event.Event;
import cn.sliew.carp.module.kubernetes.watch.source.event.ResourceID;
import cn.sliew.carp.module.kubernetes.watch.source.event.source.AbstractResourceEventSource;
import cn.sliew.carp.module.kubernetes.watch.source.event.source.ResourceEventAware;
import cn.sliew.milky.common.timewheel.HashedWheelTimer;
import cn.sliew.milky.common.timewheel.Timeout;
import cn.sliew.milky.common.timewheel.TimerTask;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class PerPollEventSource<R, P extends HasMetadata>
extends AbstractResourceEventSource<R, P>
implements ResourceEventAware<P> {
    private HashedWheelTimer timer;
    private Map<ResourceID, Timeout> tasks = new ConcurrentHashMap<ResourceID, Timeout>();
    private Duration period;

    public PerPollEventSource(Class<R> resourceClass, Duration period) {
        super(resourceClass);
        this.period = period;
    }

    protected void doInitialize() {
        this.timer = new HashedWheelTimer();
    }

    protected void doStart() {
        this.timer.start();
    }

    protected void doStop() {
        this.timer.stop();
    }

    @Override
    public void onResourceCreated(P resource) {
        this.checkAndRegister(resource);
    }

    @Override
    public void onResourceUpdated(P newResource, P oldResource) {
        this.checkAndRegister(newResource);
    }

    @Override
    public void onResourceDeleted(P resource) {
        this.cancel(ResourceID.fromResource(resource));
    }

    private void checkAndRegister(P resource) {
        ResourceID resourceID = ResourceID.fromResource(resource);
        if (!this.tasks.containsKey(resourceID)) {
            this.schedule(resource, this.period);
        }
    }

    public void schedule(P resource, Duration delay) {
        ResourceID resourceID = ResourceID.fromResource(resource);
        if (this.tasks.containsKey(resourceID)) {
            this.cancel(resourceID);
        }
        EventProducerTask task = new EventProducerTask(resourceID);
        Timeout timeout = this.timer.newTimeout((TimerTask)task, delay.toMillis(), TimeUnit.MILLISECONDS);
        this.tasks.put(resourceID, timeout);
    }

    public void cancel(ResourceID resourceID) {
        Timeout taskTimeout = this.tasks.remove(resourceID);
        if (taskTimeout != null && !taskTimeout.isCancelled()) {
            taskTimeout.cancel();
        }
    }

    private class EventProducerTask
    implements TimerTask {
        private final ResourceID resourceID;

        public EventProducerTask(ResourceID resourceID) {
            this.resourceID = resourceID;
        }

        public void run(Timeout timeout) throws Exception {
            PerPollEventSource.this.getHandler().handleEvent(new Event(this.resourceID));
            timeout.task().run(timeout);
        }
    }
}

