/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.module.kubernetes.watch.source.watch.shared;

import cn.sliew.carp.module.kubernetes.watch.source.watch.WatchCallbackHandler;
import cn.sliew.carp.module.kubernetes.watch.source.watch.shared.KubernetesSharedWatcher;
import cn.sliew.milky.common.check.Ensures;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.client.NamespacedKubernetesClient;
import io.fabric8.kubernetes.client.dsl.Informable;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import io.fabric8.kubernetes.client.informers.SharedIndexInformer;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KubernetesSharedInformer<T extends HasMetadata>
implements KubernetesSharedWatcher<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KubernetesSharedInformer.class);
    private final NamespacedKubernetesClient client;
    private final SharedIndexInformer<T> sharedIndexInformer;
    private final ExecutorService informerExecutor;
    private final AggregatedEventHandler aggregatedEventHandler;

    public KubernetesSharedInformer(NamespacedKubernetesClient client, Informable<T> informable) {
        this.client = client;
        this.informerExecutor = Executors.newSingleThreadExecutor();
        this.aggregatedEventHandler = new AggregatedEventHandler(this.informerExecutor);
        this.sharedIndexInformer = informable.inform((ResourceEventHandler)this.aggregatedEventHandler, Duration.ofMillis(100L).toMillis());
    }

    @Override
    public KubernetesSharedWatcher.Watch watch(String name, WatchCallbackHandler<T> handler, Executor executor) {
        return this.aggregatedEventHandler.watch(name, new WatchCallback<T>(handler, executor));
    }

    @Override
    public void close() {
        this.sharedIndexInformer.stop();
        this.informerExecutor.shutdown();
    }

    private String getResourceKey(String name) {
        return this.client.getNamespace() + "/" + name;
    }

    private class AggregatedEventHandler
    implements ResourceEventHandler<T> {
        private final Map<String, EventHandler> handlers = new HashMap<String, EventHandler>();
        private final ExecutorService executorService;

        private AggregatedEventHandler(ExecutorService executorService) {
            this.executorService = executorService;
        }

        public void onAdd(T obj) {
            this.executorService.execute(() -> this.findHandler(obj).ifPresent(EventHandler::handleResourceEvent));
        }

        public void onUpdate(T oldObj, T newObj) {
            this.executorService.execute(() -> this.findHandler(newObj).ifPresent(EventHandler::handleResourceEvent));
        }

        public void onDelete(T obj, boolean deletedFinalStateUnknown) {
            this.executorService.execute(() -> this.findHandler(obj).ifPresent(EventHandler::handleResourceEvent));
        }

        private KubernetesSharedWatcher.Watch watch(String name, WatchCallback<T> watch) {
            String resourceKey = KubernetesSharedInformer.this.getResourceKey(name);
            String watchId = UUID.randomUUID().toString();
            CompletableFuture closeFuture = new CompletableFuture();
            this.executorService.execute(() -> {
                EventHandler eventHandler = this.handlers.computeIfAbsent(resourceKey, key -> new EventHandler(resourceKey));
                eventHandler.addWatch(watchId, watch);
            });
            closeFuture.whenCompleteAsync((ignored, error) -> {
                boolean removeHandler;
                if (error != null) {
                    log.error("Unhandled error while closing watcher.", error);
                }
                if (removeHandler = this.handlers.get(resourceKey).removeWatch(watchId)) {
                    this.handlers.remove(resourceKey);
                }
            }, (Executor)this.executorService);
            return () -> closeFuture.complete(null);
        }

        private Optional<EventHandler> findHandler(T obj) {
            String resourceKey = KubernetesSharedInformer.this.getResourceKey(obj.getMetadata().getName());
            return Optional.ofNullable(this.handlers.get(resourceKey));
        }
    }

    private static final class WatchCallback<T> {
        private final Object callbackLock = new Object();
        private final BlockingQueue<Consumer<WatchCallbackHandler<T>>> callbackQueue = new LinkedBlockingQueue<Consumer<WatchCallbackHandler<T>>>();
        private final WatchCallbackHandler<T> handler;
        private final Executor executor;

        private WatchCallback(WatchCallbackHandler<T> handler, @Nullable Executor executor) {
            this.handler = handler;
            this.executor = executor;
        }

        private void run(Consumer<WatchCallbackHandler<T>> handlerConsumer) {
            if (this.executor == null) {
                handlerConsumer.accept(this.handler);
                return;
            }
            Ensures.checkState((boolean)this.callbackQueue.add(handlerConsumer), () -> "Unable to put callback into a queue.");
            this.executor.execute(() -> {
                Object object = this.callbackLock;
                synchronized (object) {
                    ((Consumer)Ensures.checkNotNull((Object)((Consumer)this.callbackQueue.poll()), () -> "Callback queue is empty")).accept(this.handler);
                }
            });
        }
    }

    private class EventHandler {
        private final String resourceKey;
        private final Map<String, WatchCallback<T>> callbacks = new HashMap();
        private T resource;

        private EventHandler(String resourceKey) {
            this.resourceKey = resourceKey;
            this.resource = (HasMetadata)KubernetesSharedInformer.this.sharedIndexInformer.getIndexer().getByKey(resourceKey);
        }

        private void addWatch(String id, WatchCallback<T> callback) {
            log.info("Starting to watch for {}, watching id:{}", (Object)this.resourceKey, (Object)id);
            this.callbacks.put(id, callback);
            if (this.resource != null) {
                List resources = Collections.singletonList(this.resource);
                callback.run(h -> h.onAdded(resources));
            }
        }

        private boolean removeWatch(String id) {
            this.callbacks.remove(id);
            log.info("Stopped to watch for {}, watching id:{}", (Object)this.resourceKey, (Object)id);
            return this.callbacks.isEmpty();
        }

        private void handleResourceEvent() {
            HasMetadata newResource = (HasMetadata)KubernetesSharedInformer.this.sharedIndexInformer.getIndexer().getByKey(this.resourceKey);
            Object oldResource = this.resource;
            if (newResource == null) {
                if (oldResource != null) {
                    this.onDeleted(oldResource);
                }
            } else if (oldResource == null) {
                this.onAdded(newResource);
            } else if (!oldResource.getMetadata().getResourceVersion().equals(newResource.getMetadata().getResourceVersion())) {
                this.onModified(newResource);
            }
            this.resource = newResource;
        }

        private void onAdded(T obj) {
            this.callbacks.forEach((id, callback) -> callback.run(h -> h.onAdded(Collections.singletonList(obj))));
        }

        private void onModified(T obj) {
            this.callbacks.forEach((id, callback) -> callback.run(h -> h.onModified(Collections.singletonList(obj))));
        }

        private void onDeleted(T obj) {
            this.callbacks.forEach((id, callback) -> callback.run(h -> h.onDeleted(Collections.singletonList(obj))));
        }
    }
}

