/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.jdbc.testkit.internal;

import com.typesafe.config.Config;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.pekko.Done;
import org.apache.pekko.Done$;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.dispatch.Dispatchers$;
import org.apache.pekko.dispatch.MessageDispatcher;
import org.apache.pekko.persistence.jdbc.db.SlickDatabase;
import org.apache.pekko.persistence.jdbc.db.SlickExtension$;
import org.apache.pekko.persistence.jdbc.db.SlickExtensionImpl;
import org.apache.pekko.persistence.jdbc.testkit.internal.H2$;
import org.apache.pekko.persistence.jdbc.testkit.internal.MySQL$;
import org.apache.pekko.persistence.jdbc.testkit.internal.Oracle$;
import org.apache.pekko.persistence.jdbc.testkit.internal.Postgres$;
import org.apache.pekko.persistence.jdbc.testkit.internal.SchemaType;
import org.apache.pekko.persistence.jdbc.testkit.internal.SqlServer$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import slick.jdbc.H2Profile$;
import slick.jdbc.JdbcBackend;
import slick.jdbc.JdbcProfile;
import slick.jdbc.MySQLProfile$;
import slick.jdbc.OracleProfile$;
import slick.jdbc.PostgresProfile$;
import slick.jdbc.SQLServerProfile$;

@InternalApi
public final class SchemaUtilsImpl$ {
    public static SchemaUtilsImpl$ MODULE$;

    static {
        new SchemaUtilsImpl$();
    }

    public boolean legacy(String configKey, Config config) {
        String string = config.getConfig(configKey).getString("dao");
        String string2 = "org.apache.pekko.persistence.jdbc.journal.dao.DefaultJournalDao";
        return string == null || !string.equals(string2);
    }

    /*
     * WARNING - void declaration
     */
    @InternalApi
    public Future<Done> dropIfExists(String configKey, Logger logger, ClassicActorSystemProvider actorSystem) {
        void var7_7;
        void var6_6;
        SlickDatabase slickDb = this.loadSlickDatabase(configKey, actorSystem);
        Tuple2<String, String> tuple2 = this.dropScriptFor(this.slickProfileToSchemaType(slickDb.profile()), this.legacy(configKey, actorSystem.classicSystem().settings().config()));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String fileToLoad = (String)tuple2._1();
        String separator = (String)tuple2._2();
        void fileToLoad2 = var6_6;
        void separator2 = var7_7;
        MessageDispatcher blockingEC = actorSystem.classicSystem().dispatchers().lookup(Dispatchers$.MODULE$.DefaultBlockingDispatcherId());
        return Future$.MODULE$.apply(() -> SchemaUtilsImpl$.$anonfun$dropIfExists$1((String)fileToLoad2, (String)separator2, logger, slickDb), (ExecutionContext)blockingEC);
    }

    /*
     * WARNING - void declaration
     */
    @InternalApi
    public Future<Done> createIfNotExists(String configKey, Logger logger, ClassicActorSystemProvider actorSystem) {
        void var7_7;
        void var6_6;
        SlickDatabase slickDb = this.loadSlickDatabase(configKey, actorSystem);
        Tuple2<String, String> tuple2 = this.createScriptFor(this.slickProfileToSchemaType(slickDb.profile()), this.legacy(configKey, actorSystem.classicSystem().settings().config()));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String fileToLoad = (String)tuple2._1();
        String separator = (String)tuple2._2();
        void fileToLoad2 = var6_6;
        void separator2 = var7_7;
        MessageDispatcher blockingEC = actorSystem.classicSystem().dispatchers().lookup(Dispatchers$.MODULE$.DefaultBlockingDispatcherId());
        return Future$.MODULE$.apply(() -> SchemaUtilsImpl$.$anonfun$createIfNotExists$1((String)fileToLoad2, (String)separator2, logger, slickDb), (ExecutionContext)blockingEC);
    }

    @InternalApi
    public Future<Done> applyScript(String script, String separator, String configKey, Logger logger, ClassicActorSystemProvider actorSystem) {
        MessageDispatcher blockingEC = actorSystem.classicSystem().dispatchers().lookup(Dispatchers$.MODULE$.DefaultBlockingDispatcherId());
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MODULE$.applyScriptWithSlick(script, separator, logger, MODULE$.loadSlickDatabase(configKey, actorSystem).database()), (ExecutionContext)blockingEC);
    }

    /*
     * WARNING - void declaration
     */
    @InternalApi
    public Done dropWithSlick(SchemaType schemaType, Logger logger, JdbcBackend.JdbcDatabaseDef db, boolean legacy) {
        void var7_7;
        void var6_6;
        Tuple2<String, String> tuple2 = this.dropScriptFor(schemaType, legacy);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String fileToLoad = (String)tuple2._1();
        String separator = (String)tuple2._2();
        void fileToLoad2 = var6_6;
        void separator2 = var7_7;
        return this.applyScriptWithSlick(this.fromClasspathAsString((String)fileToLoad2), (String)separator2, logger, db);
    }

    /*
     * WARNING - void declaration
     */
    @InternalApi
    public Done createWithSlick(SchemaType schemaType, Logger logger, JdbcBackend.JdbcDatabaseDef db, boolean legacy) {
        void var7_7;
        void var6_6;
        Tuple2<String, String> tuple2 = this.createScriptFor(schemaType, legacy);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        String fileToLoad = (String)tuple2._1();
        String separator = (String)tuple2._2();
        void fileToLoad2 = var6_6;
        void separator2 = var7_7;
        return this.applyScriptWithSlick(this.fromClasspathAsString((String)fileToLoad2), (String)separator2, logger, db);
    }

    private Done applyScriptWithSlick(String script, String separator, Logger logger, JdbcBackend.JdbcDatabaseDef database) {
        Function1 & Serializable & scala.Serializable withStatement$1_f = (Function1 & Serializable & scala.Serializable)stmt -> {
            SchemaUtilsImpl$.$anonfun$applyScriptWithSlick$1(script, separator, logger, stmt);
            return BoxedUnit.UNIT;
        };
        try (JdbcBackend.JdbcSessionDef withStatement$1_session = database.createSession();){
            withStatement$1_session.withStatement(withStatement$1_session.withStatement$default$1(), withStatement$1_session.withStatement$default$2(), withStatement$1_session.withStatement$default$3(), (Function1)withStatement$1_f);
        }
        return Done$.MODULE$;
    }

    private Tuple2<String, String> dropScriptFor(SchemaType schemaType, boolean legacy) {
        String suffix;
        String string = suffix = legacy ? "-legacy" : "";
        if (Postgres$.MODULE$.equals(schemaType)) {
            return new Tuple2((Object)new StringBuilder(40).append("schema/postgres/postgres-drop-schema").append(suffix).append(".sql").toString(), (Object)";");
        }
        if (MySQL$.MODULE$.equals(schemaType)) {
            return new Tuple2((Object)new StringBuilder(34).append("schema/mysql/mysql-drop-schema").append(suffix).append(".sql").toString(), (Object)";");
        }
        if (Oracle$.MODULE$.equals(schemaType)) {
            return new Tuple2((Object)new StringBuilder(36).append("schema/oracle/oracle-drop-schema").append(suffix).append(".sql").toString(), (Object)"/");
        }
        if (SqlServer$.MODULE$.equals(schemaType)) {
            return new Tuple2((Object)new StringBuilder(42).append("schema/sqlserver/sqlserver-drop-schema").append(suffix).append(".sql").toString(), (Object)";");
        }
        if (H2$.MODULE$.equals(schemaType)) {
            return new Tuple2((Object)new StringBuilder(28).append("schema/h2/h2-drop-schema").append(suffix).append(".sql").toString(), (Object)";");
        }
        throw new MatchError((Object)schemaType);
    }

    private Tuple2<String, String> createScriptFor(SchemaType schemaType, boolean legacy) {
        String suffix;
        String string = suffix = legacy ? "-legacy" : "";
        if (Postgres$.MODULE$.equals(schemaType)) {
            return new Tuple2((Object)new StringBuilder(42).append("schema/postgres/postgres-create-schema").append(suffix).append(".sql").toString(), (Object)";");
        }
        if (MySQL$.MODULE$.equals(schemaType)) {
            return new Tuple2((Object)new StringBuilder(36).append("schema/mysql/mysql-create-schema").append(suffix).append(".sql").toString(), (Object)";");
        }
        if (Oracle$.MODULE$.equals(schemaType)) {
            return new Tuple2((Object)new StringBuilder(38).append("schema/oracle/oracle-create-schema").append(suffix).append(".sql").toString(), (Object)"/");
        }
        if (SqlServer$.MODULE$.equals(schemaType)) {
            return new Tuple2((Object)new StringBuilder(44).append("schema/sqlserver/sqlserver-create-schema").append(suffix).append(".sql").toString(), (Object)";");
        }
        if (H2$.MODULE$.equals(schemaType)) {
            return new Tuple2((Object)new StringBuilder(30).append("schema/h2/h2-create-schema").append(suffix).append(".sql").toString(), (Object)";");
        }
        throw new MatchError((Object)schemaType);
    }

    private SchemaType slickProfileToSchemaType(JdbcProfile profile) {
        if (PostgresProfile$.MODULE$.equals(profile)) {
            return Postgres$.MODULE$;
        }
        if (MySQLProfile$.MODULE$.equals(profile)) {
            return MySQL$.MODULE$;
        }
        if (OracleProfile$.MODULE$.equals(profile)) {
            return Oracle$.MODULE$;
        }
        if (SQLServerProfile$.MODULE$.equals(profile)) {
            return SqlServer$.MODULE$;
        }
        if (H2Profile$.MODULE$.equals(profile)) {
            return H2$.MODULE$;
        }
        throw new IllegalArgumentException(new StringBuilder(28).append("Invalid profile ").append(profile).append(" encountered").toString());
    }

    @InternalApi
    public String fromClasspathAsString(String fileName) {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(fileName);
        return Source$.MODULE$.fromInputStream(is, Codec$.MODULE$.fallbackSystemCodec()).mkString();
    }

    private SlickDatabase loadSlickDatabase(String configKey, ClassicActorSystemProvider actorSystem) {
        Config journalConfig = actorSystem.classicSystem().settings().config().getConfig(configKey);
        return ((SlickExtensionImpl)SlickExtension$.MODULE$.apply(actorSystem)).database(journalConfig);
    }

    public static final /* synthetic */ Done $anonfun$dropIfExists$1(String fileToLoad$1, String separator$1, Logger logger$1, SlickDatabase slickDb$1) {
        return MODULE$.applyScriptWithSlick(MODULE$.fromClasspathAsString(fileToLoad$1), separator$1, logger$1, slickDb$1.database());
    }

    public static final /* synthetic */ Done $anonfun$createIfNotExists$1(String fileToLoad$2, String separator$2, Logger logger$2, SlickDatabase slickDb$2) {
        return MODULE$.applyScriptWithSlick(MODULE$.fromClasspathAsString(fileToLoad$2), separator$2, logger$2, slickDb$2.database());
    }

    private static final Done withStatement$1(Function1 f, JdbcBackend.JdbcDatabaseDef database$1) {
        try (JdbcBackend.JdbcSessionDef session = database$1.createSession();){
            session.withStatement(session.withStatement$default$1(), session.withStatement$default$2(), session.withStatement$default$3(), f);
        }
        return Done$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$applyScriptWithSlick$3(String line) {
        return new StringOps(Predef$.MODULE$.augmentString(line)).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$applyScriptWithSlick$1(String script$2, String separator$4, Logger logger$4, Statement stmt) {
        String[] lines = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])script$2.split(separator$4))).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])lines)).withFilter((Function1 & Serializable & scala.Serializable)line -> BoxesRunTime.boxToBoolean((boolean)SchemaUtilsImpl$.$anonfun$applyScriptWithSlick$3(line))).map((Function1 & Serializable & scala.Serializable)line -> {
            logger$4.debug(new StringBuilder(14).append("applying DDL: ").append((String)line).toString());
            try {
                return BoxesRunTime.boxToInteger((int)stmt.executeUpdate((String)line));
            }
            catch (SQLException t) {
                logger$4.debug("Exception while applying SQL script", (Throwable)t);
                return BoxedUnit.UNIT;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.AnyVal()));
    }

    private SchemaUtilsImpl$() {
        MODULE$ = this;
    }
}

