/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.expression;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.parser.ASTNodeAccessImpl;

public class JdbcParameter
extends ASTNodeAccessImpl
implements Expression {
    private String parameterCharacter = "?";
    private Integer index;
    private boolean useFixedIndex = false;

    public JdbcParameter() {
    }

    public JdbcParameter(Integer index, boolean useFixedIndex, String parameterCharacter) {
        this.index = index;
        this.useFixedIndex = useFixedIndex;
        this.parameterCharacter = parameterCharacter;
        Pattern pattern = Pattern.compile("(\\$)(\\d*)");
        Matcher matcher = pattern.matcher(parameterCharacter);
        if (matcher.find() && matcher.groupCount() == 2) {
            this.useFixedIndex = true;
            this.parameterCharacter = matcher.group(1);
            this.index = Integer.valueOf(matcher.group(2));
        }
    }

    public String getParameterCharacter() {
        return this.parameterCharacter;
    }

    public JdbcParameter setParameterCharacter(String parameterCharacter) {
        this.parameterCharacter = parameterCharacter;
        return this;
    }

    public Integer getIndex() {
        return this.index;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public boolean isUseFixedIndex() {
        return this.useFixedIndex;
    }

    public void setUseFixedIndex(boolean useFixedIndex) {
        this.useFixedIndex = useFixedIndex;
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public String toString() {
        return this.useFixedIndex ? this.parameterCharacter + this.index : this.parameterCharacter;
    }

    public JdbcParameter withIndex(Integer index) {
        this.setIndex(index);
        return this;
    }

    public JdbcParameter withUseFixedIndex(boolean useFixedIndex) {
        this.setUseFixedIndex(useFixedIndex);
        return this;
    }
}

