/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.expression;

import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.parser.ASTNodeAccessImpl;

public class TrimFunction
extends ASTNodeAccessImpl
implements Expression {
    private TrimSpecification trimSpecification;
    private Expression expression;
    private Expression fromExpression;
    private boolean isUsingFromKeyword;

    public TrimFunction(TrimSpecification trimSpecification, Expression expression, Expression fromExpression, boolean isUsingFromKeyword) {
        this.trimSpecification = trimSpecification;
        this.expression = expression;
        this.fromExpression = fromExpression;
        this.isUsingFromKeyword = isUsingFromKeyword;
    }

    public TrimFunction() {
        this(null, null, null, false);
    }

    public TrimSpecification getTrimSpecification() {
        return this.trimSpecification;
    }

    public void setTrimSpecification(TrimSpecification trimSpecification) {
        this.trimSpecification = trimSpecification;
    }

    public TrimFunction withTrimSpecification(TrimSpecification trimSpecification) {
        this.setTrimSpecification(trimSpecification);
        return this;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public TrimFunction withExpression(Expression expression) {
        this.setExpression(expression);
        return this;
    }

    public Expression getFromExpression() {
        return this.fromExpression;
    }

    public void setFromExpression(Expression fromExpression) {
        if (fromExpression == null) {
            this.setUsingFromKeyword(false);
        }
        this.fromExpression = fromExpression;
    }

    public TrimFunction withFromExpression(Expression fromExpression) {
        this.setFromExpression(fromExpression);
        return this;
    }

    public boolean isUsingFromKeyword() {
        return this.isUsingFromKeyword;
    }

    public void setUsingFromKeyword(boolean useFromKeyword) {
        this.isUsingFromKeyword = useFromKeyword;
    }

    public TrimFunction withUsingFromKeyword(boolean useFromKeyword) {
        this.setUsingFromKeyword(useFromKeyword);
        return this;
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    @Override
    public StringBuilder appendTo(StringBuilder builder) {
        builder.append("Trim(");
        if (this.trimSpecification != null) {
            builder.append(" ").append(this.trimSpecification.name());
        }
        if (this.expression != null) {
            builder.append(" ").append(this.expression);
        }
        if (this.fromExpression != null) {
            builder.append(this.isUsingFromKeyword ? " FROM " : ", ").append(this.fromExpression);
        }
        builder.append(" )");
        return builder;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    public static enum TrimSpecification {
        LEADING,
        TRAILING,
        BOTH;

    }
}

