/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.refresh;

import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.statement.refresh.RefreshMode;

public class RefreshMaterializedViewStatement
implements Statement {
    private Table view;
    private RefreshMode refreshMode;
    private boolean concurrently = false;

    public RefreshMaterializedViewStatement() {
    }

    public RefreshMaterializedViewStatement(Table view, boolean concurrently, RefreshMode refreshMode) {
        this.refreshMode = refreshMode;
        this.concurrently = concurrently;
        this.view = view;
    }

    public Table getView() {
        return this.view;
    }

    public void setView(Table view) {
        this.view = view;
    }

    public RefreshMode getRefreshMode() {
        return this.refreshMode;
    }

    public void setRefreshMode(RefreshMode refreshMode) {
        this.refreshMode = refreshMode;
    }

    public boolean isConcurrently() {
        return this.concurrently;
    }

    public void setConcurrently(boolean concurrently) {
        this.concurrently = concurrently;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("REFRESH MATERIALIZED VIEW ");
        if (this.refreshMode == null) {
            if (this.concurrently) {
                builder.append("CONCURRENTLY ");
            }
            builder.append(this.view);
            return builder.toString();
        }
        switch (this.refreshMode) {
            case WITH_DATA: {
                if (this.concurrently) {
                    builder.append("CONCURRENTLY ");
                }
                builder.append(this.view);
                builder.append(" WITH DATA");
                break;
            }
            case WITH_NO_DATA: {
                builder.append(this.view);
                if (this.concurrently) break;
                builder.append(" WITH NO DATA");
            }
        }
        return builder.toString();
    }

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public RefreshMaterializedViewStatement withTableName(Table view) {
        this.setView(view);
        return this;
    }

    public RefreshMaterializedViewStatement withConcurrently(boolean concurrently) {
        this.setConcurrently(concurrently);
        return this;
    }
}

