/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.impl.engine.client;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayDeque;
import org.apache.pekko.Done;
import org.apache.pekko.Done$;
import org.apache.pekko.actor.ActorRefFactory;
import org.apache.pekko.annotation.InternalStableApi;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.http.impl.engine.client.PoolFlow;
import org.apache.pekko.http.impl.engine.client.PoolId;
import org.apache.pekko.http.impl.engine.client.PoolInterface$;
import org.apache.pekko.http.impl.engine.client.PoolInterface$ShutdownReason$IdleTimeout$;
import org.apache.pekko.http.impl.engine.client.PoolInterface$ShutdownReason$ShutdownRequested$;
import org.apache.pekko.http.impl.engine.client.PoolMaster;
import org.apache.pekko.http.impl.settings.HostConnectionPoolSetup;
import org.apache.pekko.http.impl.util.StreamUtils$;
import org.apache.pekko.http.impl.util.StreamUtils$CaptureTerminationOp$;
import org.apache.pekko.http.impl.util.package$;
import org.apache.pekko.http.impl.util.package$RichHttpRequest$;
import org.apache.pekko.http.javadsl.ConnectionContext;
import org.apache.pekko.http.scaladsl.model.HttpHeader;
import org.apache.pekko.http.scaladsl.model.HttpRequest;
import org.apache.pekko.http.scaladsl.model.HttpResponse;
import org.apache.pekko.http.scaladsl.model.HttpResponse$;
import org.apache.pekko.http.scaladsl.model.OptHttpResponse$;
import org.apache.pekko.http.scaladsl.model.ResponseEntity;
import org.apache.pekko.http.scaladsl.model.Uri$;
import org.apache.pekko.http.scaladsl.model.headers.Host;
import org.apache.pekko.http.scaladsl.model.headers.Host$;
import org.apache.pekko.macros.LogHelper;
import org.apache.pekko.macros.LogHelperMacro;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.BufferOverflowException;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Inlet$;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.stage.AsyncCallback;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.GraphStageWithMaterializedValue;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.stream.stage.OutHandler;
import org.apache.pekko.stream.stage.TimerGraphStageLogic;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0011-b\u0001\u00034h!\u0003\r\n!\\;\t\u000bq\u0004a\u0011\u0001@\t\u000f\u00055\u0002A\"\u0001\u00020!91\u0011\u001c\u0001\u0007\u0002\u0011%r\u0001CA O\"\u0005Q.!\u0011\u0007\u000f\u0019<\u0007\u0012A7\u0002D!9\u0011QI\u0003\u0005\u0002\u0005\u001dcACA%\u000bA\u0005\u0019\u0013E7\u0002L\u001dA\u0011Q\\\u0003\t\u00025\f)F\u0002\u0005\u0002J\u0015A\t!\\A)\u0011\u001d\t)%\u0003C\u0001\u0003':q!!\u0017\n\u0011\u0003\u000bYFB\u0004\u0002`%A\t)!\u0019\t\u000f\u0005\u0015C\u0002\"\u0001\u0002r!I\u00111\u000f\u0007\u0002\u0002\u0013\u0005\u0013Q\u000f\u0005\n\u0003\u000fc\u0011\u0011!C\u0001\u0003\u0013C\u0011\"!%\r\u0003\u0003%\t!a%\t\u0013\u0005}E\"!A\u0005B\u0005\u0005\u0006\"CAX\u0019\u0005\u0005I\u0011AAY\u0011%\tY\fDA\u0001\n\u0003\ni\fC\u0005\u0002@2\t\t\u0011\"\u0011\u0002B\"I\u00111\u0019\u0007\u0002\u0002\u0013%\u0011QY\u0004\b\u0003\u001bL\u0001\u0012QAh\r\u001d\ty%\u0003EA\u0003#Dq!!\u0012\u0018\t\u0003\t\u0019\u000eC\u0005\u0002t]\t\t\u0011\"\u0011\u0002v!I\u0011qQ\f\u0002\u0002\u0013\u0005\u0011\u0011\u0012\u0005\n\u0003#;\u0012\u0011!C\u0001\u0003+D\u0011\"a(\u0018\u0003\u0003%\t%!)\t\u0013\u0005=v#!A\u0005\u0002\u0005e\u0007\"CA^/\u0005\u0005I\u0011IA_\u0011%\tylFA\u0001\n\u0003\n\t\rC\u0005\u0002D^\t\t\u0011\"\u0003\u0002F\"9\u0011q\\\u0003\u0005\u0002\u0005\u0005\b\"CAg\u000b\t\u0007I\u0011BA;\u0011!\u0011Y\"\u0002Q\u0001\n\u0005]dA\u0002B\u000f\u000b\u0001\u0011y\u0002\u0003\u0006\u0002z\u0012\u0012\t\u0011)A\u0005\u0003wD!Ba\u0005%\u0005\u0003\u0005\u000b\u0011\u0002B\u000b\u0011)\u0011i\u0006\nB\u0001B\u0003%\u00111\u0012\u0005\u000b\u0005?\"#\u0011!Q\u0001\n\t\u0005\u0004bBA#I\u0011\u0005!Q\u000e\u0005\n\u0005s\"#\u0019!C\u0005\u0005wB\u0001Ba!%A\u0003%!Q\u0010\u0005\n\u0005\u000b##\u0019!C\u0005\u0005\u000fC\u0001Ba$%A\u0003%!\u0011\u0012\u0005\b\u0005##C\u0011\tBJ\u0011\u001d\u0011)\n\nC!\u0005/CqA!&%\t\u0003\u0012yK\u0002\u0004\u00038\u0016!!\u0011\u0018\u0005\u000b\u0003s\f$\u0011!Q\u0001\n\u0005m\bB\u0003BIc\t\u0005\t\u0015!\u0003\u0003.!Q!1C\u0019\u0003\u0002\u0003\u0006IA!\u0006\t\u0015\te\u0014G!A!\u0002\u0013\u0011i\b\u0003\u0006\u0003\u0006F\u0012\t\u0011)A\u0005\u0005\u0013C!B!\u00182\u0005\u0003\u0005\u000b\u0011BAF\u0011)\u0011y&\rBC\u0002\u0013\u0005!\u0011\u001c\u0005\u000b\u00057\f$\u0011!Q\u0001\n\t\u0005\u0004B\u0003Boc\t\u0005\t\u0015a\u0003\u0003`\"9\u0011QI\u0019\u0005\u0002\t\u0015\b\u0002\u0003B~c\u0001\u0006IA!@\t\u0013\r\r\u0011G1A\u0005\u0002\r\u0015\u0001\u0002CB\nc\u0001\u0006Iaa\u0002\t\u0013\rU\u0011G1A\u0005\u0002\r]\u0001\u0002CB\u0013c\u0001\u0006Ia!\u0007\t\u0013\r\u001d\u0012G1A\u0005\u0002\r%\u0002\u0002CB\u0017c\u0001\u0006Iaa\u000b\t\u000f\r=\u0012\u0007\"\u0001\u00042!I11G\u0019A\u0002\u0013\u00051Q\u0007\u0005\n\u0007{\t\u0004\u0019!C\u0001\u0007\u007fA\u0001ba\u00112A\u0003&1q\u0007\u0005\n\u0007\u000b\n\u0004\u0019!C\u0001\u0003\u0013C\u0011ba\u00122\u0001\u0004%\ta!\u0013\t\u0011\r5\u0013\u0007)Q\u0005\u0003\u0017C\u0011ba\u00142\u0005\u0004%\ta!\u0015\t\u0011\r}\u0013\u0007)A\u0005\u0007'Bqa!\u00192\t\u0003\u001a\u0019\u0007C\u0004\u0004fE\"\tfa\u001a\t\u000f\r5\u0014\u0007\"\u0011\u0004d!91qN\u0019\u0005B\r\r\u0004\"CB9c\t\u0007I\u0011AB:\u0011!\u0019\u0019)\rQ\u0001\n\rU\u0004\"CBCc\t\u0007I\u0011ABD\u0011!\u0019i)\rQ\u0001\n\r%\u0005\"CBHc\t\u0007I\u0011ABI\u0011!\u0019)*\rQ\u0001\n\rM\u0005bBBLc\u0011\u000511\r\u0005\b\u00073\u000bD\u0011ABN\u0011\u001d\u0019\t+\rC\u0001\u0007GBqaa)2\t\u0003\u0019\u0019\u0007C\u0004\u0004&F\"\ta!\r\t\u000f\r\u001d\u0016\u0007\"\u0011\u0004*\"91qY\u0019\u0005B\r\r\u0004B\u0002?2\t\u0003\u001aI\rC\u0004\u0002.E\"\tea4\t\u000f\re\u0017\u0007\"\u0011\u0004\\\"91Q\\\u0019\u0005\u0002\r}\u0007bBByc\u0011\u000511\u001f\u0005\b\u0007s\fD\u0011AB~\u0011\u001d!y!\rC\u0001\t#A!\u0002b\u0007\u0006\u0005\u0004%\t!\u001cC\u000f\u0011!!)#\u0002Q\u0001\n\u0011}!!\u0004)p_2Le\u000e^3sM\u0006\u001cWM\u0003\u0002iS\u000611\r\\5f]RT!A[6\u0002\r\u0015tw-\u001b8f\u0015\taW.\u0001\u0003j[Bd'B\u00018p\u0003\u0011AG\u000f\u001e9\u000b\u0005A\f\u0018!\u00029fW.|'B\u0001:t\u0003\u0019\t\u0007/Y2iK*\tA/A\u0002pe\u001e\u001c\"\u0001\u0001<\u0011\u0005]TX\"\u0001=\u000b\u0003e\fQa]2bY\u0006L!a\u001f=\u0003\r\u0005s\u0017PU3g\u0003\u001d\u0011X-];fgR\u001c\u0001\u0001F\u0003\u0000\u0003\u000b\t9\u0002E\u0002x\u0003\u0003I1!a\u0001y\u0005\u0011)f.\u001b;\t\rq\f\u0001\u0019AA\u0004!\u0011\tI!a\u0005\u000e\u0005\u0005-!\u0002BA\u0007\u0003\u001f\tQ!\\8eK2T1!!\u0005n\u0003!\u00198-\u00197bINd\u0017\u0002BA\u000b\u0003\u0017\u00111\u0002\u0013;uaJ+\u0017/^3ti\"9\u0011\u0011D\u0001A\u0002\u0005m\u0011a\u0004:fgB|gn]3Qe>l\u0017n]3\u0011\r\u0005u\u00111EA\u0014\u001b\t\tyBC\u0002\u0002\"a\f!bY8oGV\u0014(/\u001a8u\u0013\u0011\t)#a\b\u0003\u000fA\u0013x.\\5tKB!\u0011\u0011BA\u0015\u0013\u0011\tY#a\u0003\u0003\u0019!#H\u000f\u001d*fgB|gn]3\u0002\u0011MDW\u000f\u001e3po:$\"!!\r\u0015\t\u0005MBq\u0005\t\u0007\u0003;\t)$!\u000f\n\t\u0005]\u0012q\u0004\u0002\u0007\rV$XO]3\u0011\u0007\u0005mrAD\u0002\u0002>\u0011i\u0011aZ\u0001\u000e!>|G.\u00138uKJ4\u0017mY3\u0011\u0007\u0005uRa\u0005\u0002\u0006m\u00061A(\u001b8jiz\"\"!!\u0011\u0003\u001dMCW\u000f\u001e3po:\u0014V-Y:p]N\u0011qA^\u0015\u0004\u000f]a!aC%eY\u0016$\u0016.\\3pkR\u001c\"!\u0003<\u0015\u0005\u0005U\u0003cAA,\u00135\tQ!A\tTQV$Hm\\<o%\u0016\fX/Z:uK\u0012\u00042!!\u0018\r\u001b\u0005I!!E*ikR$wn\u001e8SKF,Xm\u001d;fINAAB^A2\u0003K\nY\u0007E\u0002\u0002X\u001d\u00012a^A4\u0013\r\tI\u0007\u001f\u0002\b!J|G-^2u!\r9\u0018QN\u0005\u0004\u0003_B(\u0001D*fe&\fG.\u001b>bE2,GCAA.\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011q\u000f\t\u0005\u0003s\n\u0019)\u0004\u0002\u0002|)!\u0011QPA@\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0005\u0015\u0001\u00026bm\u0006LA!!\"\u0002|\t11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a#\u0011\u0007]\fi)C\u0002\u0002\u0010b\u00141!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!&\u0002\u001cB\u0019q/a&\n\u0007\u0005e\u0005PA\u0002B]fD\u0011\"!(\u0011\u0003\u0003\u0005\r!a#\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\u0019\u000b\u0005\u0004\u0002&\u0006-\u0016QS\u0007\u0003\u0003OS1!!+y\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003[\u000b9K\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAZ\u0003s\u00032a^A[\u0013\r\t9\f\u001f\u0002\b\u0005>|G.Z1o\u0011%\tiJEA\u0001\u0002\u0004\t)*\u0001\u0005iCND7i\u001c3f)\t\tY)\u0001\u0005u_N#(/\u001b8h)\t\t9(A\u0006sK\u0006$'+Z:pYZ,GCAAd!\u0011\tI(!3\n\t\u0005-\u00171\u0010\u0002\u0007\u001f\nTWm\u0019;\u0002\u0017%#G.\u001a+j[\u0016|W\u000f\u001e\t\u0004\u0003;:2\u0003C\fw\u0003G\n)'a\u001b\u0015\u0005\u0005=G\u0003BAK\u0003/D\u0011\"!(\u001c\u0003\u0003\u0005\r!a#\u0015\t\u0005M\u00161\u001c\u0005\n\u0003;k\u0012\u0011!a\u0001\u0003+\u000bab\u00155vi\u0012|wO\u001c*fCN|g.A\u0003baBd\u0017\u0010\u0006\u0005\u0002d\u0006](\u0011\u0001B\t)\u0011\t)/a:\u0011\u0007\u0005u\u0002\u0001C\u0004\u0002j\u0006\u0002\u001d!a;\u0002\u0005\u0019l\u0007\u0003BAw\u0003gl!!a<\u000b\u0007\u0005Ex.\u0001\u0004tiJ,\u0017-\\\u0005\u0005\u0003k\fyO\u0001\u0007NCR,'/[1mSj,'\u000fC\u0004\u0002z\u0006\u0002\r!a?\u0002\rA|w\u000e\\%e!\u0011\ti$!@\n\u0007\u0005}xM\u0001\u0004Q_>d\u0017\n\u001a\u0005\b\u0005\u0007\t\u0003\u0019\u0001B\u0003\u0003\u0019\u0001\u0018M]3oiB!!q\u0001B\u0007\u001b\t\u0011IAC\u0002\u0003\f=\fQ!Y2u_JLAAa\u0004\u0003\n\ty\u0011i\u0019;peJ+gMR1di>\u0014\u0018\u0010C\u0004\u0003\u0014\u0005\u0002\rA!\u0006\u0002\r5\f7\u000f^3s!\u0011\tiDa\u0006\n\u0007\teqM\u0001\u0006Q_>dW*Y:uKJ\fA\"\u00133mKRKW.Z8vi\u0002\u0012!\u0003U8pY&sG/\u001a:gC\u000e,7\u000b^1hKN\u0019AE!\t\u0011\u0011\t\r\"\u0011\u0006B\u0017\u0003Kl!A!\n\u000b\t\t\u001d\u0012q^\u0001\u0006gR\fw-Z\u0005\u0005\u0005W\u0011)CA\u0010He\u0006\u0004\bn\u0015;bO\u0016<\u0016\u000e\u001e5NCR,'/[1mSj,GMV1mk\u0016\u0004\u0002\"!<\u00030\tM\"qK\u0005\u0005\u0005c\tyOA\u0005GY><8\u000b[1qKB!!Q\u0007B)\u001d\u0011\u00119D!\u0014\u000f\t\te\"1\n\b\u0005\u0005w\u0011IE\u0004\u0003\u0003>\t\u001dc\u0002\u0002B \u0005\u000brAA!\u0011\u0003D5\t\u0011/\u0003\u0002qc&\u0011an\\\u0005\u0003Y6L!A[6\n\u0005!L\u0017b\u0001B(O\u0006A\u0001k\\8m\r2|w/\u0003\u0003\u0003T\tU#a\u0004*fgB|gn]3D_:$X\r\u001f;\u000b\u0007\t=s\r\u0005\u0003\u00036\te\u0013\u0002\u0002B.\u0005+\u0012aBU3rk\u0016\u001cHoQ8oi\u0016DH/\u0001\u0006ck\u001a4WM]*ju\u0016\f1\u0001\\8h!\u0011\u0011\u0019G!\u001b\u000e\u0005\t\u0015$b\u0001B4_\u0006)QM^3oi&!!1\u000eB3\u00059aunZ4j]\u001e\fE-\u00199uKJ$\"Ba\u001c\u0003r\tM$Q\u000fB<!\r\t9\u0006\n\u0005\b\u0003sL\u0003\u0019AA~\u0011\u001d\u0011\u0019\"\u000ba\u0001\u0005+AqA!\u0018*\u0001\u0004\tY\tC\u0004\u0003`%\u0002\rA!\u0019\u0002\u0015I,\u0017/^3ti>+H/\u0006\u0002\u0003~A1\u0011Q\u001eB@\u0005/JAA!!\u0002p\n1q*\u001e;mKR\f1B]3rk\u0016\u001cHoT;uA\u0005Q!/Z:q_:\u001cX-\u00138\u0016\u0005\t%\u0005CBAw\u0005\u0017\u0013\u0019$\u0003\u0003\u0003\u000e\u0006=(!B%oY\u0016$\u0018a\u0003:fgB|gn]3J]\u0002\nQa\u001d5ba\u0016,\"A!\f\u0002?\r\u0014X-\u0019;f\u0019><\u0017nY!oI6\u000bG/\u001a:jC2L'0\u001a3WC2,X\r\u0006\u0003\u0003\u001a\n\u0015\u0006cB<\u0003\u001c\n}\u0015Q]\u0005\u0004\u0005;C(A\u0002+va2,'\u0007\u0005\u0003\u0003$\t\u0005\u0016\u0002\u0002BR\u0005K\u0011qb\u0012:ba\"\u001cF/Y4f\u0019><\u0017n\u0019\u0005\b\u0005O{\u0003\u0019\u0001BU\u0003MIg\u000e[3sSR,G-\u0011;ue&\u0014W\u000f^3t!\u0011\tiOa+\n\t\t5\u0016q\u001e\u0002\u000b\u0003R$(/\u001b2vi\u0016\u001cHC\u0002BM\u0005c\u0013\u0019\fC\u0004\u0003(B\u0002\rA!+\t\u000f\tU\u0006\u00071\u0001\u0002l\u0006iq,\\1uKJL\u0017\r\\5{KJ\u0014Q\u0001T8hS\u000e\u001c2\"\rB^\u0003K\u0014\tMa2\u0003NB!!1\u0005B_\u0013\u0011\u0011yL!\n\u0003)QKW.\u001a:He\u0006\u0004\bn\u0015;bO\u0016dunZ5d!\u0011\u0011\u0019Ca1\n\t\t\u0015'Q\u0005\u0002\n\u0013:D\u0015M\u001c3mKJ\u0004BAa\t\u0003J&!!1\u001aB\u0013\u0005)yU\u000f\u001e%b]\u0012dWM\u001d\t\u0005\u0005\u001f\u0014).\u0004\u0002\u0003R*\u0019!1[8\u0002\r5\f7M]8t\u0013\u0011\u00119N!5\u0003\u00131{w\rS3ma\u0016\u0014XC\u0001B1\u0003\u0011awn\u001a\u0011\u0002!\u0015DXmY;uS>t7i\u001c8uKb$\b\u0003BA\u000f\u0005CLAAa9\u0002 \t\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010\u001e\u000b\u0011\u0005O\u0014iOa<\u0003r\nM(Q\u001fB|\u0005s$BA!;\u0003lB\u0019\u0011qK\u0019\t\u000f\tu7\bq\u0001\u0003`\"9\u0011\u0011`\u001eA\u0002\u0005m\bb\u0002BIw\u0001\u0007!Q\u0006\u0005\b\u0005'Y\u0004\u0019\u0001B\u000b\u0011\u001d\u0011Ih\u000fa\u0001\u0005{BqA!\"<\u0001\u0004\u0011I\tC\u0004\u0003^m\u0002\r!a#\t\u000f\t}3\b1\u0001\u0003b\u0005)\u0002k\\8m\u001fZ,'O\u001a7po\u0016C8-\u001a9uS>t\u0007\u0003BAw\u0005\u007fLAa!\u0001\u0002p\n9\")\u001e4gKJ|e/\u001a:gY><X\t_2faRLwN\\\u0001\u0005Q\u000e\u00048/\u0006\u0002\u0004\bA!1\u0011BB\b\u001b\t\u0019YAC\u0002\u0004\u000e-\f\u0001b]3ui&twm]\u0005\u0005\u0007#\u0019YAA\fI_N$8i\u001c8oK\u000e$\u0018n\u001c8Q_>d7+\u001a;va\u0006)\u0001n\u00199tA\u0005Y\u0011\u000e\u001a7f)&lWm\\;u+\t\u0019I\u0002\u0005\u0003\u0004\u001c\r\u0005RBAB\u000f\u0015\u0011\u0019y\"a\b\u0002\u0011\u0011,(/\u0019;j_:LAaa\t\u0004\u001e\tAA)\u001e:bi&|g.\u0001\u0007jI2,G+[7f_V$\b%A\btQV$Hm\\<o!J|W.[:f+\t\u0019Y\u0003\u0005\u0004\u0002\u001e\u0005\r\u00121M\u0001\u0011g\",H\u000fZ8x]B\u0013x.\\5tK\u0002\nAb\u001d5viRLgn\u001a#po:,\"!a-\u0002%MDW\u000f\u001e;j]\u001e$un\u001e8SK\u0006\u001cxN\\\u000b\u0003\u0007o\u0001Ra^B\u001d\u0003GJ1aa\u000fy\u0005\u0019y\u0005\u000f^5p]\u000612\u000f[;ui&tw\rR8x]J+\u0017m]8o?\u0012*\u0017\u000fF\u0002\u0000\u0007\u0003B\u0011\"!(F\u0003\u0003\u0005\raa\u000e\u0002'MDW\u000f\u001e;j]\u001e$un\u001e8SK\u0006\u001cxN\u001c\u0011\u0002%I,W.Y5oS:<'+Z9vKN$X\rZ\u0001\u0017e\u0016l\u0017-\u001b8j]\u001e\u0014V-];fgR,Gm\u0018\u0013fcR\u0019qpa\u0013\t\u0013\u0005u\u0005*!AA\u0002\u0005-\u0015a\u0005:f[\u0006Lg.\u001b8h%\u0016\fX/Z:uK\u0012\u0004\u0013A\u00022vM\u001a,'/\u0006\u0002\u0004TA11QKB.\u0005/j!aa\u0016\u000b\t\re\u0013qP\u0001\u0005kRLG.\u0003\u0003\u0004^\r]#AC!se\u0006LH)Z9vK\u00069!-\u001e4gKJ\u0004\u0013\u0001\u00039sKN#\u0018M\u001d;\u0015\u0003}\fqa\u001c8US6,'\u000fF\u0002\u0000\u0007SBqaa\u001bN\u0001\u0004\t)*\u0001\u0005uS6,'oS3z\u0003\u0019yg\u000eU;tQ\u00061qN\u001c)vY2\f\u0011D]3ta>t7/Z\"p[BdW\r^3e\u0007\u0006dGNY1dWV\u00111Q\u000f\t\u0007\u0005G\u00199ha\u001f\n\t\re$Q\u0005\u0002\u000e\u0003NLhnY\"bY2\u0014\u0017mY6\u0011\t\ru4qP\u0007\u0002_&\u00191\u0011Q8\u0003\t\u0011{g.Z\u0001\u001be\u0016\u001c\bo\u001c8tK\u000e{W\u000e\u001d7fi\u0016$7)\u00197mE\u0006\u001c7\u000eI\u0001\u0010e\u0016\fX/Z:u\u0007\u0006dGNY1dWV\u00111\u0011\u0012\t\u0007\u0005G\u00199ha#\u0011\u000f]\u0014Y*a\u0002\u0002\u001c\u0005\u0001\"/Z9vKN$8)\u00197mE\u0006\u001c7\u000eI\u0001\u0011g\",H\u000fZ8x]\u000e\u000bG\u000e\u001c2bG.,\"aa%\u0011\u000b\t\r2qO@\u0002#MDW\u000f\u001e3po:\u001c\u0015\r\u001c7cC\u000e\\\u0007%\u0001\u000bbMR,'OU3rk\u0016\u001cHOR5oSNDW\rZ\u0001\u0010e\u0016\fX/Z:u'\",H\u000fZ8x]R\u0019qp!(\t\u000f\r}u\u000b1\u0001\u0002d\u00051!/Z1t_:\fad\u001d5vi\u0012|wO\\%g%\u0016\fX/Z:uK\u0012\fe\u000e\u001a)pgNL'\r\\3\u0002\u001dI,7/\u001a;JI2,G+[7fe\u0006\u00012\u000f[8vY\u0012\u001cFo\u001c9P]&#G.Z\u0001\u0012_:,\u0006o\u001d;sK\u0006lg)Y5mkJ,GcA@\u0004,\"91QV.A\u0002\r=\u0016AA3y!\u0011\u0019\tl!1\u000f\t\rM6Q\u0018\b\u0005\u0007k\u001bY,\u0004\u0002\u00048*\u00191\u0011X?\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0018bAB`q\u00069\u0001/Y2lC\u001e,\u0017\u0002BBb\u0007\u000b\u0014\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\r}\u00060\u0001\u0005q_N$8\u000b^8q)\u0015y81ZBg\u0011\u0019aX\f1\u0001\u0002\b!9\u0011\u0011D/A\u0002\u0005mACABi)\u0011\u0019\u0019n!6\u0011\r\u0005u\u0011QGA2\u0011\u001d\u00199N\u0018a\u0002\u0005?\f!!Z2\u0002\u0019]DWM\\*ikR$wn\u001e8\u0016\u0005\rM\u0017AB8o\u0013:LG\u000fF\u0002\u0000\u0007CDq!!?a\u0001\u0004\tY\u0010K\u0002a\u0007K\u0004Baa:\u0004n6\u00111\u0011\u001e\u0006\u0004\u0007W|\u0017AC1o]>$\u0018\r^5p]&!1q^Bu\u0005EIe\u000e^3s]\u0006d7\u000b^1cY\u0016\f\u0005/[\u0001\u000b_:$\u0015n\u001d9bi\u000eDG\u0003BA\u0004\u0007kDa\u0001`1A\u0002\u0005\u001d\u0001fA1\u0004f\u0006QqN\u001c*fgB|gn]3\u0015\r\u0005U5Q`B\u0000\u0011\u0019a(\r1\u0001\u0002\b!9A\u0011\u00012A\u0002\u0011\r\u0011\u0001\u0003:fgB|gn]3\u0011\r\u0011\u0015A\u0011BA\u0014\u001b\t!9AC\u0002\u0004ZaLA\u0001b\u0003\u0005\b\t\u0019AK]=)\u0007\t\u001c)/\u0001\np]J+7\u000f]8og\u0016\u001cu.\u001c9mKR,GcA@\u0005\u0014!9AQC2A\u0002\u0005U\u0015aA1os\"\u001a1m!:)\u0007E\u001a)/A\u0007Q_>dGj\\4T_V\u00148-Z\u000b\u0003\t?\u0001bAa\u0019\u0005\"\u0005m\u0018\u0002\u0002C\u0012\u0005K\u0012\u0011\u0002T8h'>,(oY3\u0002\u001dA{w\u000e\u001c'pON{WO]2fA!91q\u001b\u0002A\u0004\t}WCAA\u001a\u0001")
public interface PoolInterface {
    public static PoolInterface apply(PoolId poolId, ActorRefFactory actorRefFactory, PoolMaster poolMaster, Materializer materializer) {
        return PoolInterface$.MODULE$.apply(poolId, actorRefFactory, poolMaster, materializer);
    }

    public void request(HttpRequest var1, Promise<HttpResponse> var2);

    public Future<ShutdownReason> shutdown(ExecutionContext var1);

    public Future<ShutdownReason> whenShutdown();

    @InternalStableApi
    private static class Logic
    extends TimerGraphStageLogic
    implements PoolInterface,
    InHandler,
    OutHandler,
    LogHelper {
        private final PoolId poolId;
        private final PoolMaster master;
        private final Outlet<PoolFlow.RequestContext> requestOut;
        private final Inlet<PoolFlow.ResponseContext> responseIn;
        private final int bufferSize;
        private final LoggingAdapter log;
        private final ExecutionContext executionContext;
        private final BufferOverflowException PoolOverflowException;
        private final HostConnectionPoolSetup hcps;
        private final Duration idleTimeout;
        private final Promise<ShutdownReason> shutdownPromise;
        private Option<ShutdownReason> shuttingDownReason;
        private int remainingRequested;
        private final ArrayDeque<PoolFlow.RequestContext> buffer;
        private final AsyncCallback<Done> responseCompletedCallback;
        private final AsyncCallback<Tuple2<HttpRequest, Promise<HttpResponse>>> requestCallback;
        private final AsyncCallback<BoxedUnit> shutdownCallback;

        public boolean isDebugEnabled() {
            return LogHelper.isDebugEnabled$((LogHelper)this);
        }

        public boolean isInfoEnabled() {
            return LogHelper.isInfoEnabled$((LogHelper)this);
        }

        public boolean isWarningEnabled() {
            return LogHelper.isWarningEnabled$((LogHelper)this);
        }

        public String prefixString() {
            return LogHelper.prefixString$((LogHelper)this);
        }

        public void onDownstreamFinish() throws Exception {
            OutHandler.onDownstreamFinish$((OutHandler)this);
        }

        public void onDownstreamFinish(Throwable cause) throws Exception {
            OutHandler.onDownstreamFinish$((OutHandler)this, (Throwable)cause);
        }

        public void onUpstreamFinish() throws Exception {
            InHandler.onUpstreamFinish$((InHandler)this);
        }

        public LoggingAdapter log() {
            return this.log;
        }

        public HostConnectionPoolSetup hcps() {
            return this.hcps;
        }

        public Duration idleTimeout() {
            return this.idleTimeout;
        }

        public Promise<ShutdownReason> shutdownPromise() {
            return this.shutdownPromise;
        }

        public boolean shuttingDown() {
            return this.shuttingDownReason().isDefined();
        }

        public Option<ShutdownReason> shuttingDownReason() {
            return this.shuttingDownReason;
        }

        public void shuttingDownReason_$eq(Option<ShutdownReason> x$1) {
            this.shuttingDownReason = x$1;
        }

        public int remainingRequested() {
            return this.remainingRequested;
        }

        public void remainingRequested_$eq(int x$1) {
            this.remainingRequested = x$1;
        }

        public ArrayDeque<PoolFlow.RequestContext> buffer() {
            return this.buffer;
        }

        public void preStart() {
            this.onInit(this.poolId);
            this.pull(this.responseIn);
            this.resetIdleTimer();
        }

        public void onTimer(Object timerKey) {
            if (this.isDebugEnabled()) {
                this.log().debug(new StringBuilder(89).append(this.prefixString()).append("Pool shutting down because pekko.http.host-connection-pool.idle-timeout triggered after ").append(this.idleTimeout()).append(".").toString());
            }
            this.requestShutdown(PoolInterface$ShutdownReason$IdleTimeout$.MODULE$);
        }

        /*
         * Unable to fully structure code
         */
        public void onPush() {
            var1_1 = (PoolFlow.ResponseContext)this.grab(this.responseIn);
            if (var1_1 == null) {
                throw new MatchError(null);
            }
            rc = var1_1.rc();
            response0 = var1_1.response();
            rc = var2_2;
            response0 = var3_3;
            ctx = this.onResponse(rc.request(), (Try<HttpResponse>)response0);
            var8_7 = false;
            var9_8 = null;
            if (!(response0 instanceof Success)) ** GOTO lbl-1000
            var8_7 = true;
            var9_8 = (Success)response0;
            r = (HttpResponse)var9_8.value();
            var11_10 = HttpResponse$.MODULE$.unapply(r);
            if (!OptHttpResponse$.MODULE$.isEmpty$extension(var11_10) && !(entity = var11_10._3()).isStrict()) {
                var13_12 = StreamUtils$.MODULE$.transformEntityStream(entity, StreamUtils$CaptureTerminationOp$.MODULE$);
                if (var13_12 == null) {
                    throw new MatchError(null);
                }
                newEntity = (ResponseEntity)var13_12._1();
                termination = (Future)var13_12._2();
                newEntity = var14_13;
                var15_14.onComplete((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$onPush$1$adapted(org.apache.pekko.http.impl.engine.client.PoolInterface$Logic scala.util.Try ), (Lscala/util/Try;)Ljava/lang/Object;)((Logic)this), this.executionContext);
                v0 = new Success((Object)r.withEntity((org.apache.pekko.http.javadsl.model.ResponseEntity)newEntity));
            } else if (var8_7) {
                response = (HttpResponse)var9_8.value();
                this.remainingRequested_$eq(this.remainingRequested() - 1);
                v0 = new Success((Object)response);
            } else if (response0 instanceof Failure) {
                this.remainingRequested_$eq(this.remainingRequested() - 1);
                v0 = response0;
            } else {
                throw new MatchError((Object)response0);
            }
            response1 = v0;
            rc.responsePromise().complete((Try)response1);
            this.onResponseComplete(ctx);
            this.pull(this.responseIn);
            this.afterRequestFinished();
        }

        public void onPull() {
            if (!this.buffer().isEmpty()) {
                PoolFlow.RequestContext ctx = this.buffer().removeFirst();
                if (this.isDebugEnabled()) {
                    this.log().debug(new StringBuilder(63).append(this.prefixString()).append("Dispatching request [").append(package$RichHttpRequest$.MODULE$.debugString$extension(package$.MODULE$.RichHttpRequest(ctx.request()))).append("] from buffer to pool. Remaining buffer: ").append(this.buffer().size()).append("/").append(this.bufferSize).toString());
                }
                this.push(this.requestOut, ctx);
                return;
            }
        }

        public AsyncCallback<Done> responseCompletedCallback() {
            return this.responseCompletedCallback;
        }

        public AsyncCallback<Tuple2<HttpRequest, Promise<HttpResponse>>> requestCallback() {
            return this.requestCallback;
        }

        public AsyncCallback<BoxedUnit> shutdownCallback() {
            return this.shutdownCallback;
        }

        public void afterRequestFinished() {
            this.shutdownIfRequestedAndPossible();
            this.resetIdleTimer();
        }

        public void requestShutdown(ShutdownReason reason) {
            this.shuttingDownReason_$eq((Option<ShutdownReason>)new Some((Object)reason));
            this.shutdownIfRequestedAndPossible();
        }

        public void shutdownIfRequestedAndPossible() {
            if (this.shuttingDown()) {
                if (this.remainingRequested() == 0) {
                    if (this.isDebugEnabled()) {
                        this.log().debug(new StringBuilder(39).append(this.prefixString()).append("Pool is now shutting down as requested.").toString());
                    }
                    this.shutdownPromise().trySuccess(this.shuttingDownReason().get());
                    this.completeStage();
                    return;
                }
                if (this.isDebugEnabled()) {
                    this.log().debug(new StringBuilder(64).append(this.prefixString()).append("Pool is shutting down after waiting for [").append(this.remainingRequested()).append("] outstanding requests.").toString());
                }
                return;
            }
        }

        public void resetIdleTimer() {
            this.cancelTimer(PoolInterface$.MODULE$.org$apache$pekko$http$impl$engine$client$PoolInterface$$IdleTimeout());
            if (this.shouldStopOnIdle()) {
                this.scheduleOnce(PoolInterface$.MODULE$.org$apache$pekko$http$impl$engine$client$PoolInterface$$IdleTimeout(), (FiniteDuration)this.idleTimeout());
                return;
            }
        }

        public boolean shouldStopOnIdle() {
            return !this.shuttingDown() && this.remainingRequested() == 0 && this.idleTimeout().isFinite() && this.hcps().setup().settings().minConnections() == 0;
        }

        public void onUpstreamFailure(Throwable ex) {
            this.shutdownPromise().tryFailure(ex);
        }

        public void postStop() {
            this.shutdownPromise().tryFailure((Throwable)new IllegalStateException("Pool shutdown unexpectedly"));
        }

        @Override
        public void request(HttpRequest request, Promise<HttpResponse> responsePromise) {
            this.requestCallback().invokeWithFeedback((Object)new Tuple2((Object)request, responsePromise)).failed().foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                if (this.isDebugEnabled()) {
                    this.log().debug(new StringBuilder(106).append(this.prefixString()).append("Request was sent to pool which was already closed, retrying through the master to create new pool instance").toString());
                }
                return responsePromise.tryCompleteWith($this.master.dispatchRequest($this.poolId, request, this.materializer()));
            }, this.executionContext);
        }

        @Override
        public Future<ShutdownReason> shutdown(ExecutionContext ec) {
            this.shutdownCallback().invoke((Object)BoxedUnit.UNIT);
            return this.whenShutdown();
        }

        @Override
        public Future<ShutdownReason> whenShutdown() {
            return this.shutdownPromise().future();
        }

        @InternalStableApi
        public void onInit(PoolId poolId) {
        }

        @InternalStableApi
        public HttpRequest onDispatch(HttpRequest request) {
            return request;
        }

        @InternalStableApi
        public Object onResponse(HttpRequest request, Try<HttpResponse> response) {
            return None$.MODULE$;
        }

        @InternalStableApi
        public void onResponseComplete(Object any) {
        }

        public static final /* synthetic */ void $anonfun$onPush$1(Logic $this, Try x$3) {
            $this.responseCompletedCallback().invoke((Object)Done$.MODULE$);
        }

        public static final /* synthetic */ void $anonfun$responseCompletedCallback$1(Logic $this, Done x$4) {
            $this.remainingRequested_$eq($this.remainingRequested() - 1);
            $this.afterRequestFinished();
        }

        public static final /* synthetic */ void $anonfun$requestCallback$1(Logic $this, Tuple2 x0$1) {
            if (x0$1 != null) {
                HttpRequest request = (HttpRequest)x0$1._1();
                Promise responsePromise = (Promise)x0$1._2();
                String scheme = Uri$.MODULE$.httpScheme(((ConnectionContext)((Object)$this.hcps().setup().connectionContext())).isSecure());
                Host hostHeader = Host$.MODULE$.apply($this.hcps().host(), Uri$.MODULE$.normalizePort($this.hcps().port(), scheme));
                HttpRequest effectiveRequest = $this.onDispatch((HttpRequest)request.withUri(request.uri().toHttpRequestTargetOriginForm()).withDefaultHeaders((Seq<HttpHeader>)Predef$.MODULE$.wrapRefArray((Object[])new HttpHeader[]{hostHeader})));
                int retries = request.method().isIdempotent() ? $this.hcps().setup().settings().maxRetries() : 0;
                $this.remainingRequested_$eq($this.remainingRequested() + 1);
                $this.resetIdleTimer();
                PoolFlow.RequestContext ctx = new PoolFlow.RequestContext(effectiveRequest, (Promise<HttpResponse>)responsePromise, retries);
                if ($this.isAvailable($this.requestOut)) {
                    if ($this.isDebugEnabled()) {
                        $this.log().debug(new StringBuilder(30).append($this.prefixString()).append("Dispatching request [").append(package$RichHttpRequest$.MODULE$.debugString$extension(package$.MODULE$.RichHttpRequest(request))).append("] to pool").toString());
                    }
                    $this.push($this.requestOut, ctx);
                    return;
                }
                if ($this.buffer().size() < $this.bufferSize) {
                    $this.buffer().addLast(ctx);
                    if ($this.isDebugEnabled()) {
                        $this.log().debug(new StringBuilder(34).append($this.prefixString()).append("Buffering request [").append(package$RichHttpRequest$.MODULE$.debugString$extension(package$.MODULE$.RichHttpRequest(request))).append("] at position ").append($this.buffer().size()).append("/").append($this.bufferSize).toString());
                        return;
                    }
                    return;
                }
                if ($this.isDebugEnabled()) {
                    $this.log().debug(new StringBuilder(52).append($this.prefixString()).append("Could not dispatch request [").append(package$RichHttpRequest$.MODULE$.debugString$extension(package$.MODULE$.RichHttpRequest(request))).append("] because buffer is full").toString());
                }
                responsePromise.tryFailure((Throwable)$this.PoolOverflowException);
                return;
            }
            throw new MatchError(null);
        }

        public Logic(PoolId poolId, FlowShape<PoolFlow.ResponseContext, PoolFlow.RequestContext> shape, PoolMaster master, Outlet<PoolFlow.RequestContext> requestOut, Inlet<PoolFlow.ResponseContext> responseIn, int bufferSize, LoggingAdapter log, ExecutionContext executionContext) {
            this.poolId = poolId;
            this.master = master;
            this.requestOut = requestOut;
            this.responseIn = responseIn;
            this.bufferSize = bufferSize;
            this.log = log;
            this.executionContext = executionContext;
            super(shape);
            InHandler.$init$((InHandler)this);
            OutHandler.$init$((OutHandler)this);
            LogHelperMacro.$init$((LogHelperMacro)this);
            LogHelper.$init$((LogHelper)this);
            this.PoolOverflowException = new BufferOverflowException(new StringBuilder(376).append("Exceeded configured max-open-requests value of [").append(poolId.hcps().setup().settings().maxOpenRequests()).append("]. This means that the request queue of this pool (").append(poolId.hcps()).append(") ").append("has completely filled up because the pool currently does not process requests fast enough to handle the incoming request load. ").append("Please retry the request later. See https://pekko.apache.org/docs/pekko-http/current/scala/http/client-side/pool-overflow.html for ").append("more information.").toString());
            this.hcps = poolId.hcps();
            this.idleTimeout = this.hcps().setup().settings().idleTimeout();
            this.shutdownPromise = Promise$.MODULE$.apply();
            this.shuttingDownReason = None$.MODULE$;
            this.remainingRequested = 0;
            this.buffer = new ArrayDeque(bufferSize);
            this.setHandlers(responseIn, requestOut, this);
            this.responseCompletedCallback = this.getAsyncCallback((Function1 & Serializable & scala.Serializable)x$4 -> {
                Logic.$anonfun$responseCompletedCallback$1(this, x$4);
                return BoxedUnit.UNIT;
            });
            this.requestCallback = this.getAsyncCallback((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Logic.$anonfun$requestCallback$1(this, x0$1);
                return BoxedUnit.UNIT;
            });
            this.shutdownCallback = this.getAsyncCallback((Function1 & Serializable & scala.Serializable)x$5 -> {
                this.requestShutdown(PoolInterface$ShutdownReason$ShutdownRequested$.MODULE$);
                return BoxedUnit.UNIT;
            });
        }

        public static final /* synthetic */ Object $anonfun$onPush$1$adapted(Logic $this, Try x$3) {
            Logic.$anonfun$onPush$1($this, x$3);
            return BoxedUnit.UNIT;
        }
    }

    public static class PoolInterfaceStage
    extends GraphStageWithMaterializedValue<FlowShape<PoolFlow.ResponseContext, PoolFlow.RequestContext>, PoolInterface> {
        private final PoolId poolId;
        private final PoolMaster master;
        private final int bufferSize;
        private final LoggingAdapter log;
        private final Outlet<PoolFlow.RequestContext> requestOut;
        private final Inlet<PoolFlow.ResponseContext> responseIn;

        private Outlet<PoolFlow.RequestContext> requestOut() {
            return this.requestOut;
        }

        private Inlet<PoolFlow.ResponseContext> responseIn() {
            return this.responseIn;
        }

        public FlowShape<PoolFlow.ResponseContext, PoolFlow.RequestContext> shape() {
            return new FlowShape(this.responseIn(), this.requestOut());
        }

        public Tuple2<GraphStageLogic, PoolInterface> createLogicAndMaterializedValue(Attributes inheritedAttributes) {
            throw new IllegalStateException("Should not be called");
        }

        public Tuple2<GraphStageLogic, PoolInterface> createLogicAndMaterializedValue(Attributes inheritedAttributes, Materializer _materializer) {
            Logic logic = new Logic(this.poolId, this.shape(), this.master, this.requestOut(), this.responseIn(), this.bufferSize, this.log, (ExecutionContext)_materializer.executionContext());
            return new Tuple2((Object)logic, (Object)logic);
        }

        public PoolInterfaceStage(PoolId poolId, PoolMaster master, int bufferSize, LoggingAdapter log) {
            this.poolId = poolId;
            this.master = master;
            this.bufferSize = bufferSize;
            this.log = log;
            this.requestOut = Outlet$.MODULE$.apply("PoolInterface.requestOut");
            this.responseIn = Inlet$.MODULE$.apply("PoolInterface.responseIn");
        }
    }

    public static interface ShutdownReason {
    }
}

