/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign.annotation;

import feign.MethodMetadata;
import feign.Util;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import org.springframework.cloud.openfeign.AnnotatedParameterProcessor;
import org.springframework.web.bind.annotation.PathVariable;

public class PathVariableParameterProcessor
implements AnnotatedParameterProcessor {
    private static final Class<PathVariable> ANNOTATION = PathVariable.class;

    @Override
    public Class<? extends Annotation> getAnnotationType() {
        return ANNOTATION;
    }

    @Override
    public boolean processArgument(AnnotatedParameterProcessor.AnnotatedParameterContext context, Annotation annotation, Method method) {
        String name = ANNOTATION.cast(annotation).value();
        Util.checkState((Util.emptyToNull((String)name) != null ? 1 : 0) != 0, (String)"PathVariable annotation was empty on param %s.", (Object[])new Object[]{context.getParameterIndex()});
        context.setParameterName(name);
        MethodMetadata data = context.getMethodMetadata();
        String varName = "{" + name + "}";
        String varNameRegex = ".*\\{" + name + "(:[^}]+)?\\}.*";
        if (!(data.template().url().matches(varNameRegex) || this.containsMapValues(data.template().queries(), varName) || this.containsMapValues(data.template().headers(), varName))) {
            data.formParams().add(name);
        }
        return true;
    }

    private <K, V> boolean containsMapValues(Map<K, Collection<V>> map, V search) {
        Collection<Collection<V>> values = map.values();
        if (values == null) {
            return false;
        }
        for (Collection<V> entry : values) {
            if (!entry.contains(search)) continue;
            return true;
        }
        return false;
    }
}

