/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.config;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.redisson.api.RedissonNodeInitializer;
import org.redisson.config.Config;
import org.redisson.config.ConfigSupport;

public class RedissonNodeFileConfig
extends Config {
    private int mapReduceWorkers = 0;
    private RedissonNodeInitializer redissonNodeInitializer;
    private Map<String, Integer> executorServiceWorkers = new HashMap<String, Integer>();

    public RedissonNodeFileConfig() {
    }

    public RedissonNodeFileConfig(Config oldConf) {
        super(oldConf);
    }

    public RedissonNodeFileConfig(RedissonNodeFileConfig oldConf) {
        super(oldConf);
        this.executorServiceWorkers = new HashMap<String, Integer>(oldConf.executorServiceWorkers);
        this.redissonNodeInitializer = oldConf.redissonNodeInitializer;
        this.mapReduceWorkers = oldConf.mapReduceWorkers;
    }

    public RedissonNodeFileConfig setMapReduceWorkers(int mapReduceWorkers) {
        this.mapReduceWorkers = mapReduceWorkers;
        return this;
    }

    public int getMapReduceWorkers() {
        return this.mapReduceWorkers;
    }

    public RedissonNodeFileConfig setExecutorServiceWorkers(Map<String, Integer> workers) {
        this.executorServiceWorkers = workers;
        return this;
    }

    public Map<String, Integer> getExecutorServiceWorkers() {
        return this.executorServiceWorkers;
    }

    public RedissonNodeFileConfig setRedissonNodeInitializer(RedissonNodeInitializer redissonNodeInitializer) {
        this.redissonNodeInitializer = redissonNodeInitializer;
        return this;
    }

    public RedissonNodeInitializer getRedissonNodeInitializer() {
        return this.redissonNodeInitializer;
    }

    public static RedissonNodeFileConfig fromJSON(File file) throws IOException {
        ConfigSupport support = new ConfigSupport();
        return support.fromJSON(file, RedissonNodeFileConfig.class);
    }

    public static RedissonNodeFileConfig fromYAML(File file) throws IOException {
        ConfigSupport support = new ConfigSupport();
        return support.fromYAML(file, RedissonNodeFileConfig.class);
    }
}

