/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.serialization;

import org.apache.pekko.actor.ActorPath;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorRefProvider;
import org.apache.pekko.actor.ActorRefWithCell;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Address;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.serialization.Serialization;
import scala.Function0;
import scala.Serializable;
import scala.util.DynamicVariable;
import scala.util.control.NonFatal$;

public final class Serialization$ {
    public static Serialization$ MODULE$;
    @InternalApi
    private final DynamicVariable<Serialization.Information> currentTransportInformation;

    static {
        new Serialization$();
    }

    public DynamicVariable<Serialization.Information> currentTransportInformation() {
        return this.currentTransportInformation;
    }

    public String serializedActorPath(ActorRef actorRef) {
        ActorPath path = actorRef.path();
        ExtendedActorSystem originalSystem = actorRef instanceof ActorRefWithCell ? (ExtendedActorSystem)((ActorRefWithCell)actorRef).underlying().system() : null;
        Serialization.Information information = (Serialization.Information)this.currentTransportInformation().value();
        if (information == null) {
            if (originalSystem == null) {
                return path.toSerializationFormat();
            }
            try {
                return path.toSerializationFormatWithAddress(originalSystem.provider().getDefaultAddress());
            }
            catch (Throwable throwable) {
                if (!NonFatal$.MODULE$.unapply(throwable).isEmpty()) {
                    return path.toSerializationFormat();
                }
                throw throwable;
            }
        }
        Address address = information.address();
        ActorSystem system = information.system();
        if (originalSystem == null || originalSystem.equals(system)) {
            return path.toSerializationFormatWithAddress(address);
        }
        ActorRefProvider provider = originalSystem.provider();
        return path.toSerializationFormatWithAddress((Address)provider.getExternalAddressFor(address).getOrElse((Function0 & java.io.Serializable & Serializable)() -> provider.getDefaultAddress()));
    }

    public <T> T withTransportInformation(ExtendedActorSystem system, Function0<T> f) {
        Serialization.Information info = system.provider().serializationInformation();
        if (this.currentTransportInformation().value() == info) {
            return (T)f.apply();
        }
        return (T)this.currentTransportInformation().withValue((Object)info, f);
    }

    public Serialization.Information getCurrentTransportInformation() {
        Serialization.Information information = (Serialization.Information)this.currentTransportInformation().value();
        if (information == null) {
            throw new IllegalStateException("currentTransportInformation is not set, use Serialization.withTransportInformation");
        }
        return information;
    }

    private Serialization$() {
        MODULE$ = this;
        this.currentTransportInformation = new DynamicVariable(null);
    }
}

