/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.sharding.internal;

import java.io.Serializable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.sharding.internal.ActiveEntities;
import org.apache.pekko.cluster.sharding.internal.AdmissionFilter;
import org.apache.pekko.cluster.sharding.internal.AdmissionOptimizer;
import org.apache.pekko.cluster.sharding.internal.EntityPassivationStrategy$PassivateEntities$;
import org.apache.pekko.cluster.sharding.internal.IdleCheck;
import org.apache.pekko.cluster.sharding.internal.LimitBasedEntityPassivationStrategy;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005Mc!\u0002\u000f\u001e\u0005\rJ\u0003\u0002\u0003\u0018\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0019\t\u0011Y\u0002!\u0011!Q\u0001\n]B\u0001B\u000f\u0001\u0003\u0002\u0003\u0006Ia\u000f\u0005\t}\u0001\u0011\t\u0011)A\u0005w!Aq\b\u0001B\u0001B\u0003%1\b\u0003\u0005A\u0001\t\u0005\t\u0015!\u0003B\u0011!!\u0005A!A!\u0002\u0013)\u0005\u0002\u0003%\u0001\u0005\u0003\u0005\u000b\u0011B\u001c\t\u0011%\u0003!\u0011!Q\u0001\n)CQ\u0001\u0015\u0001\u0005\u0002ECq\u0001\u0018\u0001A\u0002\u0013%Q\fC\u0004_\u0001\u0001\u0007I\u0011B0\t\r\u0015\u0004\u0001\u0015)\u0003<\u0011\u001d1\u0007\u00011A\u0005\n\u001dDq\u0001\u001b\u0001A\u0002\u0013%\u0011\u000e\u0003\u0004l\u0001\u0001\u0006K\u0001\r\u0005\bY\u0002\u0001\r\u0011\"\u0003h\u0011\u001di\u0007\u00011A\u0005\n9Da\u0001\u001d\u0001!B\u0013\u0001\u0004\"B9\u0001\t\u0013\u0011\b\"B:\u0001\t\u0003\"\bbBA\r\u0001\u0011\u0005\u00131\u0004\u0005\b\u0003?\u0001A\u0011KA\u0011\u0011\u001d\t\u0019\u0003\u0001C!\u0003KAq!!\u000f\u0001\t\u0003\n\t\u0003C\u0004\u0002<\u0001!I!!\u0010\t\r\u0005\r\u0003\u0001\"\u0003s\u0005\t\u001au.\u001c9pg&$X-\u00128uSRL\b+Y:tSZ\fG/[8o'R\u0014\u0018\r^3hs*\u0011adH\u0001\tS:$XM\u001d8bY*\u0011\u0001%I\u0001\tg\"\f'\u000fZ5oO*\u0011!eI\u0001\bG2,8\u000f^3s\u0015\t!S%A\u0003qK.\\wN\u0003\u0002'O\u00051\u0011\r]1dQ\u0016T\u0011\u0001K\u0001\u0004_J<7C\u0001\u0001+!\tYC&D\u0001\u001e\u0013\tiSDA\u0012MS6LGOQ1tK\u0012,e\u000e^5usB\u000b7o]5wCRLwN\\*ue\u0006$XmZ=\u0002\u0019%t\u0017\u000e^5bY2KW.\u001b;\u0004\u0001A\u0011\u0011\u0007N\u0007\u0002e)\t1'A\u0003tG\u0006d\u0017-\u0003\u00026e\t\u0019\u0011J\u001c;\u0002\r]Lg\u000eZ8x!\tY\u0003(\u0003\u0002:;\tq\u0011i\u0019;jm\u0016,e\u000e^5uS\u0016\u001c\u0018aF5oSRL\u0017\r\\,j]\u0012|w\u000f\u0015:pa>\u0014H/[8o!\t\tD(\u0003\u0002>e\t1Ai\\;cY\u0016\fq#\\5oS6,XnV5oI><\bK]8q_J$\u0018n\u001c8\u0002/5\f\u00070[7v[^Kg\u000eZ8x!J|\u0007o\u001c:uS>t\u0017aD<j]\u0012|wo\u00149uS6L'0\u001a:\u0011\u0005-\u0012\u0015BA\"\u001e\u0005I\tE-\\5tg&|gn\u00149uS6L'0\u001a:\u0002\u001f\u0005$W.[:tS>tg)\u001b7uKJ\u0004\"a\u000b$\n\u0005\u001dk\"aD!e[&\u001c8/[8o\r&dG/\u001a:\u0002\t5\f\u0017N\\\u0001\nS\u0012dWm\u00115fG.\u00042!M&N\u0013\ta%G\u0001\u0004PaRLwN\u001c\t\u0003W9K!aT\u000f\u0003\u0013%#G.Z\"iK\u000e\\\u0017A\u0002\u001fj]&$h\b\u0006\u0006S'R+fk\u0016-Z5n\u0003\"a\u000b\u0001\t\u000b9R\u0001\u0019\u0001\u0019\t\u000bYR\u0001\u0019A\u001c\t\u000biR\u0001\u0019A\u001e\t\u000byR\u0001\u0019A\u001e\t\u000b}R\u0001\u0019A\u001e\t\u000b\u0001S\u0001\u0019A!\t\u000b\u0011S\u0001\u0019A#\t\u000b!S\u0001\u0019A\u001c\t\u000b%S\u0001\u0019\u0001&\u0002!]Lg\u000eZ8x!J|\u0007o\u001c:uS>tW#A\u001e\u0002)]Lg\u000eZ8x!J|\u0007o\u001c:uS>tw\fJ3r)\t\u00017\r\u0005\u00022C&\u0011!M\r\u0002\u0005+:LG\u000fC\u0004e\u0019\u0005\u0005\t\u0019A\u001e\u0002\u0007a$\u0013'A\txS:$wn\u001e)s_B|'\u000f^5p]\u0002\n1b^5oI><H*[7jiV\t\u0001'A\bxS:$wn\u001e'j[&$x\fJ3r)\t\u0001'\u000eC\u0004e\u001f\u0005\u0005\t\u0019\u0001\u0019\u0002\u0019]Lg\u000eZ8x\u0019&l\u0017\u000e\u001e\u0011\u0002\u00135\f\u0017N\u001c'j[&$\u0018!D7bS:d\u0015.\\5u?\u0012*\u0017\u000f\u0006\u0002a_\"9AMEA\u0001\u0002\u0004\u0001\u0014AC7bS:d\u0015.\\5uA\u0005y1-\u00197dk2\fG/\u001a'j[&$8\u000fF\u0001a\u00035)g\u000e^5usR{Wo\u00195fIR\u0011Q\u000f \t\u0003mft!aK<\n\u0005al\u0012!G#oi&$\u0018\u0010U1tg&4\u0018\r^5p]N#(/\u0019;fOfL!A_>\u0003#A\u000b7o]5wCR,WI\u001c;ji&,7O\u0003\u0002y;!)Q0\u0006a\u0001}\u0006\u0011\u0011\u000e\u001a\t\u0004\u007f\u0006Ma\u0002BA\u0001\u0003\u001fqA!a\u0001\u0002\u000e9!\u0011QAA\u0006\u001d\u0011\t9!!\u0003\u000e\u0003\u0015J!\u0001J\u0013\n\u0005\t\u001a\u0013B\u0001\u0011\"\u0013\r\t\tbH\u0001\f'\"\f'\u000f\u001a*fO&|g.\u0003\u0003\u0002\u0016\u0005]!\u0001C#oi&$\u00180\u00133\u000b\u0007\u0005Eq$\u0001\tf]RLG/\u001f+fe6Lg.\u0019;fIR\u0019\u0001-!\b\t\u000bu4\u0002\u0019\u0001@\u0002=A\f7o]5wCR,WI\u001c;ji&,7o\u00148MS6LG/\u00169eCR,G#A;\u0002#M\u001c\u0007.\u001a3vY\u0016$\u0017J\u001c;feZ\fG.\u0006\u0002\u0002(A!\u0011gSA\u0015!\u0011\tY#!\u000e\u000e\u0005\u00055\"\u0002BA\u0018\u0003c\t\u0001\u0002Z;sCRLwN\u001c\u0006\u0004\u0003g\u0011\u0014AC2p]\u000e,(O]3oi&!\u0011qGA\u0017\u000591\u0015N\\5uK\u0012+(/\u0019;j_:\fa\"\u001b8uKJ4\u0018\r\u001c)bgN,G-\u0001\tnCf\u0014W-\u00113nSR$v.T1j]R\u0019Q/a\u0010\t\r\u0005\u0005#\u00041\u0001v\u0003)\u0019\u0017M\u001c3jI\u0006$Xm]\u0001\fC\u0012\f\u0007\u000f^,j]\u0012|w\u000fK\u0002\u0001\u0003\u000f\u0002B!!\u0013\u0002P5\u0011\u00111\n\u0006\u0004\u0003\u001b\u001a\u0013AC1o]>$\u0018\r^5p]&!\u0011\u0011KA&\u0005-Ie\u000e^3s]\u0006d\u0017\t]5")
@InternalApi
public final class CompositeEntityPassivationStrategy
extends LimitBasedEntityPassivationStrategy {
    private final ActiveEntities window;
    private final double minimumWindowProportion;
    private final double maximumWindowProportion;
    private final AdmissionOptimizer windowOptimizer;
    private final AdmissionFilter admissionFilter;
    private final ActiveEntities main;
    private final Option<IdleCheck> idleCheck;
    private double windowProportion;
    private int windowLimit;
    private int mainLimit;

    private double windowProportion() {
        return this.windowProportion;
    }

    private void windowProportion_$eq(double x$1) {
        this.windowProportion = x$1;
    }

    private int windowLimit() {
        return this.windowLimit;
    }

    private void windowLimit_$eq(int x$1) {
        this.windowLimit = x$1;
    }

    private int mainLimit() {
        return this.mainLimit;
    }

    private void mainLimit_$eq(int x$1) {
        this.mainLimit = x$1;
    }

    private void calculateLimits() {
        this.windowLimit_$eq((int)(this.windowProportion() * (double)this.perShardLimit()));
        this.mainLimit_$eq(this.perShardLimit() - this.windowLimit());
    }

    @Override
    public Seq<String> entityTouched(String id) {
        Seq<String> seq;
        this.admissionFilter.update(id);
        if (this.window.isActive(id)) {
            this.windowOptimizer.recordActive();
            seq = this.window.update(id);
        } else if (this.main.isActive(id)) {
            this.windowOptimizer.recordActive();
            seq = this.main.update(id);
        } else {
            this.windowOptimizer.recordPassive();
            seq = this.maybeAdmitToMain(this.window.update(id));
        }
        Seq<String> passivated = seq;
        this.adaptWindow();
        return passivated;
    }

    @Override
    public void entityTerminated(String id) {
        this.window.remove(id);
        this.main.remove(id);
    }

    @Override
    public Seq<String> passivateEntitiesOnLimitUpdate() {
        this.calculateLimits();
        this.windowOptimizer.updateLimit(this.perShardLimit());
        this.admissionFilter.updateCapacity(this.perShardLimit());
        return (Seq)this.maybeAdmitToMain(this.window.updateLimit(this.windowLimit())).$plus$plus(this.main.updateLimit(this.mainLimit()), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public Option<FiniteDuration> scheduledInterval() {
        return this.idleCheck.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.interval());
    }

    @Override
    public Seq<String> intervalPassed() {
        return (Seq)this.idleCheck.fold((Function0 & Serializable & scala.Serializable)() -> EntityPassivationStrategy$PassivateEntities$.MODULE$.none(), (Function1 & Serializable & scala.Serializable)idle2 -> (Seq)$this.window.removeIdle(idle2.timeout()).$plus$plus($this.main.removeIdle(idle2.timeout()), Seq$.MODULE$.canBuildFrom()));
    }

    private Seq<String> maybeAdmitToMain(Seq<String> candidates) {
        if (candidates.nonEmpty()) {
            ObjectRef passivated = ObjectRef.create(EntityPassivationStrategy$PassivateEntities$.MODULE$.none());
            candidates.foreach((Function1 & Serializable & scala.Serializable)candidate -> {
                CompositeEntityPassivationStrategy.$anonfun$maybeAdmitToMain$1(this, passivated, candidate);
                return BoxedUnit.UNIT;
            });
            return (Seq)passivated.elem;
        }
        return EntityPassivationStrategy$PassivateEntities$.MODULE$.none();
    }

    private void adaptWindow() {
        double adjustment = this.windowOptimizer.calculateAdjustment();
        if (adjustment != 0.0) {
            this.windowProportion_$eq(package$.MODULE$.max(this.minimumWindowProportion, package$.MODULE$.min(this.maximumWindowProportion, this.windowProportion() + adjustment)));
            this.calculateLimits();
            if (adjustment > 0.0) {
                this.window.updateLimit(this.windowLimit());
                this.main.updateLimit(this.mainLimit()).foreach((Function1 & Serializable & scala.Serializable)id -> $this.window.update((String)id));
                return;
            }
            this.main.updateLimit(this.mainLimit());
            this.window.updateLimit(this.windowLimit()).foreach((Function1 & Serializable & scala.Serializable)id -> $this.main.update((String)id));
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$maybeAdmitToMain$1(CompositeEntityPassivationStrategy $this, ObjectRef passivated$1, String candidate) {
        if ($this.main.size() >= $this.mainLimit()) {
            String string = $this.main.select();
            String string2 = (String)OptionVal.Some$.MODULE$.unapply((Object)string);
            if (!OptionVal$.MODULE$.isEmpty$extension((Object)string2)) {
                String selected = (String)OptionVal$.MODULE$.get$extension((Object)string2);
                if ($this.admissionFilter.admit(candidate, selected)) {
                    passivated$1.elem = (Seq)((Seq)passivated$1.elem).$plus$plus($this.main.update(candidate), Seq$.MODULE$.canBuildFrom());
                    return;
                }
                passivated$1.elem = (Seq)((Seq)passivated$1.elem).$colon$plus((Object)candidate, Seq$.MODULE$.canBuildFrom());
                return;
            }
            passivated$1.elem = (Seq)((Seq)passivated$1.elem).$plus$plus($this.main.update(candidate), Seq$.MODULE$.canBuildFrom());
            return;
        }
        passivated$1.elem = (Seq)((Seq)passivated$1.elem).$plus$plus($this.main.update(candidate), Seq$.MODULE$.canBuildFrom());
    }

    public CompositeEntityPassivationStrategy(int initialLimit, ActiveEntities window, double initialWindowProportion, double minimumWindowProportion, double maximumWindowProportion, AdmissionOptimizer windowOptimizer, AdmissionFilter admissionFilter, ActiveEntities main, Option<IdleCheck> idleCheck) {
        this.window = window;
        this.minimumWindowProportion = minimumWindowProportion;
        this.maximumWindowProportion = maximumWindowProportion;
        this.windowOptimizer = windowOptimizer;
        this.admissionFilter = admissionFilter;
        this.main = main;
        this.idleCheck = idleCheck;
        super(initialLimit);
        this.windowProportion = initialWindowProportion;
        this.windowLimit = 0;
        this.mainLimit = 0;
        this.calculateLimits();
        window.updateLimit(this.windowLimit());
        main.updateLimit(this.mainLimit());
    }
}

