/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.web.interceptor;

import cn.sliew.carp.framework.web.util.RequestParamUtil;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.AsyncHandlerInterceptor;
import org.springframework.web.util.ContentCachingResponseWrapper;
import org.springframework.web.util.WebUtils;

public class AsyncWebLogInterceptor
implements AsyncHandlerInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsyncWebLogInterceptor.class);

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        this.logQuery(request);
        ContentCachingResponseWrapper responseWrapper = (ContentCachingResponseWrapper)WebUtils.getNativeResponse((ServletResponse)response, ContentCachingResponseWrapper.class);
        if (responseWrapper != null) {
            responseWrapper.copyBodyToResponse();
        }
    }

    private void logQuery(HttpServletRequest request) {
        if (!RequestParamUtil.ignorePath(request.getRequestURI()) && log.isInfoEnabled()) {
            String params = RequestParamUtil.formatRequestParams(request);
            log.info("{} {} {}", new Object[]{request.getMethod(), request.getRequestURI(), params});
        }
    }
}

