/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.redisson.RedissonExpirable;
import org.redisson.api.AutoClaimResult;
import org.redisson.api.FastAutoClaimResult;
import org.redisson.api.ObjectListener;
import org.redisson.api.PendingEntry;
import org.redisson.api.PendingResult;
import org.redisson.api.RFuture;
import org.redisson.api.RStream;
import org.redisson.api.StreamConsumer;
import org.redisson.api.StreamGroup;
import org.redisson.api.StreamInfo;
import org.redisson.api.StreamMessageId;
import org.redisson.api.listener.StreamAddListener;
import org.redisson.api.listener.StreamCreateConsumerListener;
import org.redisson.api.listener.StreamCreateGroupListener;
import org.redisson.api.listener.StreamRemoveConsumerListener;
import org.redisson.api.listener.StreamRemoveGroupListener;
import org.redisson.api.listener.StreamRemoveListener;
import org.redisson.api.listener.StreamTrimListener;
import org.redisson.api.listener.TrackingListener;
import org.redisson.api.stream.StreamAddArgs;
import org.redisson.api.stream.StreamAddParams;
import org.redisson.api.stream.StreamCreateGroupArgs;
import org.redisson.api.stream.StreamCreateGroupParams;
import org.redisson.api.stream.StreamMultiReadArgs;
import org.redisson.api.stream.StreamMultiReadGroupArgs;
import org.redisson.api.stream.StreamMultiReadGroupParams;
import org.redisson.api.stream.StreamMultiReadParams;
import org.redisson.api.stream.StreamReadArgs;
import org.redisson.api.stream.StreamReadGroupArgs;
import org.redisson.api.stream.StreamReadGroupParams;
import org.redisson.api.stream.StreamReadParams;
import org.redisson.api.stream.StreamTrimArgs;
import org.redisson.api.stream.StreamTrimParams;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.decoder.CodecDecoder;
import org.redisson.client.protocol.decoder.ListMultiDecoder2;
import org.redisson.client.protocol.decoder.ObjectMapReplayDecoder;
import org.redisson.client.protocol.decoder.StreamInfoDecoder;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.CompletableFutureWrapper;

public class RedissonStream<K, V>
extends RedissonExpirable
implements RStream<K, V> {
    private static final RedisCommand<Map<StreamMessageId, Map<Object, Object>>> EVAL_XRANGE = new RedisCommand<Map<StreamMessageId, Map<Object, Object>>>("EVAL", RedisCommands.XRANGE.getReplayMultiDecoder());

    public RedissonStream(Codec codec, CommandAsyncExecutor connectionManager, String name) {
        super(codec, connectionManager, name);
    }

    public RedissonStream(CommandAsyncExecutor connectionManager, String name) {
        super(connectionManager, name);
    }

    protected void checkKey(Object key) {
        if (key == null) {
            throw new NullPointerException("key can't be null");
        }
    }

    protected void checkValue(Object value) {
        if (value == null) {
            throw new NullPointerException("value can't be null");
        }
    }

    @Override
    public void createGroup(StreamCreateGroupArgs args) {
        this.get(this.createGroupAsync(args));
    }

    @Override
    public RFuture<Void> createGroupAsync(StreamCreateGroupArgs args) {
        StreamCreateGroupParams pps = (StreamCreateGroupParams)args;
        LinkedList<Object> params = new LinkedList<Object>();
        params.add("CREATE");
        params.add(this.getRawName());
        params.add(pps.getName());
        params.add(pps.getId());
        if (pps.isMakeStream()) {
            params.add("MKSTREAM");
        }
        if (pps.getEntriesRead() > 0) {
            params.add("ENTRIESREAD");
            params.add(pps.getEntriesRead());
        }
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.XGROUP, params.toArray());
    }

    @Override
    public RFuture<Long> ackAsync(String groupName, StreamMessageId ... ids) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(this.getRawName());
        params.add(groupName);
        params.addAll(Arrays.asList(ids));
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.XACK, params.toArray());
    }

    @Override
    public long ack(String groupName, StreamMessageId ... id) {
        return this.get(this.ackAsync(groupName, id));
    }

    @Override
    public RFuture<PendingResult> getPendingInfoAsync(String groupName) {
        return this.commandExecutor.readAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.XPENDING, this.getRawName(), groupName);
    }

    @Override
    public PendingResult getPendingInfo(String groupName) {
        return this.get(this.getPendingInfoAsync(groupName));
    }

    @Override
    public RFuture<List<PendingEntry>> listPendingAsync(String groupName, String consumerName, StreamMessageId startId, StreamMessageId endId, int count) {
        return this.commandExecutor.readAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.XPENDING_ENTRIES, this.getRawName(), groupName, startId, endId, count, consumerName);
    }

    @Override
    public RFuture<List<PendingEntry>> listPendingAsync(String groupName, StreamMessageId startId, StreamMessageId endId, int count) {
        return this.commandExecutor.readAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.XPENDING_ENTRIES, this.getRawName(), groupName, startId, endId, count);
    }

    @Override
    public RFuture<List<PendingEntry>> listPendingAsync(String groupName, StreamMessageId startId, StreamMessageId endId, long idleTime, TimeUnit idleTimeUnit, int count) {
        return this.commandExecutor.readAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.XPENDING_ENTRIES, this.getRawName(), groupName, "IDLE", idleTimeUnit.toMillis(idleTime), startId, endId, count);
    }

    @Override
    public RFuture<List<PendingEntry>> listPendingAsync(String groupName, String consumerName, StreamMessageId startId, StreamMessageId endId, long idleTime, TimeUnit idleTimeUnit, int count) {
        return this.commandExecutor.readAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.XPENDING_ENTRIES, this.getRawName(), groupName, "IDLE", idleTimeUnit.toMillis(idleTime), startId, endId, count, consumerName);
    }

    @Override
    public List<PendingEntry> listPending(String groupName, StreamMessageId startId, StreamMessageId endId, int count) {
        return this.get(this.listPendingAsync(groupName, startId, endId, count));
    }

    @Override
    public List<PendingEntry> listPending(String groupName, String consumerName, StreamMessageId startId, StreamMessageId endId, int count) {
        return this.get(this.listPendingAsync(groupName, consumerName, startId, endId, count));
    }

    @Override
    public List<PendingEntry> listPending(String groupName, StreamMessageId startId, StreamMessageId endId, long idleTime, TimeUnit idleTimeUnit, int count) {
        return this.get(this.listPendingAsync(groupName, startId, endId, idleTime, idleTimeUnit, count));
    }

    @Override
    public List<PendingEntry> listPending(String groupName, String consumerName, StreamMessageId startId, StreamMessageId endId, long idleTime, TimeUnit idleTimeUnit, int count) {
        return this.get(this.listPendingAsync(groupName, consumerName, startId, endId, idleTime, idleTimeUnit, count));
    }

    @Override
    public List<StreamMessageId> fastClaim(String groupName, String consumerName, long idleTime, TimeUnit idleTimeUnit, StreamMessageId ... ids) {
        return this.get(this.fastClaimAsync(groupName, consumerName, idleTime, idleTimeUnit, ids));
    }

    @Override
    public RFuture<List<StreamMessageId>> fastClaimAsync(String groupName, String consumerName, long idleTime, TimeUnit idleTimeUnit, StreamMessageId ... ids) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(this.getRawName());
        params.add(groupName);
        params.add(consumerName);
        params.add(idleTimeUnit.toMillis(idleTime));
        for (StreamMessageId id : ids) {
            params.add(id.toString());
        }
        params.add("JUSTID");
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.XCLAIM_IDS, params.toArray());
    }

    @Override
    public AutoClaimResult<K, V> autoClaim(String groupName, String consumerName, long idleTime, TimeUnit idleTimeUnit, StreamMessageId startId, int count) {
        return this.get(this.autoClaimAsync(groupName, consumerName, idleTime, idleTimeUnit, startId, count));
    }

    @Override
    public RFuture<AutoClaimResult<K, V>> autoClaimAsync(String groupName, String consumerName, long idleTime, TimeUnit idleTimeUnit, StreamMessageId startId, int count) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(this.getRawName());
        params.add(groupName);
        params.add(consumerName);
        params.add(idleTimeUnit.toMillis(idleTime));
        params.add(startId.toString());
        params.add("COUNT");
        params.add(count);
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.XAUTOCLAIM, params.toArray());
    }

    @Override
    public FastAutoClaimResult fastAutoClaim(String groupName, String consumerName, long idleTime, TimeUnit idleTimeUnit, StreamMessageId startId, int count) {
        return this.get(this.fastAutoClaimAsync(groupName, consumerName, idleTime, idleTimeUnit, startId, count));
    }

    @Override
    public Map<String, Map<StreamMessageId, Map<K, V>>> readGroup(String groupName, String consumerName, StreamMultiReadGroupArgs args) {
        return this.get(this.readGroupAsync(groupName, consumerName, args));
    }

    @Override
    public Map<StreamMessageId, Map<K, V>> readGroup(String groupName, String consumerName, StreamReadGroupArgs args) {
        return this.get(this.readGroupAsync(groupName, consumerName, args));
    }

    @Override
    public RFuture<Map<String, Map<StreamMessageId, Map<K, V>>>> readGroupAsync(String groupName, String consumerName, StreamMultiReadGroupArgs args) {
        StreamMultiReadGroupParams rp = (StreamMultiReadGroupParams)args;
        ArrayList<Object> params = new ArrayList<Object>();
        params.add("GROUP");
        params.add(groupName);
        params.add(consumerName);
        if (rp.getCount() > 0) {
            params.add("COUNT");
            params.add(rp.getCount());
        }
        if (rp.getTimeout() != null) {
            params.add("BLOCK");
            params.add(rp.getTimeout().toMillis());
        }
        if (rp.isNoAck()) {
            params.add("NOACK");
        }
        params.add("STREAMS");
        params.add(this.getRawName());
        params.addAll(rp.getOffsets().keySet());
        if (rp.getId1() == null) {
            params.add(">");
        } else {
            params.add(rp.getId1().toString());
        }
        for (StreamMessageId nextId : rp.getOffsets().values()) {
            params.add(nextId.toString());
        }
        if (rp.getTimeout() != null) {
            return this.commandExecutor.writeAsync(this.getRawName(), this.codec, this.getServiceManager().getXReadGroupBlockingCommand(), params.toArray());
        }
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, this.getServiceManager().getXReadGroupCommand(), params.toArray());
    }

    @Override
    public RFuture<Map<StreamMessageId, Map<K, V>>> readGroupAsync(String groupName, String consumerName, StreamReadGroupArgs args) {
        StreamReadGroupParams rp = (StreamReadGroupParams)args;
        ArrayList<Object> params = new ArrayList<Object>();
        params.add("GROUP");
        params.add(groupName);
        params.add(consumerName);
        if (rp.getCount() > 0) {
            params.add("COUNT");
            params.add(rp.getCount());
        }
        if (rp.getTimeout() != null) {
            params.add("BLOCK");
            params.add(rp.getTimeout().toMillis());
        }
        if (rp.isNoAck()) {
            params.add("NOACK");
        }
        params.add("STREAMS");
        params.add(this.getRawName());
        if (rp.getId1() == null) {
            params.add(">");
        } else {
            params.add(rp.getId1().toString());
        }
        if (rp.getTimeout() != null) {
            return this.commandExecutor.writeAsync(this.getRawName(), this.codec, this.getServiceManager().getXReadGroupBlockingSingleCommand(), params.toArray());
        }
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, this.getServiceManager().getXReadGroupSingleCommand(), params.toArray());
    }

    @Override
    public RFuture<FastAutoClaimResult> fastAutoClaimAsync(String groupName, String consumerName, long idleTime, TimeUnit idleTimeUnit, StreamMessageId startId, int count) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(this.getRawName());
        params.add(groupName);
        params.add(consumerName);
        params.add(idleTimeUnit.toMillis(idleTime));
        params.add(startId.toString());
        params.add("COUNT");
        params.add(count);
        params.add("JUSTID");
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.XAUTOCLAIM_IDS, params.toArray());
    }

    @Override
    public RFuture<Map<StreamMessageId, Map<K, V>>> claimAsync(String groupName, String consumerName, long idleTime, TimeUnit idleTimeUnit, StreamMessageId ... ids) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(this.getRawName());
        params.add(groupName);
        params.add(consumerName);
        params.add(idleTimeUnit.toMillis(idleTime));
        for (StreamMessageId id : ids) {
            params.add(id.toString());
        }
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.XCLAIM, params.toArray());
    }

    @Override
    public Map<StreamMessageId, Map<K, V>> claim(String groupName, String consumerName, long idleTime, TimeUnit idleTimeUnit, StreamMessageId ... ids) {
        return this.get(this.claimAsync(groupName, consumerName, idleTime, idleTimeUnit, ids));
    }

    private <R> RFuture<R> addAllCustomAsync(StreamMessageId id, Map<K, V> entries, int trimLen, boolean trimStrict) {
        ArrayList<Object> params = new ArrayList<Object>(entries.size() * 2 + 1);
        params.add(this.getRawName());
        if (trimLen > 0) {
            params.add("MAXLEN");
            if (!trimStrict) {
                params.add("~");
            }
            params.add(trimLen);
        }
        if (id == null) {
            params.add("*");
        } else {
            params.add(id.toString());
        }
        for (Map.Entry<K, V> t : entries.entrySet()) {
            this.checkKey(t.getKey());
            this.checkValue(t.getValue());
            params.add(this.encodeMapKey(t.getKey()));
            params.add(this.encodeMapValue(t.getValue()));
        }
        if (id == null) {
            return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.XADD, params.toArray());
        }
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.XADD_VOID, params.toArray());
    }

    @Override
    public long size() {
        return this.get(this.sizeAsync());
    }

    @Override
    public RFuture<Long> sizeAsync() {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.XLEN, this.getRawName());
    }

    @Override
    public Map<String, Map<StreamMessageId, Map<K, V>>> read(StreamMultiReadArgs args) {
        return this.get(this.readAsync(args));
    }

    @Override
    public RFuture<Map<String, Map<StreamMessageId, Map<K, V>>>> readAsync(StreamMultiReadArgs args) {
        StreamMultiReadParams rp = (StreamMultiReadParams)args;
        ArrayList<Object> params = new ArrayList<Object>();
        if (rp.getCount() > 0) {
            params.add("COUNT");
            params.add(rp.getCount());
        }
        if (rp.getTimeout() != null) {
            params.add("BLOCK");
            params.add(rp.getTimeout().toMillis());
        }
        params.add("STREAMS");
        params.add(this.getRawName());
        params.addAll(rp.getOffsets().keySet());
        params.add(rp.getId1());
        for (StreamMessageId nextId : rp.getOffsets().values()) {
            params.add(nextId.toString());
        }
        if (rp.getTimeout() != null) {
            return this.commandExecutor.readAsync(this.getRawName(), this.codec, this.getServiceManager().getXReadBlockingCommand(), params.toArray());
        }
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, this.getServiceManager().getXReadCommand(), params.toArray());
    }

    @Override
    public Map<StreamMessageId, Map<K, V>> read(StreamReadArgs args) {
        return this.get(this.readAsync(args));
    }

    @Override
    public RFuture<Map<StreamMessageId, Map<K, V>>> readAsync(StreamReadArgs args) {
        StreamReadParams rp = (StreamReadParams)args;
        ArrayList<Object> params = new ArrayList<Object>();
        if (rp.getCount() > 0) {
            params.add("COUNT");
            params.add(rp.getCount());
        }
        if (rp.getTimeout() != null) {
            params.add("BLOCK");
            params.add(rp.getTimeout().toMillis());
        }
        params.add("STREAMS");
        params.add(this.getRawName());
        params.add(rp.getId1());
        if (rp.getTimeout() != null) {
            return this.commandExecutor.readAsync(this.getRawName(), this.codec, this.getServiceManager().getXReadBlockingSingleCommand(), params.toArray());
        }
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, this.getServiceManager().getXReadSingleCommand(), params.toArray());
    }

    @Override
    public StreamMessageId add(StreamAddArgs<K, V> args) {
        return this.get(this.addAsync(args));
    }

    @Override
    public void add(StreamMessageId id, StreamAddArgs<K, V> args) {
        this.get(this.addAsync(id, args));
    }

    @Override
    public RFuture<StreamMessageId> addAsync(StreamAddArgs<K, V> args) {
        return this.addCustomAsync(null, args);
    }

    @Override
    public RFuture<Void> addAsync(StreamMessageId id, StreamAddArgs<K, V> args) {
        return this.addCustomAsync(id, args);
    }

    public <R> RFuture<R> addCustomAsync(StreamMessageId id, StreamAddArgs<K, V> args) {
        StreamAddParams pps = (StreamAddParams)args;
        LinkedList<Object> params = new LinkedList<Object>();
        params.add(this.getRawName());
        if (pps.isNoMakeStream()) {
            params.add("NOMKSTREAM");
        }
        if (pps.getMaxLen() > 0) {
            params.add("MAXLEN");
            if (!pps.isTrimStrict()) {
                params.add("~");
            }
            params.add(pps.getMaxLen());
        }
        if (pps.getMinId() != null) {
            params.add("MINID");
            if (!pps.isTrimStrict()) {
                params.add("~");
            }
            params.add(pps.getMinId());
        }
        if (pps.getLimit() > 0) {
            params.add("LIMIT");
            params.add(pps.getLimit());
        }
        if (id == null) {
            params.add("*");
        } else {
            params.add(id.toString());
        }
        for (Map.Entry t : pps.getEntries().entrySet()) {
            this.checkKey(t.getKey());
            this.checkValue(t.getValue());
            params.add(this.encodeMapKey(t.getKey()));
            params.add(this.encodeMapValue(t.getValue()));
        }
        if (id == null) {
            return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.XADD, params.toArray());
        }
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.XADD_VOID, params.toArray());
    }

    private <R> RFuture<R> addCustomAsync(StreamMessageId id, K key, V value, int trimLen, boolean trimStrict) {
        LinkedList<Object> params = new LinkedList<Object>();
        params.add(this.getRawName());
        if (trimLen > 0) {
            params.add("MAXLEN");
            if (!trimStrict) {
                params.add("~");
            }
            params.add(trimLen);
        }
        if (id == null) {
            params.add("*");
        } else {
            params.add(id.toString());
        }
        this.checkKey(key);
        this.checkValue(value);
        params.add(this.encodeMapKey(key));
        params.add(this.encodeMapValue(value));
        if (id == null) {
            return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.XADD, params.toArray());
        }
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.XADD_VOID, params.toArray());
    }

    @Override
    public RFuture<Map<StreamMessageId, Map<K, V>>> rangeAsync(int count, StreamMessageId startId, StreamMessageId endId) {
        LinkedList<Object> params = new LinkedList<Object>();
        params.add(this.getRawName());
        params.add(startId);
        params.add(endId);
        if (count > 0) {
            params.add("COUNT");
            params.add(count);
        }
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.XRANGE, params.toArray());
    }

    @Override
    public Map<StreamMessageId, Map<K, V>> range(int count, StreamMessageId startId, StreamMessageId endId) {
        return this.get(this.rangeAsync(count, startId, endId));
    }

    @Override
    public RFuture<Map<StreamMessageId, Map<K, V>>> rangeReversedAsync(int count, StreamMessageId startId, StreamMessageId endId) {
        LinkedList<Object> params = new LinkedList<Object>();
        params.add(this.getRawName());
        params.add(startId);
        params.add(endId);
        if (count > 0) {
            params.add("COUNT");
            params.add(count);
        }
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.XREVRANGE, params.toArray());
    }

    @Override
    public Map<StreamMessageId, Map<K, V>> rangeReversed(int count, StreamMessageId startId, StreamMessageId endId) {
        return this.get(this.rangeReversedAsync(count, startId, endId));
    }

    @Override
    public RFuture<Map<StreamMessageId, Map<K, V>>> rangeAsync(StreamMessageId startId, StreamMessageId endId) {
        return this.rangeAsync(0, startId, endId);
    }

    @Override
    public RFuture<Map<StreamMessageId, Map<K, V>>> rangeReversedAsync(StreamMessageId startId, StreamMessageId endId) {
        return this.rangeReversedAsync(0, startId, endId);
    }

    @Override
    public Map<StreamMessageId, Map<K, V>> range(StreamMessageId startId, StreamMessageId endId) {
        return this.range(0, startId, endId);
    }

    @Override
    public Map<StreamMessageId, Map<K, V>> rangeReversed(StreamMessageId startId, StreamMessageId endId) {
        return this.rangeReversed(0, startId, endId);
    }

    @Override
    public RFuture<Long> removeAsync(StreamMessageId ... ids) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(this.getRawName());
        params.addAll(Arrays.asList(ids));
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.XDEL, params.toArray());
    }

    @Override
    public long remove(StreamMessageId ... ids) {
        return this.get(this.removeAsync(ids));
    }

    @Override
    public RFuture<Void> removeGroupAsync(String groupName) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.XGROUP, "DESTROY", this.getRawName(), groupName);
    }

    @Override
    public void removeGroup(String groupName) {
        this.get(this.removeGroupAsync(groupName));
    }

    @Override
    public void createConsumer(String groupName, String consumerName) {
        this.get(this.createConsumerAsync(groupName, consumerName));
    }

    @Override
    public RFuture<Void> createConsumerAsync(String groupName, String consumerName) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.XGROUP, "CREATECONSUMER", this.getRawName(), groupName, consumerName);
    }

    @Override
    public RFuture<Long> removeConsumerAsync(String groupName, String consumerName) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.XGROUP_LONG, "DELCONSUMER", this.getRawName(), groupName, consumerName);
    }

    @Override
    public long removeConsumer(String groupName, String consumerName) {
        return this.get(this.removeConsumerAsync(groupName, consumerName));
    }

    @Override
    public RFuture<Void> updateGroupMessageIdAsync(String groupName, StreamMessageId id) {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.XGROUP, "SETID", this.getRawName(), groupName, id);
    }

    @Override
    public void updateGroupMessageId(String groupName, StreamMessageId id) {
        this.get(this.updateGroupMessageIdAsync(groupName, id));
    }

    @Override
    public StreamInfo<K, V> getInfo() {
        return this.get(this.getInfoAsync());
    }

    @Override
    public RFuture<StreamInfo<K, V>> getInfoAsync() {
        RedisCommand<Object> xinfoStream = new RedisCommand<Object>("XINFO", "STREAM", new ListMultiDecoder2(new StreamInfoDecoder(), new CodecDecoder(), new ObjectMapReplayDecoder(this.codec)));
        return this.commandExecutor.readAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, xinfoStream, this.getRawName());
    }

    @Override
    public List<StreamGroup> listGroups() {
        return this.get(this.listGroupsAsync());
    }

    @Override
    public RFuture<List<StreamGroup>> listGroupsAsync() {
        return this.commandExecutor.readAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.XINFO_GROUPS, this.getRawName());
    }

    @Override
    public List<StreamConsumer> listConsumers(String groupName) {
        return this.get(this.listConsumersAsync(groupName));
    }

    @Override
    public RFuture<List<StreamConsumer>> listConsumersAsync(String groupName) {
        return this.commandExecutor.readAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.XINFO_CONSUMERS, this.getRawName(), groupName);
    }

    @Override
    public RFuture<Map<StreamMessageId, Map<K, V>>> pendingRangeAsync(String groupName, StreamMessageId startId, StreamMessageId endId, int count) {
        return this.commandExecutor.evalReadAsync(this.getRawName(), this.codec, EVAL_XRANGE, "local pendingData = redis.call('xpending', KEYS[1], ARGV[1], ARGV[2], ARGV[3], ARGV[4]);local result = {}; for i = 1, #pendingData, 1 do local value = redis.call('xrange', KEYS[1], pendingData[i][1], pendingData[i][1]);table.insert(result, value[1]);end; return result;", Collections.singletonList(this.getRawName()), groupName, startId, endId, count);
    }

    @Override
    public RFuture<Map<StreamMessageId, Map<K, V>>> pendingRangeAsync(String groupName, String consumerName, StreamMessageId startId, StreamMessageId endId, int count) {
        return this.commandExecutor.evalReadAsync(this.getRawName(), this.codec, EVAL_XRANGE, "local pendingData = redis.call('xpending', KEYS[1], ARGV[1], ARGV[2], ARGV[3], ARGV[4], ARGV[5]);local result = {}; for i = 1, #pendingData, 1 do local value = redis.call('xrange', KEYS[1], pendingData[i][1], pendingData[i][1]);table.insert(result, value[1]);end; return result;", Collections.singletonList(this.getRawName()), groupName, startId, endId, count, consumerName);
    }

    @Override
    public RFuture<Map<StreamMessageId, Map<K, V>>> pendingRangeAsync(String groupName, StreamMessageId startId, StreamMessageId endId, long idleTime, TimeUnit idleTimeUnit, int count) {
        return this.commandExecutor.evalReadAsync(this.getRawName(), this.codec, EVAL_XRANGE, "local pendingData = redis.call('xpending', KEYS[1], ARGV[1], 'IDLE', ARGV[2], ARGV[3], ARGV[4], ARGV[5]);local result = {}; for i = 1, #pendingData, 1 do local value = redis.call('xrange', KEYS[1], pendingData[i][1], pendingData[i][1]);table.insert(result, value[1]);end; return result;", Collections.singletonList(this.getRawName()), groupName, idleTimeUnit.toMillis(idleTime), startId, endId, count);
    }

    @Override
    public RFuture<Map<StreamMessageId, Map<K, V>>> pendingRangeAsync(String groupName, String consumerName, StreamMessageId startId, StreamMessageId endId, long idleTime, TimeUnit idleTimeUnit, int count) {
        return this.commandExecutor.evalReadAsync(this.getRawName(), this.codec, EVAL_XRANGE, "local pendingData = redis.call('xpending', KEYS[1], ARGV[1], 'IDLE', ARGV[2], ARGV[3], ARGV[4], ARGV[5], ARGV[6]);local result = {}; for i = 1, #pendingData, 1 do local value = redis.call('xrange', KEYS[1], pendingData[i][1], pendingData[i][1]);table.insert(result, value[1]);end; return result;", Collections.singletonList(this.getRawName()), groupName, idleTimeUnit.toMillis(idleTime), startId, endId, count, consumerName);
    }

    @Override
    public Map<StreamMessageId, Map<K, V>> pendingRange(String groupName, StreamMessageId startId, StreamMessageId endId, long idleTime, TimeUnit idleTimeUnit, int count) {
        return this.get(this.pendingRangeAsync(groupName, startId, endId, idleTime, idleTimeUnit, count));
    }

    @Override
    public Map<StreamMessageId, Map<K, V>> pendingRange(String groupName, String consumerName, StreamMessageId startId, StreamMessageId endId, long idleTime, TimeUnit idleTimeUnit, int count) {
        return this.get(this.pendingRangeAsync(groupName, consumerName, startId, endId, idleTime, idleTimeUnit, count));
    }

    @Override
    public Map<StreamMessageId, Map<K, V>> pendingRange(String groupName, String consumerName, StreamMessageId startId, StreamMessageId endId, int count) {
        return this.get(this.pendingRangeAsync(groupName, consumerName, startId, endId, count));
    }

    @Override
    public Map<StreamMessageId, Map<K, V>> pendingRange(String groupName, StreamMessageId startId, StreamMessageId endId, int count) {
        return this.get(this.pendingRangeAsync(groupName, startId, endId, count));
    }

    @Override
    public long trim(StreamTrimArgs args) {
        return this.get(this.trimAsync(args));
    }

    @Override
    public RFuture<Long> trimAsync(StreamTrimArgs args) {
        return this.trimAsync(args, true);
    }

    private RFuture<Long> trimAsync(StreamTrimArgs args, boolean trimStrict) {
        StreamTrimParams pps = (StreamTrimParams)args;
        LinkedList<Object> params = new LinkedList<Object>();
        params.add(this.getRawName());
        if (pps.getMaxLen() != null) {
            params.add("MAXLEN");
            if (!trimStrict) {
                params.add("~");
            }
            params.add(pps.getMaxLen());
        }
        if (pps.getMinId() != null) {
            params.add("MINID");
            if (!trimStrict) {
                params.add("~");
            }
            params.add(pps.getMinId());
        }
        if (pps.getLimit() > 0) {
            params.add("LIMIT");
            params.add(pps.getLimit());
        }
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.XTRIM, params.toArray());
    }

    @Override
    public long trimNonStrict(StreamTrimArgs args) {
        return this.get(this.trimNonStrictAsync(args));
    }

    @Override
    public RFuture<Long> trimNonStrictAsync(StreamTrimArgs args) {
        return this.trimAsync(args, false);
    }

    @Override
    public RFuture<Integer> addListenerAsync(ObjectListener listener) {
        if (listener instanceof StreamAddListener) {
            return this.addListenerAsync("__keyevent@*:xadd", (StreamAddListener)listener, StreamAddListener::onAdd);
        }
        if (listener instanceof StreamRemoveListener) {
            return this.addListenerAsync("__keyevent@*:xdel", (StreamRemoveListener)listener, StreamRemoveListener::onRemove);
        }
        if (listener instanceof StreamCreateConsumerListener) {
            return this.addListenerAsync("__keyevent@*:xgroup-createconsumer", (StreamCreateConsumerListener)listener, StreamCreateConsumerListener::onCreateConsumer);
        }
        if (listener instanceof StreamRemoveConsumerListener) {
            return this.addListenerAsync("__keyevent@*:xgroup-delconsumer", (StreamRemoveConsumerListener)listener, StreamRemoveConsumerListener::onRemoveConsumer);
        }
        if (listener instanceof StreamCreateGroupListener) {
            return this.addListenerAsync("__keyevent@*:xgroup-create", (StreamCreateGroupListener)listener, StreamCreateGroupListener::onCreateGroup);
        }
        if (listener instanceof StreamRemoveGroupListener) {
            return this.addListenerAsync("__keyevent@*:xgroup-destroy", (StreamRemoveGroupListener)listener, StreamRemoveGroupListener::onRemoveGroup);
        }
        if (listener instanceof TrackingListener) {
            return this.addTrackingListenerAsync((TrackingListener)listener);
        }
        return super.addListenerAsync(listener);
    }

    @Override
    public int addListener(ObjectListener listener) {
        if (listener instanceof StreamAddListener) {
            return this.addListener("__keyevent@*:xadd", (StreamAddListener)listener, StreamAddListener::onAdd);
        }
        if (listener instanceof StreamRemoveListener) {
            return this.addListener("__keyevent@*:xdel", (StreamRemoveListener)listener, StreamRemoveListener::onRemove);
        }
        if (listener instanceof StreamCreateConsumerListener) {
            return this.addListener("__keyevent@*:xgroup-createconsumer", (StreamCreateConsumerListener)listener, StreamCreateConsumerListener::onCreateConsumer);
        }
        if (listener instanceof StreamRemoveConsumerListener) {
            return this.addListener("__keyevent@*:xgroup-delconsumer", (StreamRemoveConsumerListener)listener, StreamRemoveConsumerListener::onRemoveConsumer);
        }
        if (listener instanceof StreamCreateGroupListener) {
            return this.addListener("__keyevent@*:xgroup-create", (StreamCreateGroupListener)listener, StreamCreateGroupListener::onCreateGroup);
        }
        if (listener instanceof StreamRemoveGroupListener) {
            return this.addListener("__keyevent@*:xgroup-destroy", (StreamRemoveGroupListener)listener, StreamRemoveGroupListener::onRemoveGroup);
        }
        if (listener instanceof StreamTrimListener) {
            return this.addListener("__keyevent@*:xtrim", (StreamTrimListener)listener, StreamTrimListener::onTrim);
        }
        if (listener instanceof TrackingListener) {
            return this.addTrackingListener((TrackingListener)listener);
        }
        return super.addListener(listener);
    }

    @Override
    public void removeListener(int listenerId) {
        this.removeTrackingListener(listenerId);
        this.removeListener(listenerId, "__keyevent@*:xadd", "__keyevent@*:xdel", "__keyevent@*:xgroup-createconsumer", "__keyevent@*:xgroup-delconsumer", "__keyevent@*:xgroup-create", "__keyevent@*:xgroup-destroy", "__keyevent@*:xtrim");
        super.removeListener(listenerId);
    }

    @Override
    public RFuture<Void> removeListenerAsync(int listenerId) {
        RFuture<Void> f1 = this.removeTrackingListenerAsync(listenerId);
        RFuture<Void> f2 = this.removeListenerAsync(super.removeListenerAsync(listenerId), listenerId, "__keyevent@*:xadd", "__keyevent@*:xdel", "__keyevent@*:xgroup-createconsumer", "__keyevent@*:xgroup-delconsumer", "__keyevent@*:xgroup-create", "__keyevent@*:xgroup-destroy", "__keyevent@*:xtrim");
        return new CompletableFutureWrapper<Void>(CompletableFuture.allOf(f1.toCompletableFuture(), f2.toCompletableFuture()));
    }
}

