/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.actor.typed.internal;

import org.apache.pekko.actor.ActorPath;
import org.apache.pekko.actor.typed.Behavior;
import org.apache.pekko.actor.typed.BehaviorInterceptor;
import org.apache.pekko.actor.typed.LogOptions;
import org.apache.pekko.actor.typed.Signal;
import org.apache.pekko.actor.typed.TypedActorContext;
import org.apache.pekko.actor.typed.internal.LogMessagesInterceptor$;
import org.apache.pekko.annotation.InternalApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import scala.MatchError;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00055sA\u0002\n\u0014\u0011\u0003IrD\u0002\u0004\"'!\u0005\u0011D\t\u0005\u0006S\u0005!\ta\u000b\u0005\u0006Y\u0005!\t!\f\u0005\b\u0007\u0006\u0011\r\u0011\"\u0003E\u0011\u0019i\u0015\u0001)A\u0005\u000b\"9a*\u0001b\u0001\n\u0013!\u0005BB(\u0002A\u0003%QIB\u0003\"'\tI\u0002\f\u0003\u0005@\u0011\t\u0015\r\u0011\"\u0001[\u0011!Y\u0006B!A!\u0002\u0013\u0001\u0005\"B\u0015\t\t\u0003a\u0006bB0\t\u0005\u0004%I\u0001\u0019\u0005\u0007O\"\u0001\u000b\u0011B1\t\u000b!DA\u0011I5\t\u000buDA\u0011\t@\t\u000f\u0005M\u0001\u0002\"\u0003\u0002\u0016!9\u0011Q\b\u0005\u0005B\u0005}\u0012A\u0006'pO6+7o]1hKNLe\u000e^3sG\u0016\u0004Ho\u001c:\u000b\u0005Q)\u0012\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005Y9\u0012!\u0002;za\u0016$'B\u0001\r\u001a\u0003\u0015\t7\r^8s\u0015\tQ2$A\u0003qK.\\wN\u0003\u0002\u001d;\u00051\u0011\r]1dQ\u0016T\u0011AH\u0001\u0004_J<\u0007C\u0001\u0011\u0002\u001b\u0005\u0019\"A\u0006'pO6+7o]1hKNLe\u000e^3sG\u0016\u0004Ho\u001c:\u0014\u0005\u0005\u0019\u0003C\u0001\u0013(\u001b\u0005)#\"\u0001\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005!*#AB!osJ+g-\u0001\u0004=S:LGOP\u0002\u0001)\u0005y\u0012!B1qa2LXC\u0001\u00186)\tyc\b\u0005\u00031cM\u001aT\"A\u000b\n\u0005I*\"a\u0005\"fQ\u00064\u0018n\u001c:J]R,'oY3qi>\u0014\bC\u0001\u001b6\u0019\u0001!QAN\u0002C\u0002]\u0012\u0011\u0001V\t\u0003qm\u0002\"\u0001J\u001d\n\u0005i*#a\u0002(pi\"Lgn\u001a\t\u0003IqJ!!P\u0013\u0003\u0007\u0005s\u0017\u0010C\u0003@\u0007\u0001\u0007\u0001)\u0001\u0003paR\u001c\bC\u0001\u0019B\u0013\t\u0011UC\u0001\u0006M_\u001e|\u0005\u000f^5p]N\f!\u0003T8h\u001b\u0016\u001c8/Y4f)\u0016l\u0007\u000f\\1uKV\tQ\t\u0005\u0002G\u00176\tqI\u0003\u0002I\u0013\u0006!A.\u00198h\u0015\u0005Q\u0015\u0001\u00026bm\u0006L!\u0001T$\u0003\rM#(/\u001b8h\u0003MaunZ'fgN\fw-\u001a+f[Bd\u0017\r^3!\u0003EaunZ*jO:\fG\u000eV3na2\fG/Z\u0001\u0013\u0019><7+[4oC2$V-\u001c9mCR,\u0007\u0005\u000b\u0002\u0002#B\u0011!+V\u0007\u0002'*\u0011A+G\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001,T\u0005-Ie\u000e^3s]\u0006d\u0017\t]5)\u0005\u0001\t6C\u0001\u0005Z!\u0011\u0001\u0014gO\u001e\u0016\u0003\u0001\u000bQa\u001c9ug\u0002\"\"!\u00180\u0011\u0005\u0001B\u0001\"B \f\u0001\u0004\u0001\u0015A\u00027pO\u001e,'/F\u0001b!\t\u0011W-D\u0001d\u0015\t!W$A\u0003tY\u001a$$.\u0003\u0002gG\n1Aj\\4hKJ\fq\u0001\\8hO\u0016\u0014\b%A\u0007be>,h\u000e\u001a*fG\u0016Lg/\u001a\u000b\u0005U6\u0014H\u000fE\u00021WnJ!\u0001\\\u000b\u0003\u0011\t+\u0007.\u0019<j_JDQA\u001c\bA\u0002=\f1a\u0019;y!\r\u0001\u0004oO\u0005\u0003cV\u0011\u0011\u0003V=qK\u0012\f5\r^8s\u0007>tG/\u001a=u\u0011\u0015\u0019h\u00021\u0001<\u0003\ri7o\u001a\u0005\u0006k:\u0001\rA^\u0001\u0007i\u0006\u0014x-\u001a;\u0011\u0007]T8H\u0004\u00021q&\u0011\u00110F\u0001\u0014\u0005\u0016D\u0017M^5pe&sG/\u001a:dKB$xN]\u0005\u0003wr\u0014QBU3dK&4X\rV1sO\u0016$(BA=\u0016\u00031\t'o\\;oINKwM\\1m)\u0019Qw0!\u0001\u0002\f!)an\u0004a\u0001_\"9\u00111A\bA\u0002\u0005\u0015\u0011AB:jO:\fG\u000eE\u00021\u0003\u000fI1!!\u0003\u0016\u0005\u0019\u0019\u0016n\u001a8bY\"1Qo\u0004a\u0001\u0003\u001b\u0001Ba^A\bw%\u0019\u0011\u0011\u0003?\u0003\u0019MKwM\\1m)\u0006\u0014x-\u001a;\u0002\u00071|w\r\u0006\u0005\u0002\u0018\u0005u\u0011QGA\u001d!\r!\u0013\u0011D\u0005\u0004\u00037)#\u0001B+oSRDq!a\b\u0011\u0001\u0004\t\t#\u0001\u0005uK6\u0004H.\u0019;f!\u0011\t\u0019#!\r\u000f\t\u0005\u0015\u0012Q\u0006\t\u0004\u0003O)SBAA\u0015\u0015\r\tYCK\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005=R%\u0001\u0004Qe\u0016$WMZ\u0005\u0004\u0019\u0006M\"bAA\u0018K!1\u0011q\u0007\tA\u0002m\nq\"\\3tg\u0006<Wm\u0014:TS\u001et\u0017\r\u001c\u0005\u0007\u0003w\u0001\u0002\u0019A8\u0002\u000f\r|g\u000e^3yi\u00061\u0011n]*b[\u0016$B!!\u0011\u0002HA\u0019A%a\u0011\n\u0007\u0005\u0015SEA\u0004C_>dW-\u00198\t\r\u0005%\u0013\u00031\u0001Z\u0003\u0015yG\u000f[3sQ\tA\u0011\u000b")
@InternalApi
public final class LogMessagesInterceptor
extends BehaviorInterceptor<Object, Object> {
    private final LogOptions opts;
    private final Logger logger;

    public static <T> BehaviorInterceptor<T, T> apply(LogOptions logOptions) {
        return LogMessagesInterceptor$.MODULE$.apply(logOptions);
    }

    public LogOptions opts() {
        return this.opts;
    }

    private Logger logger() {
        return this.logger;
    }

    @Override
    public Behavior<Object> aroundReceive(TypedActorContext<Object> ctx, Object msg, BehaviorInterceptor.ReceiveTarget<Object> target) {
        this.log(LogMessagesInterceptor$.MODULE$.org$apache$pekko$actor$typed$internal$LogMessagesInterceptor$$LogMessageTemplate(), msg, ctx);
        return target.apply(ctx, msg);
    }

    @Override
    public Behavior<Object> aroundSignal(TypedActorContext<Object> ctx, Signal signal, BehaviorInterceptor.SignalTarget<Object> target) {
        this.log(LogMessagesInterceptor$.MODULE$.org$apache$pekko$actor$typed$internal$LogMessagesInterceptor$$LogSignalTemplate(), signal, ctx);
        return target.apply(ctx, signal);
    }

    private void log(String template, Object messageOrSignal, TypedActorContext<Object> context) {
        if (this.opts().enabled()) {
            ActorPath selfPath = context.asScala().self().path();
            Level level = this.opts().level();
            if (Level.ERROR.equals(level)) {
                this.logger().error(template, (Object)selfPath, messageOrSignal);
                return;
            }
            if (Level.WARN.equals(level)) {
                this.logger().warn(template, (Object)selfPath, messageOrSignal);
                return;
            }
            if (Level.INFO.equals(level)) {
                this.logger().info(template, (Object)selfPath, messageOrSignal);
                return;
            }
            if (Level.DEBUG.equals(level)) {
                this.logger().debug(template, (Object)selfPath, messageOrSignal);
                return;
            }
            if (Level.TRACE.equals(level)) {
                this.logger().trace(template, (Object)selfPath, messageOrSignal);
                return;
            }
            throw new MatchError((Object)level);
        }
    }

    @Override
    public boolean isSame(BehaviorInterceptor<Object, Object> other) {
        if (other instanceof LogMessagesInterceptor) {
            LogOptions logOptions = ((LogMessagesInterceptor)other).opts();
            LogOptions logOptions2 = this.opts();
            return !(logOptions != null ? !logOptions.equals(logOptions2) : logOptions2 != null);
        }
        return false;
    }

    public LogMessagesInterceptor(LogOptions opts) {
        this.opts = opts;
        super(ClassTag$.MODULE$.Any());
        this.logger = opts.getLogger().orElse(LoggerFactory.getLogger(this.getClass()));
    }
}

