/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.mybatis.config;

import cn.sliew.carp.framework.mybatis.config.CarpMybatisConfig;
import com.baomidou.mybatisplus.autoconfigure.MybatisPlusProperties;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.core.handlers.MybatisEnumTypeHandler;
import com.baomidou.mybatisplus.core.toolkit.GlobalConfigUtils;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;
import org.apache.ibatis.logging.slf4j.Slf4jImpl;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

@Configuration
@MapperScan(sqlSessionFactoryRef="carpSqlSessionFactory", basePackages={"cn.sliew.carp.framework.dag.repository.mapper", "cn.sliew.carp.module.datasource.repository.mapper", "cn.sliew.carp.module.kubernetes.repository.mapper", "cn.sliew.carp.module.scheduler.repository.mapper", "cn.sliew.carp.module.security.core.repository.mapper"})
public class CarpDataSourceConfig {
    @Autowired
    private MybatisPlusInterceptor mybatisPlusInterceptor;

    @Primary
    @Bean(value={"carpDataSource"})
    @ConfigurationProperties(prefix="spring.datasource.carp")
    public DataSource carpDataSource() {
        return DataSourceBuilder.create().type(HikariDataSource.class).build();
    }

    @Primary
    @Bean(value={"carpTransactionManager"})
    public DataSourceTransactionManager carpTransactionManager() {
        return new DataSourceTransactionManager(this.carpDataSource());
    }

    @Primary
    @Bean(value={"carpSqlSessionFactory"})
    public SqlSessionFactory carpSqlSessionFactory() throws Exception {
        MybatisSqlSessionFactoryBean factoryBean = new MybatisSqlSessionFactoryBean();
        GlobalConfig globalConfig = GlobalConfigUtils.defaults();
        globalConfig.setMetaObjectHandler((MetaObjectHandler)new CarpMybatisConfig.CarpMetaHandler());
        MybatisPlusProperties props = new MybatisPlusProperties();
        props.setMapperLocations(new String[]{"classpath*:cn/sliew/carp/**/repository/**/*.xml"});
        factoryBean.setMapperLocations(props.resolveMapperLocations());
        MybatisConfiguration configuration = new MybatisConfiguration();
        configuration.setDefaultEnumTypeHandler(MybatisEnumTypeHandler.class);
        configuration.setMapUnderscoreToCamelCase(true);
        configuration.setLogImpl(Slf4jImpl.class);
        factoryBean.setConfiguration(configuration);
        factoryBean.setGlobalConfig(globalConfig);
        factoryBean.setDataSource(this.carpDataSource());
        factoryBean.setPlugins(new Interceptor[]{this.mybatisPlusInterceptor});
        return factoryBean.getObject();
    }
}

