/*
 * Decompiled with CFR 0.152.
 */
package cn.sliew.carp.framework.web.util;

import cn.hutool.core.net.NetUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.sliew.carp.framework.common.model.ResponseVO;
import cn.sliew.milky.common.util.JacksonUtil;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import org.springframework.http.HttpStatus;
import org.springframework.web.util.WebUtils;

public class WebUtil
extends WebUtils {
    public static void renderJson(HttpServletResponse response, ResponseVO responseVO) throws IOException {
        try (PrintWriter out = response.getWriter();){
            response.setStatus(HttpStatus.OK.value());
            response.setContentType("application/json");
            response.setCharacterEncoding(StandardCharsets.UTF_8.name());
            out.write(JacksonUtil.toJsonString((Object)responseVO));
            out.flush();
        }
    }

    public static String getClientIP(HttpServletRequest request, String ... otherHeaderNames) {
        String[] headers = new String[]{"X-Forwarded-For", "X-Real-IP", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_CLIENT_IP", "HTTP_X_FORWARDED_FOR"};
        if (ArrayUtil.isNotEmpty((Object[])otherHeaderNames)) {
            headers = (String[])ArrayUtil.addAll((Object[][])new String[][]{headers, otherHeaderNames});
        }
        return WebUtil.getClientIPByHeader(request, headers);
    }

    public static String getClientIPByHeader(HttpServletRequest request, String ... headerNames) {
        String ip;
        for (String header : headerNames) {
            ip = request.getHeader(header);
            if (NetUtil.isUnknown((String)ip)) continue;
            return NetUtil.getMultistageReverseProxyIp((String)ip);
        }
        ip = request.getRemoteAddr();
        return NetUtil.getMultistageReverseProxyIp((String)ip);
    }
}

