/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.sharding;

import com.typesafe.config.Config;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings$PassivationStrategySettings$;
import org.apache.pekko.cluster.singleton.ClusterSingletonManagerSettings;
import org.apache.pekko.cluster.singleton.ClusterSingletonManagerSettings$;
import org.apache.pekko.coordination.lease.LeaseUsageSettings;
import org.apache.pekko.util.Helpers$;
import org.apache.pekko.util.JavaDurationConverters;
import org.apache.pekko.util.JavaDurationConverters$;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;

public final class ClusterShardingSettings$ {
    public static ClusterShardingSettings$ MODULE$;
    private final String StateStoreModePersistence;
    private final String StateStoreModeDData;
    @InternalApi
    private final String RememberEntitiesStoreCustom;
    @InternalApi
    private final String RememberEntitiesStoreDData;
    @InternalApi
    private final String RememberEntitiesStoreEventsourced;

    static {
        new ClusterShardingSettings$();
    }

    public String StateStoreModePersistence() {
        return this.StateStoreModePersistence;
    }

    public String StateStoreModeDData() {
        return this.StateStoreModeDData;
    }

    public String RememberEntitiesStoreCustom() {
        return this.RememberEntitiesStoreCustom;
    }

    public String RememberEntitiesStoreDData() {
        return this.RememberEntitiesStoreDData;
    }

    public String RememberEntitiesStoreEventsourced() {
        return this.RememberEntitiesStoreEventsourced;
    }

    public ClusterShardingSettings apply(ActorSystem system) {
        return this.apply(system.settings().config().getConfig("pekko.cluster.sharding"));
    }

    /*
     * WARNING - void declaration
     */
    public ClusterShardingSettings apply(Config config) {
        None$ none$;
        ClusterShardingSettings.TuningParameters tuningParameters = new ClusterShardingSettings.TuningParameters(new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("coordinator-failure-backoff", TimeUnit.MILLISECONDS))).millis(), new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("retry-interval", TimeUnit.MILLISECONDS))).millis(), config.getInt("buffer-size"), new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("handoff-timeout", TimeUnit.MILLISECONDS))).millis(), new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("shard-start-timeout", TimeUnit.MILLISECONDS))).millis(), new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("shard-failure-backoff", TimeUnit.MILLISECONDS))).millis(), new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("entity-restart-backoff", TimeUnit.MILLISECONDS))).millis(), new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("rebalance-interval", TimeUnit.MILLISECONDS))).millis(), config.getInt("snapshot-after"), config.getInt("keep-nr-of-batches"), config.getInt("least-shard-allocation-strategy.rebalance-threshold"), config.getInt("least-shard-allocation-strategy.max-simultaneous-rebalance"), new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("waiting-for-state-timeout", TimeUnit.MILLISECONDS))).millis(), new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("updating-state-timeout", TimeUnit.MILLISECONDS))).millis(), config.getString("entity-recovery-strategy"), new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("entity-recovery-constant-rate-strategy.frequency", TimeUnit.MILLISECONDS))).millis(), config.getInt("entity-recovery-constant-rate-strategy.number-of-entities"), ClusterShardingSettings$.configMajorityPlus$1("coordinator-state.write-majority-plus", config), ClusterShardingSettings$.configMajorityPlus$1("coordinator-state.read-majority-plus", config), config.getInt("least-shard-allocation-strategy.rebalance-absolute-limit"), config.getDouble("least-shard-allocation-strategy.rebalance-relative-limit"));
        ClusterSingletonManagerSettings coordinatorSingletonSettings = ClusterSingletonManagerSettings$.MODULE$.apply(config.getConfig("coordinator-singleton"));
        ClusterShardingSettings.PassivationStrategySettings passivationStrategySettings = ClusterShardingSettings$PassivationStrategySettings$.MODULE$.fromSharding(config);
        String string = config.getString("use-lease");
        if (string.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            void asScala$extension_$this;
            Duration duration = JavaDurationConverters$.MODULE$.JavaDurationOps(config.getDuration("lease-retry-interval"));
            if (JavaDurationConverters.JavaDurationOps$.MODULE$ == null) {
                throw null;
            }
            none$ = new Some((Object)new LeaseUsageSettings(string, Duration$.MODULE$.fromNanos(asScala$extension_$this.toNanos())));
        }
        None$ lease = none$;
        return new ClusterShardingSettings(this.roleOption(config.getString("role")), config.getBoolean("remember-entities"), config.getString("journal-plugin-id"), config.getString("snapshot-plugin-id"), config.getString("state-store-mode"), config.getString("remember-entities-store"), passivationStrategySettings, new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("shard-region-query-timeout", TimeUnit.MILLISECONDS))).millis(), tuningParameters, config.getBoolean("coordinator-singleton-role-override"), coordinatorSingletonSettings, (Option<LeaseUsageSettings>)lease);
    }

    public ClusterShardingSettings create(ActorSystem system) {
        return this.apply(system);
    }

    public ClusterShardingSettings create(Config config) {
        return this.apply(config);
    }

    public Option<String> roleOption(String role) {
        String string = role;
        String string2 = "";
        if (string != null && string.equals(string2)) {
            return None$.MODULE$;
        }
        return Option$.MODULE$.apply((Object)role);
    }

    private static final int configMajorityPlus$1(String p, Config config$1) {
        String string = Helpers$.MODULE$.toRootLowerCase(config$1.getString(p));
        if ("all".equals(string)) {
            return Integer.MAX_VALUE;
        }
        return config$1.getInt(p);
    }

    private ClusterShardingSettings$() {
        MODULE$ = this;
        this.StateStoreModePersistence = "persistence";
        this.StateStoreModeDData = "ddata";
        this.RememberEntitiesStoreCustom = "custom";
        this.RememberEntitiesStoreDData = "ddata";
        this.RememberEntitiesStoreEventsourced = "eventsourced";
    }
}

