/*
 * Decompiled with CFR 0.152.
 */
package feign.micrometer;

import feign.Request;
import feign.RequestTemplate;
import feign.Response;
import feign.micrometer.MetricName;
import feign.micrometer.MetricTagResolver;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;

abstract class BaseMeteredClient {
    protected final MeterRegistry meterRegistry;
    protected final MetricName metricName;
    protected final MetricTagResolver metricTagResolver;

    public BaseMeteredClient(MeterRegistry meterRegistry, MetricName metricName, MetricTagResolver metricTagResolver) {
        this.meterRegistry = meterRegistry;
        this.metricName = metricName;
        this.metricTagResolver = metricTagResolver;
    }

    protected void countResponseCode(Request request, Response response, Request.Options options, int responseStatus, Exception e) {
        Tag[] extraTags = this.extraTags(request, response, options, e);
        RequestTemplate template = request.requestTemplate();
        Tags allTags = this.metricTagResolver.tag(template.methodMetadata(), template.feignTarget(), e, Tag.of((String)"http_status", (String)String.valueOf(responseStatus)), Tag.of((String)"status_group", (String)(responseStatus / 100 + "xx")), Tag.of((String)"http_method", (String)template.methodMetadata().template().method()), Tag.of((String)"uri", (String)template.methodMetadata().template().path())).and(extraTags);
        this.meterRegistry.counter(this.metricName.name("http_response_code"), (Iterable)allTags).increment();
    }

    protected Timer createTimer(Request request, Response response, Request.Options options, Exception e) {
        RequestTemplate template = request.requestTemplate();
        Tags allTags = this.metricTagResolver.tag(template.methodMetadata(), template.feignTarget(), e, Tag.of((String)"uri", (String)template.methodMetadata().template().path())).and(this.extraTags(request, response, options, e));
        return this.meterRegistry.timer(this.metricName.name(e), (Iterable)allTags);
    }

    protected Tag[] extraTags(Request request, Response response, Request.Options options, Exception e) {
        return MetricTagResolver.EMPTY_TAGS_ARRAY;
    }
}

