/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.logbook.core;

import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.zalando.logbook.BodyReplacer;
import org.zalando.logbook.HttpMessage;
import org.zalando.logbook.core.Conditions;

@API(status=API.Status.STABLE)
public final class BodyReplacers {
    private BodyReplacers() {
    }

    @API(status=API.Status.MAINTAINED)
    public static <T extends HttpMessage> BodyReplacer<T> defaultValue() {
        return BodyReplacer.composite((BodyReplacer[])new BodyReplacer[]{BodyReplacers.binary(), BodyReplacers.multipart(), BodyReplacers.stream()});
    }

    @API(status=API.Status.MAINTAINED)
    public static <T extends HttpMessage> BodyReplacer<T> binary() {
        Predicate contentTypes = Conditions.contentType("application/octet-stream", "application/pdf", "application/vnd.ms-excel", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "application/msword", "application/vnd.openxmlformats-officedocument.wordprocessingml.document", "application/vnd.ms-powerpoint", "application/vnd.openxmlformats-officedocument.presentationml.presentation", "audio/*", "image/*", "video/*");
        return BodyReplacers.replaceBody(contentTypes, "<binary>");
    }

    @API(status=API.Status.MAINTAINED)
    public static <T extends HttpMessage> BodyReplacer<T> multipart() {
        return BodyReplacers.replaceBody(Conditions.contentType("multipart/*", new String[0]), "<multipart>");
    }

    @API(status=API.Status.MAINTAINED)
    public static <T extends HttpMessage> BodyReplacer<T> stream() {
        Predicate contentTypes = Conditions.contentType("application/json-seq", "application/x-json-stream", "application/stream+json", "text/event-stream", "application/x-ndjson");
        return BodyReplacers.replaceBody(contentTypes, "<stream>");
    }

    public static <T extends HttpMessage> BodyReplacer<T> replaceBody(Predicate<T> predicate, String replacement) {
        return message -> predicate.test(message) ? replacement : null;
    }
}

