/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.http.javadsl.marshallers.jackson;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.core.StreamWriteConstraints;
import com.fasterxml.jackson.core.util.BufferRecycler;
import com.fasterxml.jackson.core.util.JsonRecyclerPools;
import com.fasterxml.jackson.core.util.RecyclerPool;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.IOException;
import org.apache.pekko.http.javadsl.marshalling.Marshaller;
import org.apache.pekko.http.javadsl.model.HttpEntity;
import org.apache.pekko.http.javadsl.model.MediaType;
import org.apache.pekko.http.javadsl.model.MediaTypes;
import org.apache.pekko.http.javadsl.model.RequestEntity;
import org.apache.pekko.http.javadsl.unmarshalling.Unmarshaller;
import org.apache.pekko.http.scaladsl.model.ErrorInfo;
import org.apache.pekko.http.scaladsl.model.ExceptionWithErrorInfo;
import org.apache.pekko.util.ByteString;

public class Jackson {
    private static final ObjectMapper defaultObjectMapper = Jackson.createMapper().enable(new MapperFeature[]{MapperFeature.SORT_PROPERTIES_ALPHABETICALLY});

    public static <T> Marshaller<T, RequestEntity> marshaller() {
        return Jackson.marshaller(defaultObjectMapper);
    }

    public static <T> Marshaller<T, RequestEntity> marshaller(ObjectMapper objectMapper) {
        return Marshaller.wrapEntity(object -> Jackson.toJSON(objectMapper, object), (Marshaller)Marshaller.stringToEntity(), (MediaType)MediaTypes.APPLICATION_JSON);
    }

    public static <T> Unmarshaller<ByteString, T> byteStringUnmarshaller(Class<T> clazz) {
        return Jackson.byteStringUnmarshaller(defaultObjectMapper, clazz);
    }

    public static <T> Unmarshaller<HttpEntity, T> unmarshaller(Class<T> clazz) {
        return Jackson.unmarshaller(defaultObjectMapper, clazz);
    }

    public static <T> Unmarshaller<HttpEntity, T> unmarshaller(ObjectMapper objectMapper, Class<T> clazz) {
        return Unmarshaller.forMediaType((MediaType)MediaTypes.APPLICATION_JSON, (Unmarshaller)Unmarshaller.entityToString()).thenApply(string -> Jackson.fromJSON(objectMapper, string, clazz));
    }

    public static <T> Unmarshaller<ByteString, T> byteStringUnmarshaller(ObjectMapper objectMapper, Class<T> clazz) {
        return Unmarshaller.sync(byteString -> Jackson.fromJSON(objectMapper, byteString.utf8String(), clazz));
    }

    private static String toJSON(ObjectMapper objectMapper, Object object) {
        try {
            return objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new IllegalArgumentException("Cannot marshal to JSON: " + object, jsonProcessingException);
        }
    }

    private static <T> T fromJSON(ObjectMapper objectMapper, String string, Class<T> clazz) {
        try {
            return (T)objectMapper.readerFor(clazz).readValue(string);
        }
        catch (IOException iOException) {
            throw new JacksonUnmarshallingException(clazz, iOException);
        }
    }

    private static ObjectMapper createMapper() {
        return Jackson.createMapper(ConfigFactory.load().getConfig("pekko.http.marshallers.jackson"));
    }

    static ObjectMapper createMapper(Config config) {
        StreamReadConstraints streamReadConstraints = StreamReadConstraints.builder().maxNestingDepth(config.getInt("read.max-nesting-depth")).maxNumberLength(config.getInt("read.max-number-length")).maxStringLength(config.getInt("read.max-string-length")).maxNameLength(config.getInt("read.max-name-length")).maxDocumentLength(config.getLong("read.max-document-length")).build();
        StreamWriteConstraints streamWriteConstraints = StreamWriteConstraints.builder().maxNestingDepth(config.getInt("write.max-nesting-depth")).build();
        JsonFactory jsonFactory = JsonFactory.builder().streamReadConstraints(streamReadConstraints).streamWriteConstraints(streamWriteConstraints).recyclerPool(Jackson.getBufferRecyclerPool(config)).build();
        return new JsonMapper(jsonFactory);
    }

    private static RecyclerPool<BufferRecycler> getBufferRecyclerPool(Config config) {
        String string;
        switch (string = config.getString("buffer-recycler.pool-instance")) {
            case "thread-local": {
                return JsonRecyclerPools.threadLocalPool();
            }
            case "lock-free": {
                return JsonRecyclerPools.newLockFreePool();
            }
            case "shared-lock-free": {
                return JsonRecyclerPools.sharedLockFreePool();
            }
            case "concurrent-deque": {
                return JsonRecyclerPools.newConcurrentDequePool();
            }
            case "shared-concurrent-deque": {
                return JsonRecyclerPools.sharedConcurrentDequePool();
            }
            case "bounded": {
                return JsonRecyclerPools.newBoundedPool((int)config.getInt("buffer-recycler.bounded-pool-size"));
            }
        }
        throw new IllegalArgumentException("Unknown recycler-pool: " + string);
    }

    public static class JacksonUnmarshallingException
    extends ExceptionWithErrorInfo {
        public JacksonUnmarshallingException(Class<?> clazz, IOException iOException) {
            super(new ErrorInfo("Cannot unmarshal JSON as " + clazz.getSimpleName(), iOException.getMessage()), (Throwable)iOException);
        }
    }
}

