/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ClassicActorSystemProvider;
import org.apache.pekko.actor.Deploy$;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.actor.Extension;
import org.apache.pekko.actor.ExtensionId;
import org.apache.pekko.actor.Props;
import org.apache.pekko.actor.Scope;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.annotation.InternalStableApi;
import org.apache.pekko.event.LogSource$;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.japi.Pair;
import org.apache.pekko.persistence.Persistence$;
import org.apache.pekko.persistence.PersistenceSettings;
import org.apache.pekko.persistence.RecoveryPermitter$;
import org.apache.pekko.persistence.StashOverflowStrategy;
import org.apache.pekko.persistence.StashOverflowStrategyConfigurator;
import org.apache.pekko.persistence.journal.EventAdapters;
import org.apache.pekko.persistence.journal.EventAdapters$;
import org.apache.pekko.persistence.journal.IdentityEventAdapters$;
import org.apache.pekko.routing.RouterConfig;
import org.apache.pekko.util.Collections;
import org.apache.pekko.util.Reflect$;
import org.apache.pekko.util.ccompat.package;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\r\u001dx!\u0002-Z\u0011\u0003\u0011g!\u00023Z\u0011\u0003)\u0007BB?\u0002\t\u0003\u0019\t\u0007C\u0004\u0004d\u0005!\te!\u001a\t\u000f\r\r\u0014\u0001\"\u0011\u0004p!91qA\u0001\u0005\u0002\re\u0004bBB?\u0003\u0011\u00051q\u0010\u0004\b\u0003W\u000b\u0001)WAW\u0011)\tYl\u0002BK\u0002\u0013\u0005\u0011Q\u0018\u0005\u000b\u0003\u000b<!\u0011#Q\u0001\n\u0005}\u0006BCAd\u000f\tU\r\u0011\"\u0001\u0002J\"Q\u0011q[\u0004\u0003\u0012\u0003\u0006I!a3\t\u0015\u0005\u001drA!f\u0001\n\u0003\tI\u0003\u0003\u0006\u0002>\u001d\u0011\t\u0012)A\u0005\u0003WAa!`\u0004\u0005\u0002\u0005e\u0007\"C8\b\u0011\u000b\u0007I\u0011AA!\u0011%\t)oBA\u0001\n\u0003\t9\u000fC\u0005\u0002p\u001e\t\n\u0011\"\u0001\u0002r\"I!QA\u0004\u0012\u0002\u0013\u0005!q\u0001\u0005\n\u0005\u00179\u0011\u0013!C\u0001\u0005\u001bA\u0011B!\u0005\b\u0003\u0003%\t%a\u0005\t\u0013\tMq!!A\u0005\u0002\tU\u0001\"\u0003B\u000f\u000f\u0005\u0005I\u0011\u0001B\u0010\u0011%\u0011YcBA\u0001\n\u0003\u0012i\u0003C\u0005\u0003<\u001d\t\t\u0011\"\u0001\u0003>!I!qI\u0004\u0002\u0002\u0013\u0005#\u0011\n\u0005\n\u0005\u0017:\u0011\u0011!C!\u0005\u001bB\u0011Ba\u0014\b\u0003\u0003%\tE!\u0015\b\u0015\r\u0005\u0015!!A\t\u0002e\u001b\u0019I\u0002\u0006\u0002,\u0006\t\t\u0011#\u0001Z\u0007\u000bCa!`\u000f\u0005\u0002\rM\u0005\"\u0003B&;\u0005\u0005IQ\tB'\u0011%\u0019)*HA\u0001\n\u0003\u001b9\nC\u0005\u0004 v\t\t\u0011\"!\u0004\"\"I11W\u000f\u0002\u0002\u0013%1Q\u0017\u0005\n\u0007{\u000b!\u0019!C\u0001\u0003'A\u0001ba0\u0002A\u0003%\u0011Q\u0003\u0005\n\u0007\u0003\f!\u0019!C\u0001\u0003'A\u0001ba1\u0002A\u0003%\u0011Q\u0003\u0005\t\u0007\u000b\fA\u0011A.\u0004H\"A1Q[\u0001\u0005\u0002m\u001b9\u000eC\u0004\u0004`\u0006!Ia!9\u0007\t\u0011L\u0006a\u001d\u0005\to*\u0012)\u0019!C\u0001q\"AAP\u000bB\u0001B\u0003%\u0011\u0010C\u0003~U\u0011\u0005a\u0010C\u0004\u0002\u0002)\"I!a\u0001\t\u0013\u0005E!F1A\u0005\n\u0005M\u0001\u0002CA\u0013U\u0001\u0006I!!\u0006\t\u0013\u0005\u001d\"F1A\u0005\n\u0005%\u0002\u0002CA\u001fU\u0001\u0006I!a\u000b\t\u0015\u0005}\"F1A\u0005\u0002m\u000b\t\u0005\u0003\u0005\u0002J)\u0002\u000b\u0011BA\"\u0011)\tIF\u000bEC\u0002\u0013%\u00111\u0003\u0005\u000b\u00037R\u0003R1A\u0005\n\u0005M\u0001BCA/U!\u0015\r\u0011\"\u0001\u0002`!I\u0011q\r\u0016C\u0002\u0013\u0005\u0011\u0011\u000e\u0005\t\u0003cR\u0003\u0015!\u0003\u0002l!I\u00111\u000f\u0016C\u0002\u0013%\u0011Q\u000f\u0005\t\u0005+R\u0003\u0015!\u0003\u0002x!9!q\u000b\u0016\u0005\n\te\u0003b\u0002B5U\u0011%!1\u000e\u0005\b\u0005cRCQ\u0001B:\u0011\u001d\u0011\tH\u000bC\u0003\u0005sB\u0001B!\u001d+\t\u000bY&\u0011\u0011\u0005\t\u0005\u000fSCQA.\u0003\n\"Q!q\u0012\u0016\u0012\u0002\u0013\u00151L!\u0004\t\u0011\tE%\u0006\"\u0002\\\u0005'C\u0001Ba&+\t\u000bY&\u0011\u0014\u0005\u000b\u0005OS\u0013\u0013!C\u00037\n5\u0001\u0002\u0003BUU\u0011\u00151La+\t\u0015\t]&&%A\u0005\u0006m\u0013i\u0001C\u0004\u0003:*\"IAa/\t\u000f\tE'\u0006\"\u0003\u0003T\"9!\u0011\u001c\u0016\u0005\n\tm\u0007b\u0002BqU\u0011\u0005!1\u001d\u0005\b\u0005STC\u0011\u0002Bv\r\u0019\u0011\tP\u000b\u0003\u0003t\"Q!qM'\u0003\u0002\u0003\u0006I!!)\t\u0015\t\u0005WJ!A!\u0002\u0013\t\t\u000b\u0003\u0006\u0003F6\u0013\t\u0011)A\u0005\u0003WAa!`'\u0005\u0002\tU\bBB?N\t\u0003\u0019\t\u0001C\u0004\u0004\b5#\te!\u0003\t\u000f\r5!\u0006\"\u0002\u0003\u0016!91q\u0002\u0016\u0005\u0006\rE\u0001bBB\u000bU\u0011\u00151q\u0003\u0005\b\u0007wQCQAB\u001f\u0003-\u0001VM]:jgR,gnY3\u000b\u0005i[\u0016a\u00039feNL7\u000f^3oG\u0016T!\u0001X/\u0002\u000bA,7n[8\u000b\u0005y{\u0016AB1qC\u000eDWMC\u0001a\u0003\ry'oZ\u0002\u0001!\t\u0019\u0017!D\u0001Z\u0005-\u0001VM]:jgR,gnY3\u0014\u000b\u00051Gna\u0017\u0011\u0005\u001dTW\"\u00015\u000b\u0003%\fQa]2bY\u0006L!a\u001b5\u0003\r\u0005s\u0017PU3g!\ri\u0007O]\u0007\u0002]*\u0011qnW\u0001\u0006C\u000e$xN]\u0005\u0003c:\u00141\"\u0012=uK:\u001c\u0018n\u001c8JIB\u00111MK\n\u0004U\u0019$\bCA7v\u0013\t1hNA\u0005FqR,gn]5p]\u000611/_:uK6,\u0012!\u001f\t\u0003[jL!a\u001f8\u0003'\u0015CH/\u001a8eK\u0012\f5\r^8s'f\u001cH/Z7\u0002\u000fML8\u000f^3nA\u00051A(\u001b8jiz\"\"A]@\t\u000b]l\u0003\u0019A=\u0002\u00071|w-\u0006\u0002\u0002\u0006A!\u0011qAA\u0007\u001b\t\tIAC\u0002\u0002\fm\u000bQ!\u001a<f]RLA!a\u0004\u0002\n\tqAj\\4hS:<\u0017\tZ1qi\u0016\u0014\u0018a\u0006(p':\f\u0007o\u001d5piN#xN]3QYV<\u0017N\\%e+\t\t)\u0002\u0005\u0003\u0002\u0018\u0005\u0005RBAA\r\u0015\u0011\tY\"!\b\u0002\t1\fgn\u001a\u0006\u0003\u0003?\tAA[1wC&!\u00111EA\r\u0005\u0019\u0019FO]5oO\u0006Abj\\*oCB\u001c\bn\u001c;Ti>\u0014X\r\u00157vO&t\u0017\n\u001a\u0011\u0002\r\r|gNZ5h+\t\tY\u0003\u0005\u0003\u0002.\u0005eRBAA\u0018\u0015\u0011\t9#!\r\u000b\t\u0005M\u0012QG\u0001\tif\u0004Xm]1gK*\u0011\u0011qG\u0001\u0004G>l\u0017\u0002BA\u001e\u0003_\u0011aaQ8oM&<\u0017aB2p]\u001aLw\rI\u0001\u0012e\u0016\u001cwN^3ssB+'/\\5ui\u0016\u0014XCAA\"!\ri\u0017QI\u0005\u0004\u0003\u000fr'\u0001C!di>\u0014(+\u001a4\u0002%I,7m\u001c<fef\u0004VM]7jiR,'\u000f\t\u0015\u0004i\u00055\u0003\u0003BA(\u0003+j!!!\u0015\u000b\u0007\u0005M3,\u0001\u0006b]:|G/\u0019;j_:LA!a\u0016\u0002R\tY\u0011J\u001c;fe:\fG.\u00119j\u0003Y!WMZ1vYRTu.\u001e:oC2\u0004F.^4j]&#\u0017a\u00063fM\u0006,H\u000e^*oCB\u001c\bn\u001c;QYV<\u0017N\\%e\u0003\u0011\"WMZ1vYRLe\u000e^3s]\u0006d7\u000b^1tQ>3XM\u001d4m_^\u001cFO]1uK\u001eLXCAA1!\r\u0019\u00171M\u0005\u0004\u0003KJ&!F*uCNDwJ^3sM2|wo\u0015;sCR,w-_\u0001\tg\u0016$H/\u001b8hgV\u0011\u00111\u000e\t\u0004G\u00065\u0014bAA83\n\u0019\u0002+\u001a:tSN$XM\\2f'\u0016$H/\u001b8hg\u0006I1/\u001a;uS:<7\u000fI\u0001\u0012a2,x-\u001b8FqR,gn]5p]&#WCAA<!\u0019\tI(a\"\u0002\f6\u0011\u00111\u0010\u0006\u0005\u0003{\ny(\u0001\u0004bi>l\u0017n\u0019\u0006\u0005\u0003\u0003\u000b\u0019)\u0001\u0006d_:\u001cWO\u001d:f]RTA!!\"\u0002\u001e\u0005!Q\u000f^5m\u0013\u0011\tI)a\u001f\u0003\u001f\u0005#x.\\5d%\u00164WM]3oG\u0016\u0004\u0002\"!$\u0002\u001c\u0006\u0005\u0016Q\u0015\b\u0005\u0003\u001f\u000b9\nE\u0002\u0002\u0012\"l!!a%\u000b\u0007\u0005U\u0015-\u0001\u0004=e>|GOP\u0005\u0004\u00033C\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0002\u001e\u0006}%aA'ba*\u0019\u0011\u0011\u00145\u0011\t\u00055\u00151U\u0005\u0005\u0003G\ty\n\u0005\u0003na\u0006\u001d\u0006cAAU\u000f9\u00111\r\u0001\u0002\r!2,x-\u001b8I_2$WM]\n\b\u000f\u0019$\u0018qVA[!\r9\u0017\u0011W\u0005\u0004\u0003gC'a\u0002)s_\u0012,8\r\u001e\t\u0004O\u0006]\u0016bAA]Q\na1+\u001a:jC2L'0\u00192mK\u0006a\u0011m\u0019;pe\u001a\u000b7\r^8ssV\u0011\u0011q\u0018\t\u0006O\u0006\u0005\u00171I\u0005\u0004\u0003\u0007D'!\u0003$v]\u000e$\u0018n\u001c81\u00035\t7\r^8s\r\u0006\u001cGo\u001c:zA\u0005A\u0011\rZ1qi\u0016\u00148/\u0006\u0002\u0002LB!\u0011QZAj\u001b\t\tyMC\u0002\u0002Rf\u000bqA[8ve:\fG.\u0003\u0003\u0002V\u0006='!D#wK:$\u0018\tZ1qi\u0016\u00148/A\u0005bI\u0006\u0004H/\u001a:tAQA\u00111\\Ap\u0003C\f\u0019\u000fE\u0002\u0002^\u001ei\u0011!\u0001\u0005\b\u0003ws\u0001\u0019AA`\u0011\u001d\t9M\u0004a\u0001\u0003\u0017Dq!a\n\u000f\u0001\u0004\tY#\u0001\u0003d_BLH\u0003CAn\u0003S\fY/!<\t\u0013\u0005m\u0006\u0003%AA\u0002\u0005}\u0006\"CAd!A\u0005\t\u0019AAf\u0011%\t9\u0003\u0005I\u0001\u0002\u0004\tY#\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005M(\u0006BA`\u0003k\\#!a>\u0011\t\u0005e(\u0011A\u0007\u0003\u0003wTA!!@\u0002\u0000\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003'B\u0017\u0002\u0002B\u0002\u0003w\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"A!\u0003+\t\u0005-\u0017Q_\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011yA\u000b\u0003\u0002,\u0005U\u0018!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0003\u0018A\u0019qM!\u0007\n\u0007\tm\u0001NA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0003\"\t\u001d\u0002cA4\u0003$%\u0019!Q\u00055\u0003\u0007\u0005s\u0017\u0010C\u0005\u0003*Y\t\t\u00111\u0001\u0003\u0018\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa\f\u0011\r\tE\"q\u0007B\u0011\u001b\t\u0011\u0019DC\u0002\u00036!\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011IDa\r\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005\u007f\u0011)\u0005E\u0002h\u0005\u0003J1Aa\u0011i\u0005\u001d\u0011un\u001c7fC:D\u0011B!\u000b\u0019\u0003\u0003\u0005\rA!\t\u0002\u0011!\f7\u000f[\"pI\u0016$\"Aa\u0006\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u0006\u0002\r\u0015\fX/\u00197t)\u0011\u0011yDa\u0015\t\u0013\t%2$!AA\u0002\t\u0005\u0012A\u00059mk\u001eLg.\u0012=uK:\u001c\u0018n\u001c8JI\u0002\nqD^3sS\u001aL(j\\;s]\u0006d\u0007\u000b\\;hS:\u001cuN\u001c4jO\u0016C\u0018n\u001d;t)\u0019\u0011YF!\u0019\u0003fA\u0019qM!\u0018\n\u0007\t}\u0003N\u0001\u0003V]&$\bb\u0002B2y\u0001\u0007\u00111F\u0001\ra2,x-\u001b8D_:4\u0017n\u001a\u0005\b\u0005Ob\u0004\u0019AAQ\u0003)\u0019wN\u001c4jOB\u000bG\u000f[\u0001!m\u0016\u0014\u0018NZ=T]\u0006\u00048\u000f[8u!2,x-\u001b8D_:4\u0017nZ#ySN$8\u000f\u0006\u0004\u0003\\\t5$q\u000e\u0005\b\u0005Gj\u0004\u0019AA\u0016\u0011\u001d\u00119'\u0010a\u0001\u0003C\u000b1\"\u00193baR,'o\u001d$peR!\u00111\u001aB;\u0011\u001d\u00119H\u0010a\u0001\u0003C\u000bqB[8ve:\fG\u000e\u00157vO&t\u0017\n\u001a\u000b\u0007\u0003\u0017\u0014YH! \t\u000f\t]t\b1\u0001\u0002\"\"9!qP A\u0002\u0005-\u0012a\u00056pkJt\u0017\r\u001c)mk\u001eLgnQ8oM&<G\u0003BAf\u0005\u0007CqA!\"A\u0001\u0004\t\u0019%\u0001\nk_V\u0014h.\u00197QYV<\u0017N\\!di>\u0014\u0018\u0001\u00056pkJt\u0017\r\\\"p]\u001aLwMR8s)\u0019\tYCa#\u0003\u000e\"9!qO!A\u0002\u0005\u0005\u0006\"\u0003B@\u0003B\u0005\t\u0019AA\u0016\u0003iQw.\u001e:oC2\u001cuN\u001c4jO\u001a{'\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003%\u0019wN\u001c4jO\u001a{'\u000f\u0006\u0003\u0002,\tU\u0005b\u0002BC\u0007\u0002\u0007\u00111I\u0001\u000bU>,(O\\1m\r>\u0014HCBA\"\u00057\u0013i\nC\u0004\u0003x\u0011\u0003\r!!)\t\u0013\t}D\t%AA\u0002\u0005-\u0002f\u0001#\u0003\"B!\u0011q\nBR\u0013\u0011\u0011)+!\u0015\u0003#%sG/\u001a:oC2\u001cF/\u00192mK\u0006\u0003\u0018.\u0001\u000bk_V\u0014h.\u00197G_J$C-\u001a4bk2$HEM\u0001\u0011g:\f\u0007o\u001d5piN#xN]3G_J$b!a\u0011\u0003.\nE\u0006b\u0002BX\r\u0002\u0007\u0011\u0011U\u0001\u0011g:\f\u0007o\u001d5piBcWoZ5o\u0013\u0012D\u0011Ba-G!\u0003\u0005\r!a\u000b\u0002)Mt\u0017\r]:i_R\u0004F.^4j]\u000e{gNZ5hQ\r1%\u0011U\u0001\u001bg:\f\u0007o\u001d5piN#xN]3G_J$C-\u001a4bk2$HEM\u0001\u0010a2,x-\u001b8I_2$WM\u001d$peRA\u0011q\u0015B_\u0005\u007f\u0013\u0019\rC\u0004\u0003h!\u0003\r!!)\t\u000f\t\u0005\u0007\n1\u0001\u0002\"\u0006aa-\u00197mE\u0006\u001c7\u000eU1uQ\"9!Q\u0019%A\u0002\u0005-\u0012\u0001E1eI&$\u0018n\u001c8bY\u000e{gNZ5hQ\rA%\u0011\u001a\t\u0005\u0005\u0017\u0014i-\u0004\u0002\u0002\u0000&!!qZA\u0000\u0005\u001d!\u0018-\u001b7sK\u000e\fAb\u0019:fCR,\u0007\u000b\\;hS:$b!a\u0011\u0003V\n]\u0007b\u0002B4\u0013\u0002\u0007\u0011\u0011\u0015\u0005\b\u0005GJ\u0005\u0019AA\u0016\u00039\u0019'/Z1uK\u0006#\u0017\r\u001d;feN$b!a3\u0003^\n}\u0007b\u0002B4\u0015\u0002\u0007\u0011\u0011\u0015\u0005\b\u0005\u000bT\u0005\u0019AA\u0016\u00035\u0001XM]:jgR,gnY3JIR!\u0011\u0011\u0015Bs\u0011\u001d\u00119o\u0013a\u0001\u0003\u0007\nq\u0002]3sg&\u001cH/\u001a8u\u0003\u000e$xN]\u0001\u0003S\u0012$B!!)\u0003n\"9!q\u001e'A\u0002\u0005\r\u0013a\u0001:fM\n9\u0002\u000b\\;hS:Du\u000e\u001c3fe\u0016CH/\u001a8tS>t\u0017\nZ\n\u0005\u001b\u001a\f)\u000b\u0006\u0005\u0003x\nm(Q B\u0000!\r\u0011I0T\u0007\u0002U!9!qM)A\u0002\u0005\u0005\u0006b\u0002Ba#\u0002\u0007\u0011\u0011\u0015\u0005\b\u0005\u000b\f\u0006\u0019AA\u0016)\u0019\u00119pa\u0001\u0004\u0006!9!q\r*A\u0002\u0005\u0005\u0006b\u0002Ba%\u0002\u0007\u0011\u0011U\u0001\u0010GJ,\u0017\r^3FqR,gn]5p]R!\u0011qUB\u0006\u0011\u001598\u000b1\u0001z\u00039qW/\u001c2fe>37\u000b\\5dKN\fQc\u001d7jG\u00164uN\u001d)feNL7\u000f^3oG\u0016LE\r\u0006\u0003\u0003\u0018\rM\u0001b\u0002Bq+\u0002\u0007\u0011\u0011U\u0001\fg2L7-\u001a*b]\u001e,7\u000f\u0006\u0003\u0004\u001a\r]\u0002CBB\u000e\u0007C\u0019)#\u0004\u0002\u0004\u001e)!1q\u0004B\u001a\u0003%IW.\\;uC\ndW-\u0003\u0003\u0004$\ru!AC%oI\u0016DX\rZ*fcB!1qEB\u0019\u001d\u0011\u0019Ic!\f\u000f\t\u0005E51F\u0005\u0002S&\u00191q\u00065\u0002\u000fA\f7m[1hK&!11GB\u001b\u0005\u0015\u0011\u0016M\\4f\u0015\r\u0019y\u0003\u001b\u0005\b\u0007s1\u0006\u0019\u0001B\f\u00039qW/\u001c2fe>3'+\u00198hKN\fabZ3u'2L7-\u001a*b]\u001e,7\u000f\u0006\u0003\u0004@\re\u0003CBB!\u0007\u0007\u001a9%\u0004\u0002\u0002\u0004&!1QIAB\u0005\u0011a\u0015n\u001d;\u0011\u0011\r%3qJB*\u0007'j!aa\u0013\u000b\u0007\r53,\u0001\u0003kCBL\u0017\u0002BB)\u0007\u0017\u0012A\u0001U1jeB!\u0011qCB+\u0013\u0011\u00199&!\u0007\u0003\u000f%sG/Z4fe\"91\u0011H,A\u0002\t]\u0001cA7\u0004^%\u00191q\f8\u0003'\u0015CH/\u001a8tS>t\u0017\n\u001a)s_ZLG-\u001a:\u0015\u0003\t\f1aZ3u)\r\u00118q\r\u0005\u0007o\u000e\u0001\ra!\u001b\u0011\u00075\u001cY'C\u0002\u0004n9\u00141\"Q2u_J\u001c\u0016p\u001d;f[R\u0019!o!\u001d\t\r]$\u0001\u0019AB:!\ri7QO\u0005\u0004\u0007or'AG\"mCN\u001c\u0018nY!di>\u00148+_:uK6\u0004&o\u001c<jI\u0016\u0014Hc\u0001:\u0004|!)q/\u0002a\u0001s\u00061An\\8lkB,\"!!+\u0002\u0019AcWoZ5o\u0011>dG-\u001a:\u0011\u0007\u0005uWdE\u0003\u001e\u0007\u000f\u000b)\f\u0005\u0007\u0004\n\u000e=\u0015qXAf\u0003W\tY.\u0004\u0002\u0004\f*\u00191Q\u00125\u0002\u000fI,h\u000e^5nK&!1\u0011SBF\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u000b\u0003\u0007\u0007\u000bQ!\u00199qYf$\u0002\"a7\u0004\u001a\u000em5Q\u0014\u0005\b\u0003w\u0003\u0003\u0019AA`\u0011\u001d\t9\r\ta\u0001\u0003\u0017Dq!a\n!\u0001\u0004\tY#A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\r\r6q\u0016\t\u0006O\u000e\u00156\u0011V\u0005\u0004\u0007OC'AB(qi&|g\u000eE\u0005h\u0007W\u000by,a3\u0002,%\u00191Q\u00165\u0003\rQ+\b\u000f\\34\u0011%\u0019\t,IA\u0001\u0002\u0004\tY.A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u00111q\u0017\t\u0005\u0003/\u0019I,\u0003\u0003\u0004<\u0006e!AB(cU\u0016\u001cG/A\rK_V\u0014h.\u00197GC2d'-Y2l\u0007>tg-[4QCRD\u0017A\u0007&pkJt\u0017\r\u001c$bY2\u0014\u0017mY6D_:4\u0017n\u001a)bi\"\u0004\u0013aH*oCB\u001c\bn\u001c;Ti>\u0014XMR1mY\n\f7m[\"p]\u001aLw\rU1uQ\u0006\u00013K\\1qg\"|Go\u0015;pe\u00164\u0015\r\u001c7cC\u000e\\7i\u001c8gS\u001e\u0004\u0016\r\u001e5!\u0003a1XM]5gsBcWoZ5o\u0007>tg-[4Fq&\u001cHo\u001d\u000b\t\u00057\u001aIma3\u0004P\"9\u0011qE\u0014A\u0002\u0005-\u0002bBBgO\u0001\u0007\u0011\u0011U\u0001\ta2,x-\u001b8JI\"91\u0011[\u0014A\u0002\u0005\u0005\u0016A\u00039mk\u001eLg\u000eV=qK\"\u001aq%!\u0014\u00027Y,'/\u001b4z!2,x-\u001b8D_:4\u0017nZ%t\t\u00164\u0017N\\3e)\u0019\u0011Yf!7\u0004\\\"91Q\u001a\u0015A\u0002\u0005\u0005\u0006bBBiQ\u0001\u0007\u0011\u0011\u0015\u0015\u0004Q\u00055\u0013aB5t\u000b6\u0004H/\u001f\u000b\u0005\u0005\u007f\u0019\u0019\u000fC\u0004\u0004f&\u0002\r!!)\u0002\tQ,\u0007\u0010\u001e")
public class Persistence
implements Extension {
    private String defaultJournalPluginId;
    private String defaultSnapshotPluginId;
    private StashOverflowStrategy defaultInternalStashOverflowStrategy;
    private final ExtendedActorSystem system;
    private String NoSnapshotStorePluginId;
    private final Config config;
    @InternalApi
    private final ActorRef recoveryPermitter;
    private final PersistenceSettings settings;
    private final AtomicReference<Map<String, ExtensionId<PluginHolder>>> pluginExtensionId;
    private volatile byte bitmap$0;

    public static String SnapshotStoreFallbackConfigPath() {
        return Persistence$.MODULE$.SnapshotStoreFallbackConfigPath();
    }

    public static String JournalFallbackConfigPath() {
        return Persistence$.MODULE$.JournalFallbackConfigPath();
    }

    public static Persistence$ lookup() {
        return Persistence$.MODULE$.lookup();
    }

    public static Persistence createExtension(ExtendedActorSystem extendedActorSystem) {
        return Persistence$.MODULE$.createExtension(extendedActorSystem);
    }

    public static Persistence get(ClassicActorSystemProvider classicActorSystemProvider) {
        return Persistence$.MODULE$.get(classicActorSystemProvider);
    }

    public static Persistence get(ActorSystem actorSystem) {
        return Persistence$.MODULE$.get(actorSystem);
    }

    public static Extension apply(ClassicActorSystemProvider classicActorSystemProvider) {
        return Persistence$.MODULE$.apply(classicActorSystemProvider);
    }

    public static Extension apply(ActorSystem actorSystem) {
        return Persistence$.MODULE$.apply(actorSystem);
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public LoggingAdapter org$apache$pekko$persistence$Persistence$$log() {
        return Logging$.MODULE$.apply((ActorSystem)this.system(), Persistence.class, LogSource$.MODULE$.fromAnyClass());
    }

    private String NoSnapshotStorePluginId() {
        return this.NoSnapshotStorePluginId;
    }

    private Config config() {
        return this.config;
    }

    public ActorRef recoveryPermitter() {
        return this.recoveryPermitter;
    }

    /*
     * WARNING - void declaration
     */
    private String defaultJournalPluginId$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                void var1_1;
                String configPath = this.config().getString("journal.plugin");
                Persistence$.MODULE$.verifyPluginConfigIsDefined(configPath, "Default journal");
                this.verifyJournalPluginConfigExists(ConfigFactory.empty(), configPath);
                this.defaultJournalPluginId = var1_1;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.defaultJournalPluginId;
    }

    private String defaultJournalPluginId() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.defaultJournalPluginId$lzycompute();
        }
        return this.defaultJournalPluginId;
    }

    /*
     * WARNING - void declaration
     */
    private String defaultSnapshotPluginId$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                String string;
                String configPath = this.config().getString("snapshot-store.plugin");
                if (Persistence$.MODULE$.org$apache$pekko$persistence$Persistence$$isEmpty(configPath)) {
                    this.org$apache$pekko$persistence$Persistence$$log().warning("No default snapshot store configured! To configure a default snapshot-store plugin set the `pekko.persistence.snapshot-store.plugin` key. For details see 'reference.conf'");
                    string = this.NoSnapshotStorePluginId();
                } else {
                    void var1_1;
                    this.verifySnapshotPluginConfigExists(ConfigFactory.empty(), configPath);
                    string = var1_1;
                }
                this.defaultSnapshotPluginId = string;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        this.NoSnapshotStorePluginId = null;
        return this.defaultSnapshotPluginId;
    }

    private String defaultSnapshotPluginId() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.defaultSnapshotPluginId$lzycompute();
        }
        return this.defaultSnapshotPluginId;
    }

    private StashOverflowStrategy defaultInternalStashOverflowStrategy$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.defaultInternalStashOverflowStrategy = (StashOverflowStrategy)this.system().dynamicAccess().createInstanceFor(this.config().getString("internal-stash-overflow-strategy"), (scala.collection.immutable.Seq)Collections.EmptyImmutableSeq$.MODULE$, ClassTag$.MODULE$.apply(StashOverflowStrategyConfigurator.class)).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.create(this.system().settings().config())).get();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.defaultInternalStashOverflowStrategy;
    }

    public StashOverflowStrategy defaultInternalStashOverflowStrategy() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.defaultInternalStashOverflowStrategy$lzycompute();
        }
        return this.defaultInternalStashOverflowStrategy;
    }

    public PersistenceSettings settings() {
        return this.settings;
    }

    private AtomicReference<Map<String, ExtensionId<PluginHolder>>> pluginExtensionId() {
        return this.pluginExtensionId;
    }

    private void verifyJournalPluginConfigExists(Config pluginConfig, String configPath) {
        Persistence$.MODULE$.verifyPluginConfigExists(pluginConfig.withFallback((ConfigMergeable)this.system().settings().config()), configPath, "Journal");
    }

    private void verifySnapshotPluginConfigExists(Config pluginConfig, String configPath) {
        Persistence$.MODULE$.verifyPluginConfigExists(pluginConfig.withFallback((ConfigMergeable)this.system().settings().config()), configPath, "Snapshot store");
    }

    public final EventAdapters adaptersFor(String journalPluginId) {
        return this.adaptersFor(journalPluginId, ConfigFactory.empty());
    }

    public final EventAdapters adaptersFor(String journalPluginId, Config journalPluginConfig) {
        String configPath = Persistence$.MODULE$.org$apache$pekko$persistence$Persistence$$isEmpty(journalPluginId) ? this.defaultJournalPluginId() : journalPluginId;
        this.verifyJournalPluginConfigExists(journalPluginConfig, configPath);
        return this.pluginHolderFor(configPath, Persistence$.MODULE$.JournalFallbackConfigPath(), journalPluginConfig).adapters();
    }

    public final EventAdapters adaptersFor(ActorRef journalPluginActor) {
        Option option = ((MapLike)this.pluginExtensionId().get()).values().collectFirst((PartialFunction)new scala.Serializable(this, journalPluginActor){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Persistence $outer;
            private final ActorRef journalPluginActor$1;

            public final <A1 extends ExtensionId<PluginHolder>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                ActorRef actorRef = ((PluginHolder)x1.apply((ActorSystem)this.$outer.system())).actor();
                ActorRef actorRef2 = this.journalPluginActor$1;
                if (!(actorRef != null ? !actorRef.equals(actorRef2) : actorRef2 != null)) {
                    return (B1)((PluginHolder)x1.apply((ActorSystem)this.$outer.system())).adapters();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(ExtensionId<PluginHolder> x1) {
                ActorRef actorRef = ((PluginHolder)x1.apply((ActorSystem)this.$outer.system())).actor();
                ActorRef actorRef2 = this.journalPluginActor$1;
                return !(actorRef != null ? !actorRef.equals(actorRef2) : actorRef2 != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.journalPluginActor$1 = journalPluginActor$1;
            }
        });
        if (option instanceof Some) {
            return (EventAdapters)((Some)option).value();
        }
        return IdentityEventAdapters$.MODULE$;
    }

    public final Config journalConfigFor(String journalPluginId, Config journalPluginConfig) {
        String configPath = Persistence$.MODULE$.org$apache$pekko$persistence$Persistence$$isEmpty(journalPluginId) ? this.defaultJournalPluginId() : journalPluginId;
        this.verifyJournalPluginConfigExists(journalPluginConfig, configPath);
        return this.pluginHolderFor(configPath, Persistence$.MODULE$.JournalFallbackConfigPath(), journalPluginConfig).config();
    }

    public final Config journalConfigFor$default$2() {
        return ConfigFactory.empty();
    }

    public final Config configFor(ActorRef journalPluginActor) {
        Option option = ((MapLike)this.pluginExtensionId().get()).values().collectFirst((PartialFunction)new scala.Serializable(this, journalPluginActor){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Persistence $outer;
            private final ActorRef journalPluginActor$2;

            public final <A1 extends ExtensionId<PluginHolder>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                ActorRef actorRef = ((PluginHolder)x1.apply((ActorSystem)this.$outer.system())).actor();
                ActorRef actorRef2 = this.journalPluginActor$2;
                if (!(actorRef != null ? !actorRef.equals(actorRef2) : actorRef2 != null)) {
                    return (B1)((PluginHolder)x1.apply((ActorSystem)this.$outer.system())).config();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(ExtensionId<PluginHolder> x1) {
                ActorRef actorRef = ((PluginHolder)x1.apply((ActorSystem)this.$outer.system())).actor();
                ActorRef actorRef2 = this.journalPluginActor$2;
                return !(actorRef != null ? !actorRef.equals(actorRef2) : actorRef2 != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.journalPluginActor$2 = journalPluginActor$2;
            }
        });
        if (option instanceof Some) {
            return (Config)((Some)option).value();
        }
        if (None$.MODULE$.equals(option)) {
            throw new IllegalArgumentException(new StringBuilder(21).append("Unknown plugin actor ").append(journalPluginActor).toString());
        }
        throw new MatchError((Object)option);
    }

    @InternalStableApi
    public final ActorRef journalFor(String journalPluginId, Config journalPluginConfig) {
        String configPath = Persistence$.MODULE$.org$apache$pekko$persistence$Persistence$$isEmpty(journalPluginId) ? this.defaultJournalPluginId() : journalPluginId;
        this.verifyJournalPluginConfigExists(journalPluginConfig, configPath);
        return this.pluginHolderFor(configPath, Persistence$.MODULE$.JournalFallbackConfigPath(), journalPluginConfig).actor();
    }

    public final Config journalFor$default$2() {
        return ConfigFactory.empty();
    }

    @InternalStableApi
    public final ActorRef snapshotStoreFor(String snapshotPluginId, Config snapshotPluginConfig) {
        String configPath = Persistence$.MODULE$.org$apache$pekko$persistence$Persistence$$isEmpty(snapshotPluginId) ? this.defaultSnapshotPluginId() : snapshotPluginId;
        this.verifySnapshotPluginConfigExists(snapshotPluginConfig, configPath);
        return this.pluginHolderFor(configPath, Persistence$.MODULE$.SnapshotStoreFallbackConfigPath(), snapshotPluginConfig).actor();
    }

    public final Config snapshotStoreFor$default$2() {
        return ConfigFactory.empty();
    }

    private PluginHolder pluginHolderFor(String configPath, String fallbackPath, Config additionalConfig) {
        Option option;
        while (true) {
            Map<String, ExtensionId<PluginHolder>> extensionIdMap;
            if ((option = (extensionIdMap = this.pluginExtensionId().get()).get((Object)configPath)) instanceof Some) {
                return (PluginHolder)((ExtensionId)((Some)option).value()).apply((ActorSystem)this.system());
            }
            if (!None$.MODULE$.equals(option)) break;
            PluginHolderExtensionId extensionId = new PluginHolderExtensionId(this, configPath, fallbackPath, additionalConfig);
            this.pluginExtensionId().compareAndSet(extensionIdMap, (Map<String, ExtensionId<PluginHolder>>)extensionIdMap.updated((Object)configPath, (Object)extensionId));
        }
        throw new MatchError((Object)option);
    }

    public ActorRef org$apache$pekko$persistence$Persistence$$createPlugin(String configPath, Config pluginConfig) {
        .colon.colon colon2;
        String pluginDispatcherId;
        Class pluginClass;
        block7: {
            String pluginClassName = pluginConfig.getString("class");
            if (Persistence$.MODULE$.org$apache$pekko$persistence$Persistence$$isEmpty(pluginClassName)) {
                throw new IllegalArgumentException(new StringBuilder(61).append("Plugin class name must be defined in config property [").append(configPath).append(".class]").toString());
            }
            this.org$apache$pekko$persistence$Persistence$$log().debug(new StringBuilder(16).append("Create plugin: ").append(configPath).append(" ").append(pluginClassName).toString());
            pluginClass = (Class)this.system().dynamicAccess().getClassFor(pluginClassName, ClassTag$.MODULE$.Any()).get();
            pluginDispatcherId = pluginConfig.getString("plugin-dispatcher");
            try {
                Reflect$.MODULE$.findConstructor(pluginClass, (scala.collection.immutable.Seq)new .colon.colon((Object)pluginConfig, (List)new .colon.colon((Object)configPath, (List)Nil$.MODULE$)));
                colon2 = new .colon.colon((Object)pluginConfig, (List)new .colon.colon((Object)configPath, (List)Nil$.MODULE$));
            }
            catch (Throwable throwable) {
                if (!NonFatal$.MODULE$.unapply(throwable).isEmpty()) {
                    try {
                        Reflect$.MODULE$.findConstructor(pluginClass, (scala.collection.immutable.Seq)new .colon.colon((Object)pluginConfig, (List)Nil$.MODULE$));
                        colon2 = new .colon.colon((Object)pluginConfig, (List)Nil$.MODULE$);
                    }
                    catch (Throwable throwable2) {
                        if (!NonFatal$.MODULE$.unapply(throwable2).isEmpty()) {
                            colon2 = Nil$.MODULE$;
                            break block7;
                        }
                        throw throwable2;
                    }
                }
                throw throwable;
            }
        }
        .colon.colon pluginActorArgs = colon2;
        String x$2 = Deploy$.MODULE$.apply$default$1();
        Config x$3 = Deploy$.MODULE$.apply$default$2();
        RouterConfig x$4 = Deploy$.MODULE$.apply$default$3();
        Scope x$5 = Deploy$.MODULE$.apply$default$4();
        String x$6 = Deploy$.MODULE$.apply$default$6();
        Props pluginActorProps = new Props(Deploy$.MODULE$.apply(x$2, x$3, x$4, x$5, pluginDispatcherId, x$6), pluginClass, (scala.collection.immutable.Seq)pluginActorArgs);
        return this.system().systemActorOf(pluginActorProps, configPath);
    }

    public EventAdapters org$apache$pekko$persistence$Persistence$$createAdapters(String configPath, Config additionalConfig) {
        Config pluginConfig = additionalConfig.withFallback((ConfigMergeable)this.system().settings().config()).getConfig(configPath);
        return EventAdapters$.MODULE$.apply(this.system(), pluginConfig);
    }

    public String persistenceId(ActorRef persistentActor) {
        return this.id(persistentActor);
    }

    private String id(ActorRef ref) {
        return ref.path().toStringWithoutAddress();
    }

    public final int numberOfSlices() {
        return 1024;
    }

    public final int sliceForPersistenceId(String persistenceId) {
        return package$.MODULE$.abs(persistenceId.hashCode() % this.numberOfSlices());
    }

    public final IndexedSeq<Range> sliceRanges(int numberOfRanges) {
        int rangeSize = this.numberOfSlices() / numberOfRanges;
        Predef$.MODULE$.require(numberOfRanges * rangeSize == this.numberOfSlices(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(70).append("numberOfRanges [").append(numberOfRanges).append("] must be a whole number divisor of numberOfSlices [").append(this.numberOfSlices()).append("].").toString());
        return ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numberOfRanges).map((Function1 & Serializable & scala.Serializable)i -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(BoxesRunTime.unboxToInt((Object)i) * rangeSize), BoxesRunTime.unboxToInt((Object)i) * rangeSize + rangeSize), IndexedSeq$.MODULE$.canBuildFrom())).toVector();
    }

    public final java.util.List<Pair<Integer, Integer>> getSliceRanges(int numberOfRanges) {
        return (java.util.List)package.JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)this.sliceRanges(numberOfRanges).map((Function1 & Serializable & scala.Serializable)range -> new Pair((Object)range.min((Ordering)Ordering.Int$.MODULE$), (Object)range.max((Ordering)Ordering.Int$.MODULE$)), IndexedSeq$.MODULE$.canBuildFrom())).asJava();
    }

    public Persistence(ExtendedActorSystem system) {
        this.system = system;
        this.NoSnapshotStorePluginId = "pekko.persistence.no-snapshot-store";
        this.config = system.settings().config().getConfig("pekko.persistence");
        int maxPermits = this.config().getInt("max-concurrent-recoveries");
        this.recoveryPermitter = system.systemActorOf(RecoveryPermitter$.MODULE$.props(maxPermits), "recoveryPermitter");
        this.settings = new PersistenceSettings(this.config());
        this.pluginExtensionId = new AtomicReference<Map>(Predef$.MODULE$.Map().empty());
        this.config().getStringList("journal.auto-start-journals").forEach(new Consumer<String>(this){
            private final /* synthetic */ Persistence $outer;

            public Consumer<String> andThen(Consumer<? super String> x$1) {
                return Consumer.super.andThen(x$1);
            }

            public void accept(String id) {
                this.$outer.org$apache$pekko$persistence$Persistence$$log().info(new StringBuilder(31).append("Auto-starting journal plugin `").append(id).append("`").toString());
                this.$outer.journalFor(id, this.$outer.journalFor$default$2());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.config().getStringList("snapshot-store.auto-start-snapshot-stores").forEach(new Consumer<String>(this){
            private final /* synthetic */ Persistence $outer;

            public Consumer<String> andThen(Consumer<? super String> x$1) {
                return Consumer.super.andThen(x$1);
            }

            public void accept(String id) {
                this.$outer.org$apache$pekko$persistence$Persistence$$log().info(new StringBuilder(31).append("Auto-starting snapshot store `").append(id).append("`").toString());
                this.$outer.snapshotStoreFor(id, this.$outer.snapshotStoreFor$default$2());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static class PluginHolder
    implements Extension,
    Product,
    scala.Serializable {
        private ActorRef actor;
        private final Function0<ActorRef> actorFactory;
        private final EventAdapters adapters;
        private final Config config;
        private volatile boolean bitmap$0;

        public Function0<ActorRef> actorFactory() {
            return this.actorFactory;
        }

        public EventAdapters adapters() {
            return this.adapters;
        }

        public Config config() {
            return this.config;
        }

        private ActorRef actor$lzycompute() {
            synchronized (this) {
                if (!this.bitmap$0) {
                    this.actor = (ActorRef)this.actorFactory().apply();
                    this.bitmap$0 = true;
                }
            }
            return this.actor;
        }

        public ActorRef actor() {
            if (!this.bitmap$0) {
                return this.actor$lzycompute();
            }
            return this.actor;
        }

        public PluginHolder copy(Function0<ActorRef> actorFactory, EventAdapters adapters, Config config) {
            return new PluginHolder(actorFactory, adapters, config);
        }

        public Function0<ActorRef> copy$default$1() {
            return this.actorFactory();
        }

        public EventAdapters copy$default$2() {
            return this.adapters();
        }

        public Config copy$default$3() {
            return this.config();
        }

        public String productPrefix() {
            return "PluginHolder";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.actorFactory();
                }
                case 1: {
                    return this.adapters();
                }
                case 2: {
                    return this.config();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof PluginHolder;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof PluginHolder)) break block3;
                    PluginHolder pluginHolder = (PluginHolder)x$1;
                    Function0<ActorRef> function0 = this.actorFactory();
                    Function0<ActorRef> function02 = pluginHolder.actorFactory();
                    if (function0 != null ? !function0.equals(function02) : function02 != null) break block3;
                    EventAdapters eventAdapters = this.adapters();
                    EventAdapters eventAdapters2 = pluginHolder.adapters();
                    if (eventAdapters != null ? !eventAdapters.equals(eventAdapters2) : eventAdapters2 != null) break block3;
                    Config config = this.config();
                    Config config2 = pluginHolder.config();
                    if ((config != null ? !config.equals(config2) : config2 != null) || !pluginHolder.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public PluginHolder(Function0<ActorRef> actorFactory, EventAdapters adapters, Config config) {
            this.actorFactory = actorFactory;
            this.adapters = adapters;
            this.config = config;
            Product.$init$((Product)this);
        }
    }

    private class PluginHolderExtensionId
    implements ExtensionId<PluginHolder> {
        private final String configPath;
        private final String fallbackPath;
        private final Config additionalConfig;
        public final /* synthetic */ Persistence $outer;

        public Extension apply(ActorSystem system) {
            return ExtensionId.apply$((ExtensionId)this, (ActorSystem)system);
        }

        public Extension apply(ClassicActorSystemProvider system) {
            return ExtensionId.apply$((ExtensionId)this, (ClassicActorSystemProvider)system);
        }

        public Extension get(ActorSystem system) {
            return ExtensionId.get$((ExtensionId)this, (ActorSystem)system);
        }

        public Extension get(ClassicActorSystemProvider system) {
            return ExtensionId.get$((ExtensionId)this, (ClassicActorSystemProvider)system);
        }

        public final int hashCode() {
            return ExtensionId.hashCode$((ExtensionId)this);
        }

        public final boolean equals(Object other) {
            return ExtensionId.equals$((ExtensionId)this, (Object)other);
        }

        public PluginHolder createExtension(ExtendedActorSystem system) {
            Config mergedConfig = this.additionalConfig.withFallback((ConfigMergeable)system.settings().config());
            Predef$.MODULE$.require(!Persistence$.MODULE$.org$apache$pekko$persistence$Persistence$$isEmpty(this.configPath) && mergedConfig.hasPath(this.configPath), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("'reference.conf' is missing persistence plugin config path: '").append($this.configPath).append("'").toString());
            Config config = mergedConfig.getConfig(this.configPath).withFallback((ConfigMergeable)mergedConfig.getConfig(this.fallbackPath));
            Function0 & Serializable & scala.Serializable pluginActorFactory = (Function0 & Serializable & scala.Serializable)() -> this.org$apache$pekko$persistence$Persistence$PluginHolderExtensionId$$$outer().org$apache$pekko$persistence$Persistence$$createPlugin($this.configPath, config);
            EventAdapters adapters = this.org$apache$pekko$persistence$Persistence$PluginHolderExtensionId$$$outer().org$apache$pekko$persistence$Persistence$$createAdapters(this.configPath, mergedConfig);
            return new PluginHolder((Function0<ActorRef>)pluginActorFactory, adapters, config);
        }

        public /* synthetic */ Persistence org$apache$pekko$persistence$Persistence$PluginHolderExtensionId$$$outer() {
            return this.$outer;
        }

        public PluginHolderExtensionId(Persistence $outer, String configPath, String fallbackPath, Config additionalConfig) {
            this.configPath = configPath;
            this.fallbackPath = fallbackPath;
            this.additionalConfig = additionalConfig;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            ExtensionId.$init$((ExtensionId)this);
        }

        public PluginHolderExtensionId(Persistence $outer, String configPath, String fallbackPath) {
            this($outer, configPath, fallbackPath, ConfigFactory.empty());
        }
    }
}

