/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.persistence.serialization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.OutputStream;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.ExtendedActorSystem;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.persistence.serialization.Snapshot;
import org.apache.pekko.serialization.BaseSerializer;
import org.apache.pekko.serialization.Serialization;
import org.apache.pekko.serialization.Serialization$;
import org.apache.pekko.serialization.SerializationExtension$;
import org.apache.pekko.serialization.Serializer;
import org.apache.pekko.serialization.Serializers$;
import org.apache.pekko.util.ByteString$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005eb\u0001B\b\u0011\u0001mA\u0001b\n\u0001\u0003\u0006\u0004%\t\u0001\u000b\u0005\t_\u0001\u0011\t\u0011)A\u0005S!)\u0001\u0007\u0001C\u0001c!9Q\u0007\u0001b\u0001\n\u00032\u0004B\u0002\u001e\u0001A\u0003%q\u0007\u0003\u0005\u0012\u0001!\u0015\r\u0011\"\u0003<\u0011\u0015y\u0004\u0001\"\u0001A\u0011\u0015I\u0005\u0001\"\u0001K\u0011\u0015I\u0007\u0001\"\u0003k\u0011\u0015\u0011\b\u0001\"\u0003t\u0011\u0015q\b\u0001\"\u0003\u0000\u0011\u001d\t\u0019\u0001\u0001C\u0005\u0003\u000bAq!!\u0003\u0001\t\u0013\tY\u0001C\u0004\u0002,\u0001!I!!\f\u0003%Ms\u0017\r]:i_R\u001cVM]5bY&TXM\u001d\u0006\u0003#I\tQb]3sS\u0006d\u0017N_1uS>t'BA\n\u0015\u0003-\u0001XM]:jgR,gnY3\u000b\u0005U1\u0012!\u00029fW.|'BA\f\u0019\u0003\u0019\t\u0007/Y2iK*\t\u0011$A\u0002pe\u001e\u001c\u0001aE\u0002\u00019\t\u0002\"!\b\u0011\u000e\u0003yQ\u0011aH\u0001\u0006g\u000e\fG.Y\u0005\u0003Cy\u0011a!\u00118z%\u00164\u0007CA\u0012&\u001b\u0005!#BA\t\u0015\u0013\t1CE\u0001\bCCN,7+\u001a:jC2L'0\u001a:\u0002\rML8\u000f^3n+\u0005I\u0003C\u0001\u0016.\u001b\u0005Y#B\u0001\u0017\u0015\u0003\u0015\t7\r^8s\u0013\tq3FA\nFqR,g\u000eZ3e\u0003\u000e$xN]*zgR,W.A\u0004tsN$X-\u001c\u0011\u0002\rqJg.\u001b;?)\t\u0011D\u0007\u0005\u00024\u00015\t\u0001\u0003C\u0003(\u0007\u0001\u0007\u0011&A\bj]\u000edW\u000fZ3NC:Lg-Z:u+\u00059\u0004CA\u000f9\u0013\tIdDA\u0004C_>dW-\u00198\u0002!%t7\r\\;eK6\u000bg.\u001b4fgR\u0004S#\u0001\u001f\u0011\u0005\rj\u0014B\u0001 %\u00055\u0019VM]5bY&T\u0018\r^5p]\u0006AAo\u001c\"j]\u0006\u0014\u0018\u0010\u0006\u0002B\u000fB\u0019QD\u0011#\n\u0005\rs\"!B!se\u0006L\bCA\u000fF\u0013\t1eD\u0001\u0003CsR,\u0007\"\u0002%\b\u0001\u0004a\u0012!A8\u0002\u0015\u0019\u0014x.\u001c\"j]\u0006\u0014\u0018\u0010F\u0002\u001d\u00176CQ\u0001\u0014\u0005A\u0002\u0005\u000bQAY=uKNDQA\u0014\u0005A\u0002=\u000b\u0001\"\\1oS\u001a,7\u000f\u001e\t\u0004;A\u0013\u0016BA)\u001f\u0005\u0019y\u0005\u000f^5p]B\u00121\u000b\u0019\t\u0004)nsfBA+Z!\t1f$D\u0001X\u0015\tA&$\u0001\u0004=e>|GOP\u0005\u00035z\ta\u0001\u0015:fI\u00164\u0017B\u0001/^\u0005\u0015\u0019E.Y:t\u0015\tQf\u0004\u0005\u0002`A2\u0001A!C1N\u0003\u0003\u0005\tQ!\u0001c\u0005\ryF%M\t\u0003G\u001a\u0004\"!\b3\n\u0005\u0015t\"a\u0002(pi\"Lgn\u001a\t\u0003;\u001dL!\u0001\u001b\u0010\u0003\u0007\u0005s\u00170\u0001\biK\u0006$WM\u001d+p\u0005&t\u0017M]=\u0015\u0007\u0005[W\u000eC\u0003m\u0013\u0001\u0007A$\u0001\u0005t]\u0006\u00048\u000f[8u\u0011\u0015q\u0017\u00021\u0001p\u0003I\u0019h.\u00199tQ>$8+\u001a:jC2L'0\u001a:\u0011\u0005\r\u0002\u0018BA9%\u0005)\u0019VM]5bY&TXM]\u0001\u0011Q\u0016\fG-\u001a:Ge>l')\u001b8bef$\"\u0001^?\u0011\tu)xO_\u0005\u0003mz\u0011a\u0001V;qY\u0016\u0014\u0004CA\u000fy\u0013\tIhDA\u0002J]R\u0004\"\u0001V>\n\u0005ql&AB*ue&tw\rC\u0003M\u0015\u0001\u0007\u0011)\u0001\tt]\u0006\u00048\u000f[8u)>\u0014\u0015N\\1ssR\u0019\u0011)!\u0001\t\u000b1\\\u0001\u0019\u0001\u000f\u0002%Mt\u0017\r]:i_R4%o\\7CS:\f'/\u001f\u000b\u00049\u0005\u001d\u0001\"\u0002'\r\u0001\u0004\t\u0015\u0001C<sSR,\u0017J\u001c;\u0015\r\u00055\u00111CA\u0014!\ri\u0012qB\u0005\u0004\u0003#q\"\u0001B+oSRDq!!\u0006\u000e\u0001\u0004\t9\"A\u0002pkR\u0004B!!\u0007\u0002$5\u0011\u00111\u0004\u0006\u0005\u0003;\ty\"\u0001\u0002j_*\u0011\u0011\u0011E\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002&\u0005m!\u0001D(viB,Ho\u0015;sK\u0006l\u0007BBA\u0015\u001b\u0001\u0007q/A\u0001j\u0003\u001d\u0011X-\u00193J]R$2a^A\u0018\u0011\u001d\t\tD\u0004a\u0001\u0003g\t!!\u001b8\u0011\t\u0005e\u0011QG\u0005\u0005\u0003o\tYBA\u0006J]B,Ho\u0015;sK\u0006l\u0007")
public class SnapshotSerializer
implements BaseSerializer {
    private Serialization org$apache$pekko$persistence$serialization$SnapshotSerializer$$serialization;
    private final ExtendedActorSystem system;
    private final boolean includeManifest;
    private final int identifier;
    private volatile boolean bitmap$0;

    @InternalApi
    public int identifierFromConfig() {
        return BaseSerializer.identifierFromConfig$((BaseSerializer)this);
    }

    public final Object fromBinary(byte[] bytes) {
        return Serializer.fromBinary$((Serializer)this, (byte[])bytes);
    }

    public final Object fromBinary(byte[] bytes, Class<?> clazz) throws NotSerializableException {
        return Serializer.fromBinary$((Serializer)this, (byte[])bytes, clazz);
    }

    public int identifier() {
        return this.identifier;
    }

    public void org$apache$pekko$serialization$BaseSerializer$_setter_$identifier_$eq(int x$1) {
        this.identifier = x$1;
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public boolean includeManifest() {
        return this.includeManifest;
    }

    private Serialization serialization$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.org$apache$pekko$persistence$serialization$SnapshotSerializer$$serialization = (Serialization)SerializationExtension$.MODULE$.apply((ActorSystem)this.system());
                this.bitmap$0 = true;
            }
        }
        return this.org$apache$pekko$persistence$serialization$SnapshotSerializer$$serialization;
    }

    public Serialization org$apache$pekko$persistence$serialization$SnapshotSerializer$$serialization() {
        if (!this.bitmap$0) {
            return this.serialization$lzycompute();
        }
        return this.org$apache$pekko$persistence$serialization$SnapshotSerializer$$serialization;
    }

    public byte[] toBinary(Object o) {
        if (o instanceof Snapshot) {
            Object data = ((Snapshot)o).data();
            return this.snapshotToBinary(data);
        }
        throw new IllegalArgumentException(new StringBuilder(31).append("Can't serialize object of type ").append(o.getClass()).toString());
    }

    public Object fromBinary(byte[] bytes, Option<Class<?>> manifest) {
        return new Snapshot(this.snapshotFromBinary(bytes));
    }

    private byte[] headerToBinary(Object snapshot, Serializer snapshotSerializer) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.writeInt(out, snapshotSerializer.identifier());
        String ms = Serializers$.MODULE$.manifestFor(snapshotSerializer, snapshot);
        if (new StringOps(Predef$.MODULE$.augmentString(ms)).nonEmpty()) {
            out.write(ms.getBytes(ByteString$.MODULE$.UTF_8()));
        }
        return out.toByteArray();
    }

    private Tuple2<Object, String> headerFromBinary(byte[] bytes) {
        String string;
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        int serializerId = this.readInt(in);
        if ((serializerId & 0xEDAC) == 60844) {
            throw new NotSerializableException("Replaying snapshot from akka 2.3.x version is not supported any more");
        }
        int remaining = in.available();
        if (remaining == 0) {
            string = "";
        } else {
            byte[] manifestBytes = new byte[remaining];
            in.read(manifestBytes);
            string = new String(manifestBytes, ByteString$.MODULE$.UTF_8());
        }
        String manifest = string;
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)serializerId), (Object)manifest);
    }

    private byte[] snapshotToBinary(Object snapshot) {
        byte[] byArray;
        Serialization.Information oldInfo = (Serialization.Information)Serialization$.MODULE$.currentTransportInformation().value();
        try {
            if (oldInfo == null) {
                Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)this.system().provider().serializationInformation());
            }
            byArray = this.serialize$1(snapshot);
        }
        finally {
            Serialization$.MODULE$.currentTransportInformation().value_$eq((Object)oldInfo);
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    private Object snapshotFromBinary(byte[] bytes) {
        void var7_7;
        void var6_6;
        int headerLength = this.readInt(new ByteArrayInputStream(bytes));
        byte[] headerBytes = (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).slice(4, headerLength + 4);
        byte[] snapshotBytes = (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).drop(headerLength + 4);
        Tuple2<Object, String> tuple2 = this.headerFromBinary(headerBytes);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        int serializerId = tuple2._1$mcI$sp();
        String manifest = (String)tuple2._2();
        return this.org$apache$pekko$persistence$serialization$SnapshotSerializer$$serialization().deserialize(snapshotBytes, (int)var6_6, (String)var7_7).recoverWith((PartialFunction)new Serializable(this, (String)var7_7, snapshotBytes, (int)var6_6){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SnapshotSerializer $outer;
            private final String manifest$1;
            private final byte[] snapshotBytes$1;
            private final int serializerId$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                if (x1 instanceof NotSerializableException && this.manifest$1.startsWith("akka")) {
                    return (B1)this.$outer.org$apache$pekko$persistence$serialization$SnapshotSerializer$$serialization().deserialize(this.snapshotBytes$1, this.serializerId$1, this.manifest$1.replaceFirst("akka", "org.apache.pekko"));
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                return x1 instanceof NotSerializableException && this.manifest$1.startsWith("akka");
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.manifest$1 = manifest$1;
                this.snapshotBytes$1 = snapshotBytes$1;
                this.serializerId$1 = serializerId$1;
            }
        }).get();
    }

    private void writeInt(OutputStream out, int i) {
        out.write(i >>> 0);
        out.write(i >>> 8);
        out.write(i >>> 16);
        out.write(i >>> 24);
    }

    private int readInt(InputStream in) {
        int b1 = in.read();
        int b2 = in.read();
        int b3 = in.read();
        int b4 = in.read();
        if ((b1 | b2 | b3 | b3) == -1) {
            throw new EOFException();
        }
        return b4 << 24 | b3 << 16 | b2 << 8 | b1;
    }

    private final byte[] serialize$1(Object snapshot$1) {
        Serializer snapshotSerializer = this.org$apache$pekko$persistence$serialization$SnapshotSerializer$$serialization().findSerializerFor(snapshot$1);
        byte[] headerBytes = this.headerToBinary(snapshot$1, snapshotSerializer);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.writeInt(out, headerBytes.length);
        out.write(headerBytes);
        out.write(snapshotSerializer.toBinary(snapshot$1));
        return out.toByteArray();
    }

    public SnapshotSerializer(ExtendedActorSystem system) {
        this.system = system;
        Serializer.$init$((Serializer)this);
        BaseSerializer.$init$((BaseSerializer)this);
        this.includeManifest = false;
    }
}

